/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RandomAccessFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class APELink {
    private static final String APE_LINK_HEADER = "[Monkey's Audio Image Link File]";
    private static final String APE_LINK_IMAGE_FILE_TAG = "Image File=";
    private static final String APE_LINK_START_BLOCK_TAG = "Start Block=";
    private static final String APE_LINK_FINISH_BLOCK_TAG = "Finish Block=";
    protected boolean m_bIsLinkFile;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected String m_cImageFilename;

    public APELink(String pFilename) throws IOException {
        this.m_bIsLinkFile = false;
        this.m_nStartBlock = 0;
        this.m_nFinishBlock = 0;
        this.m_cImageFilename = "";
        RandomAccessFile ioLinkFile = new RandomAccessFile(new java.io.File(pFilename), "r");
        byte[] spBuffer = new byte[1024];
        int numRead = ((File)ioLinkFile).read(spBuffer);
        byte[] buffer = new byte[numRead];
        System.arraycopy(spBuffer, 0, buffer, 0, numRead);
        this.ParseData(buffer, pFilename);
    }

    public APELink(byte[] pData, String pFilename) {
        this.ParseData(pData, pFilename);
    }

    public boolean GetIsLinkFile() {
        return this.m_bIsLinkFile;
    }

    public int GetStartBlock() {
        return this.m_nStartBlock;
    }

    public int GetFinishBlock() {
        return this.m_nFinishBlock;
    }

    public String GetImageFilename() {
        return this.m_cImageFilename;
    }

    protected void ParseData(byte[] pData, String pFilename) {
        this.m_bIsLinkFile = false;
        this.m_nStartBlock = 0;
        this.m_nFinishBlock = 0;
        this.m_cImageFilename = "";
        if (pData != null) {
            String data = null;
            try {
                data = new String(pData, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new JMACException("Unsupported encoding", e);
            }
            int pHeader = data.indexOf(APE_LINK_HEADER);
            int pImageFile = data.indexOf(APE_LINK_IMAGE_FILE_TAG);
            int pStartBlock = data.indexOf(APE_LINK_START_BLOCK_TAG);
            int pFinishBlock = data.indexOf(APE_LINK_FINISH_BLOCK_TAG);
            if (pHeader >= 0 && pImageFile >= 0 && pStartBlock >= 0 && pFinishBlock >= 0) {
                int ij;
                int i1 = data.indexOf(13, pStartBlock);
                int i2 = data.indexOf(10, pStartBlock);
                int ii = i1 > 0 && i2 > 0 ? Math.min(i1, i2) : Math.max(i1, i2);
                try {
                    this.m_nStartBlock = Integer.parseInt(data.substring(pStartBlock + APE_LINK_START_BLOCK_TAG.length(), ii >= 0 ? ii : data.length()));
                }
                catch (Exception e) {
                    this.m_nStartBlock = -1;
                }
                i1 = data.indexOf(13, pFinishBlock);
                i2 = data.indexOf(10, pFinishBlock);
                ii = i1 > 0 && i2 > 0 ? Math.min(i1, i2) : Math.max(i1, i2);
                try {
                    this.m_nFinishBlock = Integer.parseInt(data.substring(pFinishBlock + APE_LINK_FINISH_BLOCK_TAG.length(), ii >= 0 ? ii : data.length()));
                }
                catch (Exception e) {
                    this.m_nFinishBlock = -1;
                }
                i1 = data.indexOf(13, pImageFile);
                i2 = data.indexOf(10, pImageFile);
                ii = i1 > 0 && i2 > 0 ? Math.min(i1, i2) : Math.max(i1, i2);
                String cImageFile = data.substring(pImageFile + APE_LINK_IMAGE_FILE_TAG.length(), ii >= 0 ? ii : data.length());
                this.m_cImageFilename = cImageFile.lastIndexOf(92) < 0 ? ((ij = pFilename.lastIndexOf(92)) >= 0 ? pFilename.substring(0, ij) + cImageFile : cImageFile) : cImageFile;
                this.m_bIsLinkFile = true;
            }
        }
    }
}

