/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.APETagField;
import de.quippy.jmac.info.APETagFooter;
import de.quippy.jmac.info.ID3Genre;
import de.quippy.jmac.info.ID3Tag;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RandomAccessFile;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class APETag
implements Comparator<APETagField> {
    public static final String APE_TAG_FIELD_TITLE = "Title";
    public static final String APE_TAG_FIELD_ARTIST = "Artist";
    public static final String APE_TAG_FIELD_ALBUM = "Album";
    public static final String APE_TAG_FIELD_COMMENT = "Comment";
    public static final String APE_TAG_FIELD_YEAR = "Year";
    public static final String APE_TAG_FIELD_TRACK = "Track";
    public static final String APE_TAG_FIELD_GENRE = "Genre";
    public static final String APE_TAG_FIELD_COVER_ART_FRONT = "Cover Art (front)";
    public static final String APE_TAG_FIELD_NOTES = "Notes";
    public static final String APE_TAG_FIELD_LYRICS = "Lyrics";
    public static final String APE_TAG_FIELD_COPYRIGHT = "Copyright";
    public static final String APE_TAG_FIELD_BUY_URL = "Buy URL";
    public static final String APE_TAG_FIELD_ARTIST_URL = "Artist URL";
    public static final String APE_TAG_FIELD_PUBLISHER_URL = "Publisher URL";
    public static final String APE_TAG_FIELD_FILE_URL = "File URL";
    public static final String APE_TAG_FIELD_COPYRIGHT_URL = "Copyright URL";
    public static final String APE_TAG_FIELD_MJ_METADATA = "Media Jukebox Metadata";
    public static final String APE_TAG_FIELD_TOOL_NAME = "Tool Name";
    public static final String APE_TAG_FIELD_TOOL_VERSION = "Tool Version";
    public static final String APE_TAG_FIELD_PEAK_LEVEL = "Peak Level";
    public static final String APE_TAG_FIELD_REPLAY_GAIN_RADIO = "Replay Gain (radio)";
    public static final String APE_TAG_FIELD_REPLAY_GAIN_ALBUM = "Replay Gain (album)";
    public static final String APE_TAG_FIELD_COMPOSER = "Composer";
    public static final String APE_TAG_FIELD_KEYWORDS = "Keywords";
    public static final int APE_TAG_FLAG_CONTAINS_HEADER = Integer.MIN_VALUE;
    public static final int APE_TAG_FLAG_CONTAINS_FOOTER = 0x40000000;
    public static final int APE_TAG_FLAG_IS_HEADER = 0x20000000;
    public static final int APE_TAG_FLAGS_DEFAULT = 0x40000000;
    public static final String APE_TAG_GENRE_UNDEFINED = "Undefined";
    private File m_spIO;
    private boolean m_bAnalyzed = false;
    private int m_nTagBytes = 0;
    private List<APETagField> m_aryFields = new ArrayList<APETagField>();
    private boolean m_bHasAPETag;
    private int m_nAPETagVersion;
    private boolean m_bHasID3Tag;
    private boolean m_bIgnoreReadOnly = false;
    private APETagFooter m_footer = null;

    public APETag(File pIO) throws IOException {
        this(pIO, true);
    }

    public APETag(File pIO, boolean bAnalyze) throws IOException {
        this.m_spIO = pIO;
        if (bAnalyze) {
            this.Analyze();
        }
    }

    public APETag(String pFilename) throws IOException {
        this(pFilename, true);
    }

    public APETag(String pFilename, boolean bAnalyze) throws IOException {
        this.m_spIO = new RandomAccessFile(new java.io.File(pFilename), "r");
        if (bAnalyze) {
            this.Analyze();
        }
    }

    public void SetFieldString(String pFieldName, String pFieldValue) throws IOException {
        if (pFieldValue == null || pFieldValue.length() <= 0) {
            this.RemoveField(pFieldName);
        } else {
            byte[] fieldValue = pFieldValue.getBytes("UTF-8");
            byte[] value = new byte[fieldValue.length];
            System.arraycopy(fieldValue, 0, value, 0, fieldValue.length);
            this.SetFieldBinary(pFieldName, value, 0);
        }
    }

    public void SetFieldBinary(String pFieldName, byte[] pFieldValue, int nFieldFlags) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (pFieldName == null) {
            return;
        }
        boolean bRemoving = pFieldValue == null || pFieldValue.length <= 0;
        int nFieldIndex = this.GetTagFieldIndex(pFieldName);
        if (nFieldIndex >= 0) {
            if (!this.m_bIgnoreReadOnly && this.m_aryFields.get(nFieldIndex).GetIsReadOnly()) {
                return;
            }
            if (bRemoving) {
                this.RemoveField(nFieldIndex);
            }
            this.m_aryFields.set(nFieldIndex, new APETagField(pFieldName, pFieldValue, nFieldFlags));
        } else {
            if (bRemoving) {
                return;
            }
            this.m_aryFields.add(new APETagField(pFieldName, pFieldValue, nFieldFlags));
        }
    }

    public byte[] GetFieldBinary(String pFieldName) throws IOException {
        APETagField pAPETagField;
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if ((pAPETagField = this.GetTagField(pFieldName)) == null) {
            return null;
        }
        return pAPETagField.GetFieldValue();
    }

    public String GetFieldString(String pFieldName) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        String ret = null;
        APETagField pAPETagField = this.GetTagField(pFieldName);
        if (pAPETagField != null) {
            byte[] b = pAPETagField.GetFieldValue();
            int boundary = 0;
            int index = b.length - 1;
            while (index >= 0 && b[index] == 0) {
                --index;
                --boundary;
            }
            ret = index < 0 ? "" : (pAPETagField.GetIsUTF8Text() || this.m_nAPETagVersion < 2000 ? (this.m_nAPETagVersion >= 2000 ? new String(b, 0, b.length + boundary, "UTF-8") : new String(b, 0, b.length + boundary, "US-ASCII")) : new String(b, 0, b.length + boundary, "UTF-16"));
        }
        return ret;
    }

    public void RemoveField(String pFieldName) throws IOException {
        this.RemoveField(this.GetTagFieldIndex(pFieldName));
    }

    public void RemoveField(int nIndex) {
        this.m_aryFields.remove(nIndex);
    }

    public void ClearFields() {
        this.m_aryFields.clear();
    }

    public int GetTagBytes() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_nTagBytes;
    }

    public boolean GetHasID3Tag() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_bHasID3Tag;
    }

    public boolean GetHasAPETag() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_bHasAPETag;
    }

    public int GetAPETagVersion() throws IOException {
        return this.GetHasAPETag() ? this.m_nAPETagVersion : -1;
    }

    public APETagField GetTagField(String pFieldName) throws IOException {
        int nIndex = this.GetTagFieldIndex(pFieldName);
        return nIndex != -1 ? this.m_aryFields.get(nIndex) : null;
    }

    public APETagField GetTagField(int nIndex) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (nIndex >= 0 && nIndex < this.m_aryFields.size()) {
            return this.m_aryFields.get(nIndex);
        }
        return null;
    }

    public void SetIgnoreReadOnly(boolean bIgnoreReadOnly) {
        this.m_bIgnoreReadOnly = bIgnoreReadOnly;
    }

    public void CreateID3Tag(ID3Tag pID3Tag) throws IOException {
        if (pID3Tag == null) {
            return;
        }
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (this.m_aryFields.size() <= 0) {
            return;
        }
        pID3Tag.Header = "TAG";
        pID3Tag.Artist = this.GetFieldID3String(APE_TAG_FIELD_ARTIST);
        pID3Tag.Album = this.GetFieldID3String(APE_TAG_FIELD_ALBUM);
        pID3Tag.Title = this.GetFieldID3String(APE_TAG_FIELD_TITLE);
        pID3Tag.Comment = this.GetFieldID3String(APE_TAG_FIELD_COMMENT);
        pID3Tag.Year = this.GetFieldID3String(APE_TAG_FIELD_YEAR);
        String track = this.GetFieldString(APE_TAG_FIELD_TRACK);
        try {
            pID3Tag.Track = Short.parseShort(track);
        }
        catch (Exception e) {
            pID3Tag.Track = (short)255;
        }
        pID3Tag.Genre = (short)new ID3Genre(this.GetFieldString(APE_TAG_FIELD_GENRE)).getGenre();
    }

    private void Analyze() throws IOException {
        this.ClearFields();
        this.m_nTagBytes = 0;
        this.m_bAnalyzed = true;
        long nOriginalPosition = this.m_spIO.getFilePointer();
        this.m_bHasID3Tag = false;
        this.m_bHasAPETag = false;
        this.m_nAPETagVersion = -1;
        ID3Tag tag = ID3Tag.read(this.m_spIO);
        if (tag != null) {
            this.m_bHasID3Tag = true;
            this.m_nTagBytes += 128;
        }
        if (this.m_bHasID3Tag && tag != null) {
            this.SetFieldID3String(APE_TAG_FIELD_ARTIST, tag.Artist);
            this.SetFieldID3String(APE_TAG_FIELD_ALBUM, tag.Album);
            this.SetFieldID3String(APE_TAG_FIELD_TITLE, tag.Title);
            this.SetFieldID3String(APE_TAG_FIELD_COMMENT, tag.Comment);
            this.SetFieldID3String(APE_TAG_FIELD_YEAR, tag.Year);
            this.SetFieldString(APE_TAG_FIELD_TRACK, String.valueOf(tag.Track));
            if (tag.Genre == 255 || tag.Genre >= ID3Genre.genreCount()) {
                this.SetFieldString(APE_TAG_FIELD_GENRE, APE_TAG_GENRE_UNDEFINED);
            } else {
                this.SetFieldString(APE_TAG_FIELD_GENRE, ID3Genre.genreString(tag.Genre));
            }
        }
        if (!this.m_bHasID3Tag) {
            this.m_footer = APETagFooter.read(this.m_spIO);
            if (this.m_footer != null && this.m_footer.GetIsValid(false)) {
                this.m_bHasAPETag = true;
                this.m_nAPETagVersion = this.m_footer.GetVersion();
                int nRawFieldBytes = this.m_footer.GetFieldBytes();
                this.m_nTagBytes += this.m_footer.GetTotalTagBytes();
                this.m_spIO.seek(this.m_spIO.length() - (long)this.m_footer.GetTotalTagBytes() - (long)this.m_footer.GetFieldsOffset());
                try {
                    ByteArrayReader reader = new ByteArrayReader(this.m_spIO, nRawFieldBytes);
                    for (int z = 0; z < this.m_footer.GetNumberFields(); ++z) {
                        this.LoadField(reader);
                    }
                }
                catch (EOFException e) {
                    throw new JMACException("Can't Read APE Tag Fields");
                }
            }
        }
        this.m_spIO.seek(nOriginalPosition);
    }

    private int GetTagFieldIndex(String pFieldName) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (pFieldName == null) {
            return -1;
        }
        for (int z = 0; z < this.m_aryFields.size(); ++z) {
            if (!pFieldName.toLowerCase().equals(this.m_aryFields.get(z).GetFieldName().toLowerCase())) continue;
            return z;
        }
        return -1;
    }

    private void LoadField(ByteArrayReader reader) throws IOException {
        int nFieldValueSize = reader.readInt();
        int nFieldFlags = reader.readInt();
        String fieldName = reader.readString("UTF-8");
        byte[] fieldValue = new byte[nFieldValueSize];
        reader.readFully(fieldValue);
        this.SetFieldBinary(fieldName, fieldValue, nFieldFlags);
    }

    @Override
    public int compare(APETagField pFieldA, APETagField pFieldB) {
        return pFieldA.GetFieldSize() - pFieldB.GetFieldSize();
    }

    private String GetFieldID3String(String pFieldName) throws IOException {
        return this.GetFieldString(pFieldName);
    }

    private void SetFieldID3String(String pFieldName, String pFieldValue) throws IOException {
        this.SetFieldString(pFieldName, pFieldValue.trim());
    }

    public APETagFooter getFooter() {
        return this.m_footer;
    }
}

