/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import java.io.EOFException;
import java.io.IOException;

public class ID3Tag {
    public String Header;
    public String Title;
    public String Artist;
    public String Album;
    public String Year;
    public String Comment;
    public short Track;
    public short Genre;
    public static final int ID3_TAG_BYTES = 128;

    public static final ID3Tag read(File file) throws IOException {
        file.seek(file.length() - 128L);
        try {
            ID3Tag tag = new ID3Tag();
            ByteArrayReader reader = new ByteArrayReader(file, 128);
            tag.Header = reader.readString(3, "US-ASCII");
            tag.Title = reader.readString(30, "US-ASCII");
            tag.Artist = reader.readString(30, "US-ASCII");
            tag.Album = reader.readString(30, "US-ASCII");
            tag.Year = reader.readString(4, "US-ASCII");
            tag.Comment = reader.readString(29, "US-ASCII");
            tag.Track = reader.readUnsignedByte();
            tag.Genre = reader.readUnsignedByte();
            return tag.Header.equals("TAG") ? tag : null;
        }
        catch (EOFException e) {
            return null;
        }
    }

    public final void write(ByteArrayWriter writer) {
        writer.writeString(this.Header, 3, "US-ASCII");
        writer.writeString(this.Title, 30, "US-ASCII");
        writer.writeString(this.Artist, 30, "US-ASCII");
        writer.writeString(this.Album, 30, "US-ASCII");
        writer.writeString(this.Year, 4, "US-ASCII");
        writer.writeString(this.Comment, 29, "US-ASCII");
        writer.writeUnsignedByte(this.Track);
        writer.writeUnsignedByte(this.Genre);
    }
}

