/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import java.io.EOFException;
import java.io.IOException;

public class WaveHeader {
    public static final int WAVE_HEADER_BYTES = 44;
    public String cRIFFHeader;
    public long nRIFFBytes;
    public String cDataTypeID;
    public String cFormatHeader;
    public long nFormatBytes;
    public int nFormatTag;
    public int nChannels;
    public long nSamplesPerSec;
    public long nAvgBytesPerSec;
    public int nBlockAlign;
    public int nBitsPerSample;
    public String cDataHeader;
    public long nDataBytes;

    public static void FillWaveHeader(WaveHeader pWAVHeader, int nAudioBytes, WaveFormat pWaveFormatEx, int nTerminatingBytes) {
        pWAVHeader.cRIFFHeader = "RIFF";
        pWAVHeader.nRIFFBytes = nAudioBytes + 44 - 8 + nTerminatingBytes;
        pWAVHeader.cDataTypeID = "WAVE";
        pWAVHeader.cFormatHeader = "fmt ";
        pWAVHeader.nFormatBytes = 16L;
        pWAVHeader.nFormatTag = pWaveFormatEx.wFormatTag;
        pWAVHeader.nChannels = pWaveFormatEx.nChannels;
        pWAVHeader.nSamplesPerSec = pWaveFormatEx.nSamplesPerSec;
        pWAVHeader.nAvgBytesPerSec = pWaveFormatEx.nAvgBytesPerSec;
        pWAVHeader.nBlockAlign = pWaveFormatEx.nBlockAlign;
        pWAVHeader.nBitsPerSample = pWaveFormatEx.wBitsPerSample;
        pWAVHeader.cDataHeader = "data";
        pWAVHeader.nDataBytes = nAudioBytes;
    }

    public static final WaveHeader read(File file) throws IOException {
        try {
            ByteArrayReader reader = new ByteArrayReader(file, 44);
            return WaveHeader.read(reader);
        }
        catch (EOFException e) {
            return null;
        }
    }

    public static final WaveHeader read(byte[] data) {
        ByteArrayReader reader = new ByteArrayReader(data);
        return WaveHeader.read(reader);
    }

    private static final WaveHeader read(ByteArrayReader reader) {
        WaveHeader header = new WaveHeader();
        header.cRIFFHeader = reader.readString(4, "US-ASCII");
        header.nRIFFBytes = reader.readUnsignedInt();
        header.cDataTypeID = reader.readString(4, "US-ASCII");
        header.cFormatHeader = reader.readString(4, "US-ASCII");
        header.nFormatBytes = reader.readUnsignedInt();
        header.nFormatTag = reader.readUnsignedShort();
        header.nChannels = reader.readUnsignedShort();
        header.nSamplesPerSec = reader.readUnsignedInt();
        header.nAvgBytesPerSec = reader.readUnsignedInt();
        header.nBlockAlign = reader.readUnsignedShort();
        header.nBitsPerSample = reader.readUnsignedShort();
        header.cDataHeader = reader.readString(4, "US-ASCII");
        header.nDataBytes = reader.readUnsignedInt();
        return header;
    }

    public final byte[] write() {
        ByteArrayWriter writer = new ByteArrayWriter(44);
        writer.writeString(this.cRIFFHeader, 4, "US-ASCII");
        writer.writeUnsignedInt(this.nRIFFBytes);
        writer.writeString(this.cDataTypeID, 4, "US-ASCII");
        writer.writeString(this.cFormatHeader, 4, "US-ASCII");
        writer.writeUnsignedInt(this.nFormatBytes);
        writer.writeUnsignedShort(this.nFormatTag);
        writer.writeUnsignedShort(this.nChannels);
        writer.writeUnsignedInt(this.nSamplesPerSec);
        writer.writeUnsignedInt(this.nAvgBytesPerSec);
        writer.writeUnsignedShort(this.nBlockAlign);
        writer.writeUnsignedShort(this.nBitsPerSample);
        writer.writeString(this.cDataHeader, 4, "US-ASCII");
        writer.writeUnsignedInt(this.nDataBytes);
        return writer.getBytes();
    }
}

