/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.prediction;

import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RollBufferShort;
import java.util.Arrays;

public abstract class NNFilter {
    protected int m_nOrder;
    protected int m_nShift;
    protected int m_nVersion;
    protected int orderPlusWindow;
    private int m_nRunningAverage;
    private RollBufferShort m_rbInput = new RollBufferShort();
    private RollBufferShort m_rbDeltaM = new RollBufferShort();
    private short[] m_paryM;
    public static final int NN_WINDOW_ELEMENTS = 512;

    public NNFilter(int nOrder, int nShift, int nVersion) {
        if (nOrder <= 0 || nOrder % 16 != 0) {
            throw new JMACException("Wrong Order");
        }
        this.m_nOrder = nOrder;
        this.m_nShift = nShift;
        this.m_nVersion = nVersion;
        this.m_rbInput.Create(512, nOrder);
        this.m_rbDeltaM.Create(512, nOrder);
        this.m_paryM = new short[nOrder];
    }

    public int Compress(int nInput) {
        short[] inputData = this.m_rbInput.m_pData;
        int inputIndex = this.m_rbInput.index;
        inputData[inputIndex] = (short)(nInput >= Short.MIN_VALUE && nInput <= Short.MAX_VALUE ? nInput : nInput >> 31 ^ Short.MAX_VALUE);
        int nDotProduct = this.CalculateDotProductNoMMX(inputData, inputIndex - this.m_nOrder, this.m_paryM, 0);
        int nOutput = nInput - (nDotProduct + (1 << this.m_nShift - 1) >> this.m_nShift);
        short[] deltaData = this.m_rbDeltaM.m_pData;
        int deltaIndex = this.m_rbDeltaM.index;
        this.AdaptNoMMX(this.m_paryM, 0, deltaData, deltaIndex - this.m_nOrder, nOutput);
        int nTempABS = Math.abs(nInput);
        deltaData[deltaIndex] = nTempABS > this.m_nRunningAverage * 3 ? (short)((nInput >> 25 & 0x40) - 32) : (nTempABS > (this.m_nRunningAverage << 2) / 3 ? (short)((nInput >> 26 & 0x20) - 16) : (nTempABS > 0 ? (short)((nInput >> 27 & 0x10) - 8) : (short)0));
        this.m_nRunningAverage += (nTempABS - this.m_nRunningAverage) / 16;
        int n = deltaIndex - 1;
        deltaData[n] = (short)(deltaData[n] >> 1);
        int n2 = deltaIndex - 2;
        deltaData[n2] = (short)(deltaData[n2] >> 1);
        int n3 = deltaIndex - 8;
        deltaData[n3] = (short)(deltaData[n3] >> 1);
        if (++this.m_rbInput.index == this.orderPlusWindow) {
            System.arraycopy(inputData, this.m_rbInput.index - this.m_nOrder, inputData, 0, this.m_nOrder);
            this.m_rbInput.index = this.m_nOrder;
        }
        if (++this.m_rbDeltaM.index == this.orderPlusWindow) {
            System.arraycopy(deltaData, this.m_rbDeltaM.index - this.m_nOrder, deltaData, 0, this.m_nOrder);
            this.m_rbDeltaM.index = this.m_nOrder;
        }
        return nOutput;
    }

    public int Decompress(int nInput) {
        short[] inputData = this.m_rbInput.m_pData;
        int inputIndex = this.m_rbInput.index;
        int nDotProduct = this.CalculateDotProductNoMMX(inputData, inputIndex - this.m_nOrder, this.m_paryM, 0);
        short[] deltaData = this.m_rbDeltaM.m_pData;
        int deltaIndex = this.m_rbDeltaM.index;
        this.AdaptNoMMX(this.m_paryM, 0, deltaData, deltaIndex - this.m_nOrder, nInput);
        int nOutput = nInput + (nDotProduct + (1 << this.m_nShift - 1) >> this.m_nShift);
        inputData[inputIndex] = (short)(nOutput >= Short.MIN_VALUE && nOutput <= Short.MAX_VALUE ? nOutput : nOutput >> 31 ^ Short.MAX_VALUE);
        if (this.m_nVersion >= 3980) {
            int nTempABS = Math.abs(nOutput);
            deltaData[deltaIndex] = nTempABS > this.m_nRunningAverage * 3 ? (short)((nOutput >> 25 & 0x40) - 32) : (nTempABS > (this.m_nRunningAverage << 2) / 3 ? (short)((nOutput >> 26 & 0x20) - 16) : (nTempABS > 0 ? (short)((nOutput >> 27 & 0x10) - 8) : (short)0));
            this.m_nRunningAverage += (nTempABS - this.m_nRunningAverage) / 16;
            int n = deltaIndex - 1;
            deltaData[n] = (short)(deltaData[n] >> 1);
            int n2 = deltaIndex - 2;
            deltaData[n2] = (short)(deltaData[n2] >> 1);
            int n3 = deltaIndex - 8;
            deltaData[n3] = (short)(deltaData[n3] >> 1);
        } else {
            deltaData[deltaIndex] = (short)(nOutput == 0 ? 0 : (nOutput >> 28 & 8) - 4);
            int n = deltaIndex - 4;
            deltaData[n] = (short)(deltaData[n] >> 1);
            int n4 = deltaIndex - 8;
            deltaData[n4] = (short)(deltaData[n4] >> 1);
        }
        if (++this.m_rbInput.index == this.orderPlusWindow) {
            System.arraycopy(inputData, this.m_rbInput.index - this.m_nOrder, inputData, 0, this.m_nOrder);
            this.m_rbInput.index = this.m_nOrder;
        }
        if (++this.m_rbDeltaM.index == this.orderPlusWindow) {
            System.arraycopy(deltaData, this.m_rbDeltaM.index - this.m_nOrder, deltaData, 0, this.m_nOrder);
            this.m_rbDeltaM.index = this.m_nOrder;
        }
        return nOutput;
    }

    public void Flush() {
        Arrays.fill(this.m_paryM, (short)0);
        this.m_rbInput.Flush();
        this.m_rbDeltaM.Flush();
        this.m_nRunningAverage = 0;
    }

    protected abstract int CalculateDotProductNoMMX(short[] var1, int var2, short[] var3, int var4);

    protected abstract void AdaptNoMMX(short[] var1, int var2, short[] var3, int var4, int var5);
}

