/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ByteArrayReader {
    private byte[] data = null;
    private int index = 0;

    public ByteArrayReader() {
    }

    public ByteArrayReader(File io, int size) throws IOException {
        this.data = new byte[size];
        io.readFully(this.data);
    }

    public ByteArrayReader(byte[] data) {
        this.data = data;
    }

    public ByteArrayReader(int size) {
        this.data = new byte[size];
    }

    public byte[] getData() {
        return this.data;
    }

    public void reset(byte[] data, int index) {
        this.data = data;
        this.index = index;
    }

    public void reset(File io, int size) throws IOException {
        this.index = 0;
        try {
            io.readFully(this.data, 0, size);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void skipBytes(long n) {
        this.index = (int)((long)this.index + n);
    }

    public short readUnsignedByte() {
        return (short)(this.data[this.index++] & 0xFF);
    }

    public int readUnsignedShort() {
        byte[] a1 = this.data;
        return this.data[this.index++] & 0xFF | (a1[this.index++] & 0xFF) << 8;
    }

    public long readUnsignedInt() {
        byte[] a1 = this.data;
        return (long)(this.data[this.index++] & 0xFF) | (long)(a1[this.index++] & 0xFF) << 8 | (long)(a1[this.index++] & 0xFF) << 16 | (long)(a1[this.index++] & 0xFF) << 24;
    }

    public byte readByte() {
        return this.data[this.index++];
    }

    public short readShort() {
        byte[] a1 = this.data;
        return (short)(this.data[this.index++] & 0xFF | (a1[this.index++] & 0xFF) << 8);
    }

    public int readInt() {
        byte[] a1 = this.data;
        return (int)((long)(this.data[this.index++] & 0xFF) | (long)(a1[this.index++] & 0xFF) << 8 | (long)(a1[this.index++] & 0xFF) << 16 | (long)(a1[this.index++] & 0xFF) << 24);
    }

    public long readLong() {
        byte[] a1 = this.data;
        return (long)(this.data[this.index++] & 0xFF) | (long)(a1[this.index++] & 0xFF) << 8 | (long)(a1[this.index++] & 0xFF) << 16 | (long)(a1[this.index++] & 0xFF) << 24 | (long)(a1[this.index++] & 0xFF) << 32 | (long)(a1[this.index++] & 0xFF) << 40 | (long)(a1[this.index++] & 0xFF) << 48 | (long)(a1[this.index++] & 0xFF) << 56;
    }

    public void readFully(byte[] buf) {
        System.arraycopy(this.data, this.index, buf, 0, buf.length);
        this.index += buf.length;
    }

    public String readString(int size, String encoding) {
        String res;
        try {
            res = new String(this.data, this.index, size, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JMACException("Unsupported encoding", e);
        }
        this.index += size;
        return res;
    }

    public String readString(String encoding) {
        String res;
        int size = 0;
        int i = this.index;
        while (this.data[i] != 0) {
            ++size;
            ++i;
        }
        try {
            res = new String(this.data, this.index, size, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JMACException("Unsupported encoding", e);
        }
        this.index += size + 1;
        return res;
    }
}

