/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.ByteBuffer;

public class CircleBuffer {
    private int m_nTotal = 0;
    private int m_nMaxDirectWriteBytes = 0;
    private int m_nEndCap = 0;
    private int m_nHead = 0;
    private int m_nTail = 0;
    private byte[] m_pBuffer = null;
    private ByteBuffer byteBuffer;

    public void CreateBuffer(int nBytes, int nMaxDirectWriteBytes) {
        this.m_nMaxDirectWriteBytes = nMaxDirectWriteBytes;
        this.m_nTotal = nBytes + 1 + nMaxDirectWriteBytes;
        this.m_pBuffer = new byte[this.m_nTotal];
        this.byteBuffer = new ByteBuffer();
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nEndCap = this.m_nTotal;
    }

    public int MaxAdd() {
        int nMaxAdd = this.m_nTail >= this.m_nHead ? this.m_nTotal - 1 - this.m_nMaxDirectWriteBytes - (this.m_nTail - this.m_nHead) : this.m_nHead - this.m_nTail - 1;
        return nMaxAdd;
    }

    public int MaxGet() {
        return this.m_nTail >= this.m_nHead ? this.m_nTail - this.m_nHead : this.m_nEndCap - this.m_nHead + this.m_nTail;
    }

    public ByteBuffer GetDirectWritePointer() {
        this.byteBuffer.reset(this.m_pBuffer, this.m_nTail);
        return this.byteBuffer;
    }

    public void UpdateAfterDirectWrite(int nBytes) {
        this.m_nTail += nBytes;
        if (this.m_nTail >= this.m_nTotal - this.m_nMaxDirectWriteBytes) {
            this.m_nEndCap = this.m_nTail;
            this.m_nTail = 0;
        }
    }

    public int Get(byte[] pBuffer, int index, int nBytes) {
        int nTotalGetBytes = 0;
        if (pBuffer != null && nBytes > 0) {
            int nHeadBytes = Math.min(this.m_nEndCap - this.m_nHead, nBytes);
            int nFrontBytes = nBytes - nHeadBytes;
            System.arraycopy(this.m_pBuffer, this.m_nHead, pBuffer, index, nHeadBytes);
            nTotalGetBytes = nHeadBytes;
            if (nFrontBytes > 0) {
                System.arraycopy(this.m_pBuffer, 0, pBuffer, index + nHeadBytes, nFrontBytes);
                nTotalGetBytes += nFrontBytes;
            }
            this.RemoveHead(nBytes);
        }
        return nTotalGetBytes;
    }

    public void Empty() {
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nEndCap = this.m_nTotal;
    }

    public int RemoveHead(int nBytes) {
        nBytes = Math.min(this.MaxGet(), nBytes);
        this.m_nHead += nBytes;
        if (this.m_nHead >= this.m_nEndCap) {
            this.m_nHead -= this.m_nEndCap;
        }
        return nBytes;
    }

    public int RemoveTail(int nBytes) {
        nBytes = Math.min(this.MaxGet(), nBytes);
        this.m_nTail -= nBytes;
        if (this.m_nTail < 0) {
            this.m_nTail += this.m_nEndCap;
        }
        return nBytes;
    }
}

