/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.RandomAccessFile;
import java.io.DataInput;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class File
implements DataInput {
    public static File createFile(URL url, String mode) throws IOException {
        try {
            return new RandomAccessFile(url, mode);
        }
        catch (URISyntaxException ex) {
            throw new IOException();
        }
    }

    public abstract void mark(int var1) throws IOException;

    public abstract void reset() throws IOException;

    public abstract int read() throws IOException;

    public short readShortBack() throws IOException {
        return (short)(this.read() | this.read() << 8);
    }

    public int readIntBack() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    public long readLongBack() throws IOException {
        return (long)this.read() | (long)this.read() << 8 | (long)this.read() << 16 | (long)this.read() << 24 | (long)this.read() << 32 | (long)this.read() << 40 | (long)this.read() << 48 | (long)this.read() << 56;
    }

    public abstract int read(byte[] var1) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void readFully(byte[] var1) throws IOException;

    @Override
    public abstract void readFully(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close() throws IOException;

    @Override
    public abstract boolean readBoolean() throws IOException;

    @Override
    public abstract byte readByte() throws IOException;

    @Override
    public abstract char readChar() throws IOException;

    @Override
    public abstract double readDouble() throws IOException;

    @Override
    public abstract float readFloat() throws IOException;

    @Override
    public abstract int readInt() throws IOException;

    @Override
    public abstract String readLine() throws IOException;

    @Override
    public abstract long readLong() throws IOException;

    @Override
    public abstract short readShort() throws IOException;

    @Override
    public abstract int readUnsignedByte() throws IOException;

    @Override
    public abstract int readUnsignedShort() throws IOException;

    @Override
    public abstract String readUTF() throws IOException;

    @Override
    public abstract int skipBytes(int var1) throws IOException;

    public abstract long length() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract long getFilePointer() throws IOException;

    public abstract boolean isLocal();

    public abstract String getFilename();

    public String getExtension() {
        String filename = this.getFilename();
        int index = filename.lastIndexOf(46);
        return index >= 0 ? filename.substring(index) : "";
    }
}

