/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.jmac.tools.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class RandomAccessFile
extends File {
    private RandomAccessInputStream file = null;
    private java.io.File f = null;
    private long markPosition = -1L;

    public RandomAccessFile(URL url, String mode) throws URISyntaxException, IOException, FileNotFoundException {
        this.f = new java.io.File(url.toURI());
        this.file = new RandomAccessInputStreamImpl(url);
    }

    public RandomAccessFile(java.io.File url, String mode) throws IOException, FileNotFoundException {
        this.f = url;
        this.file = new RandomAccessInputStreamImpl(url);
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.markPosition = this.file.getFilePointer();
    }

    @Override
    public void reset() throws IOException {
        if (this.markPosition >= 0L) {
            this.file.seek(this.markPosition);
        }
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public short readShortBack() throws IOException {
        return (short)(this.read() | this.read() << 8);
    }

    @Override
    public int readIntBack() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    @Override
    public long readLongBack() throws IOException {
        return (long)this.read() | (long)this.read() << 8 | (long)this.read() << 16 | (long)this.read() << 24 | (long)this.read() << 32 | (long)this.read() << 40 | (long)this.read() << 48 | (long)this.read() << 56;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.file.read(b);
    }

    @Override
    public int read(byte[] b, int offs, int len) throws IOException {
        return this.file.read(b, offs, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.file.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int offs, int len) throws IOException {
        this.file.readFully(b, offs, len);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.file.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.file.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.file.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.file.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.file.readFloat();
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.file.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.file.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.file.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.file.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.file.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.file.skipBytes(n);
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String getFilename() {
        return this.f.getName();
    }
}

