/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay;

import de.quippy.sidplay.libsidplay.NullSID;
import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.EventScheduler;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.common.mos6510.C64Environment;
import de.quippy.sidplay.libsidplay.common.mos6510.MOS6510;
import de.quippy.sidplay.libsidplay.common.mos6510.SID6510;
import de.quippy.sidplay.libsidplay.components.mos6526.C64CIA;
import de.quippy.sidplay.libsidplay.components.mos6526.SID6526;
import de.quippy.sidplay.libsidplay.components.mos656x.C64VIC;
import de.quippy.sidplay.libsidplay.components.mos656x.MOS656X;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.xsid.C64XSID;
import de.quippy.sidplay.libsidplay.mem.IBasic;
import de.quippy.sidplay.libsidplay.mem.IChar;
import de.quippy.sidplay.libsidplay.mem.IKernal;
import de.quippy.sidplay.libsidplay.mem.IPSIDDrv;
import de.quippy.sidplay.libsidplay.mem.IPowerOn;

public class Player
extends C64Env {
    private C64Environment envp;
    private static final double CLOCK_FREQ_NTSC = 1022727.14;
    private static final double CLOCK_FREQ_PAL = 985248.4;
    private static final double VIC_FREQ_PAL = 50.0;
    private static final double VIC_FREQ_NTSC = 60.0;
    private static final String TXT_PAL_VBI = "50 Hz VBI (PAL)";
    private static final String TXT_PAL_VBI_FIXED = "60 Hz VBI (PAL FIXED)";
    private static final String TXT_PAL_CIA = "CIA (PAL)";
    private static final String TXT_NTSC_VBI = "60 Hz VBI (NTSC)";
    private static final String TXT_NTSC_VBI_FIXED = "50 Hz VBI (NTSC FIXED)";
    private static final String TXT_NTSC_CIA = "CIA (NTSC)";
    private static final String TXT_NA = "NA";
    private static final String ERR_CONF_WHILST_ACTIVE = "SIDPLAYER ERROR: Trying to configure player whilst active.";
    private static final String ERR_UNSUPPORTED_FREQ = "SIDPLAYER ERROR: Unsupported sampling frequency.";
    private static final String ERR_UNSUPPORTED_PRECISION = "SIDPLAYER ERROR: Unsupported sample precision.";
    private static String[] credit = new String[10];
    private static final String ERR_PSIDDRV_NO_SPACE = "ERROR: No space to install psid driver in C64 ram";
    private static final String ERR_PSIDDRV_RELOC = "ERROR: Failed whilst relocating psid driver";
    private EventScheduler m_scheduler;
    private SID6510 sid6510;
    private MOS6510 mos6510;
    private MOS6510 cpu;
    private NullSID nullsid;
    private C64XSID xsid;
    private C64CIA.C64cia1 cia;
    private C64CIA.C64cia2 cia2;
    private SID6526 sid6526;
    private C64VIC vic;
    private SIDEmu[] sid = new SIDEmu[2];
    private int[] m_sidmapper = new int[32];
    private EventMixer mixerEvent;
    private EventRTC rtc;
    private SidTuneInfo m_tuneInfo = new SidTuneInfo();
    private SidTune m_tune = null;
    private short[] m_ram = null;
    private short[] m_rom = null;
    private ISID2Types.sid2_info_t m_info = new ISID2Types.sid2_info_t();
    private ISID2Types.sid2_config_t m_cfg = new ISID2Types.sid2_config_t();
    private String m_errorString = "NA";
    private double m_fastForwardFactor = 1.0;
    private long m_mileage = 0L;
    private long m_leftVolume;
    private long m_rightVolume;
    private ISID2Types.sid2_player_t m_playerState;
    private boolean m_running = false;
    private int m_rand;
    private long m_sid2crc = -1L;
    private long m_sid2crcCount = 0L;
    private boolean m_emulateStereo = true;
    private long m_sampleClock;
    private long m_samplePeriod;
    private int m_sampleCount = 0;
    private int m_sampleIndex;
    private short[] m_sampleBuffer;
    private Port m_port = new Port();
    private short m_playBank;
    private boolean isKernal;
    private boolean isBasic;
    private boolean isIO;
    private boolean isChar;
    private IMem m_mem;
    private IOutput output;
    private static final long[] crc32Table = new long[]{0L, 1996959894L, -301047508L, -1727442502L, 124634137L, 1886057615L, -379345611L, -1637575261L, 249268274L, 2044508324L, -522852066L, -1747789432L, 162941995L, 2125561021L, -407360249L, -1866523247L, 498536548L, 1789927666L, -205950648L, -2067906082L, 450548861L, 1843258603L, -187386543L, -2083289657L, 325883990L, 1684777152L, -43845254L, -1973040660L, 335633487L, 1661365465L, -99664541L, -1928851979L, 997073096L, 1281953886L, -715111964L, -1570279054L, 1006888145L, 1258607687L, -770865667L, -1526024853L, 901097722L, 1119000684L, -608450090L, -1396901568L, 853044451L, 1172266101L, -589951537L, -1412350631L, 651767980L, 1373503546L, -925412992L, -1076862698L, 565507253L, 1454621731L, -809855591L, -1195530993L, 671266974L, 1594198024L, -972236366L, -1324619484L, 795835527L, 1483230225L, -1050600021L, -1234817731L, 1994146192L, 31158534L, -1731059524L, -271249366L, 1907459465L, 112637215L, -1614814043L, -390540237L, 2013776290L, 251722036L, -1777751922L, -519137256L, 2137656763L, 141376813L, -1855689577L, -429695999L, 1802195444L, 476864866L, -2056965928L, -228458418L, 1812370925L, 453092731L, -2113342271L, -183516073L, 1706088902L, 314042704L, -1950435094L, -54949764L, 1658658271L, 366619977L, -1932296973L, -69972891L, 1303535960L, 984961486L, -1547960204L, -725929758L, 1256170817L, 1037604311L, -1529756563L, -740887301L, 1131014506L, 879679996L, -1385723834L, -631195440L, 1141124467L, 855842277L, -1442165665L, -586318647L, 1342533948L, 654459306L, -1106571248L, -921952122L, 1466479909L, 544179635L, -1184443383L, -832445281L, 1591671054L, 702138776L, -1328506846L, -942167884L, 1504918807L, 783551873L, -1212326853L, -1061524307L, -306674912L, -1698712650L, 62317068L, 1957810842L, -355121351L, -1647151185L, 81470997L, 1943803523L, -480048366L, -1805370492L, 225274430L, 2053790376L, -468791541L, -1828061283L, 167816743L, 2097651377L, -267414716L, -2029476910L, 503444072L, 1762050814L, -144550051L, -2140837941L, 426522225L, 1852507879L, -19653770L, -1982649376L, 282753626L, 1742555852L, -105259153L, -1900089351L, 397917763L, 1622183637L, -690576408L, -1580100738L, 953729732L, 1340076626L, -776247311L, -1497606297L, 1068828381L, 1219638859L, -670225446L, -1358292148L, 906185462L, 1090812512L, -547295293L, -1469587627L, 829329135L, 1181335161L, -882789492L, -1134132454L, 628085408L, 1382605366L, -871598187L, -1156888829L, 570562233L, 1426400815L, -977650754L, -1296233688L, 733239954L, 1555261956L, -1026031705L, -1244606671L, 752459403L, 1541320221L, -1687895376L, -328994266L, 1969922972L, 40735498L, -1677130071L, -351390145L, 1913087877L, 83908371L, -1782625662L, -491226604L, 2075208622L, 213261112L, -1831694693L, -438977011L, 2094854071L, 198958881L, -2032938284L, -237706686L, 1759359992L, 534414190L, -2118248755L, -155638181L, 1873836001L, 414664567L, -2012718362L, -15766928L, 1711684554L, 285281116L, -1889165569L, -127750551L, 1634467795L, 376229701L, -1609899400L, -686959890L, 1308918612L, 956543938L, -1486412191L, -799009033L, 1231636301L, 1047427035L, -1362007478L, -640263460L, 1088359270L, 936918000L, -1447252397L, -558129467L, 1202900863L, 817233897L, -1111625188L, -893730166L, 1404277552L, 615818150L, -1160759803L, -841546093L, 1423857449L, 601450431L, -1285129682L, -1000256840L, 1567103746L, 711928724L, -1274298825L, -1022587231L, 1510334235L, 755167117L};
    static final int PSIDDRV_MAX_PAGE = 255;
    public static final long VOLUME_MAX = 255L;
    public static final int SID2_MAX_SIDS = 2;
    public static final int SID2_TIME_BASE = 10;
    public static final int SID2_MAPPER_SIZE = 32;
    public static final int BUF = 26;
    private file65 file = new file65();
    private char[] cmp = new char[]{'\u0001', '\u0000', 'o', '6', '5'};
    static final int EOF = -1;

    private void evalBankSelect(short data) {
        this.m_port.pr_out = data;
        this.m_port.pr_in = (short)(data & this.m_port.ddr | ~this.m_port.ddr & (this.m_port.pr_in | 0x17) & 0xDF);
        data = (short)(data | ~this.m_port.ddr & 0xFF);
        this.isBasic = ((data = (short)(data & 7)) & 3) == 3;
        this.isIO = data > 4;
        this.isKernal = (data & 2) != 0;
        this.isChar = (data ^ 4) > 4;
    }

    private double clockSpeed(ISID2Types.sid2_clock_t userClock, ISID2Types.sid2_clock_t defaultClock, boolean forced) {
        double cpuFreq = 985248.4;
        if (this.m_tuneInfo.clockSpeed == 0) {
            switch (defaultClock) {
                case SID2_CLOCK_PAL: {
                    this.m_tuneInfo.clockSpeed = 1;
                    break;
                }
                case SID2_CLOCK_NTSC: {
                    this.m_tuneInfo.clockSpeed = (short)2;
                    break;
                }
                case SID2_CLOCK_CORRECT: {
                    this.m_tuneInfo.clockSpeed = (short)3;
                }
            }
        }
        if (this.m_tuneInfo.clockSpeed == 3) {
            if (userClock == ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT) {
                userClock = defaultClock;
            }
            switch (userClock) {
                case SID2_CLOCK_NTSC: {
                    this.m_tuneInfo.clockSpeed = (short)2;
                    break;
                }
                default: {
                    this.m_tuneInfo.clockSpeed = 1;
                }
            }
        }
        if (userClock == ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT) {
            switch (this.m_tuneInfo.clockSpeed) {
                case 2: {
                    userClock = ISID2Types.sid2_clock_t.SID2_CLOCK_NTSC;
                    break;
                }
                case 1: {
                    userClock = ISID2Types.sid2_clock_t.SID2_CLOCK_PAL;
                }
            }
        }
        if (forced) {
            this.m_tuneInfo.clockSpeed = 1;
            if (userClock == ISID2Types.sid2_clock_t.SID2_CLOCK_NTSC) {
                this.m_tuneInfo.clockSpeed = (short)2;
            }
        }
        if (this.m_tuneInfo.clockSpeed == 1) {
            this.vic.chip(MOS656X.mos656x_model_t.MOS6569);
        } else {
            this.vic.chip(MOS656X.mos656x_model_t.MOS6567R8);
        }
        if (userClock == ISID2Types.sid2_clock_t.SID2_CLOCK_PAL) {
            cpuFreq = 985248.4;
            this.m_tuneInfo.speedString = TXT_PAL_VBI;
            if (this.m_tuneInfo.songSpeed == 60) {
                this.m_tuneInfo.speedString = TXT_PAL_CIA;
            } else if (this.m_tuneInfo.clockSpeed == 2) {
                this.m_tuneInfo.speedString = TXT_PAL_VBI_FIXED;
            }
        } else {
            cpuFreq = 1022727.14;
            this.m_tuneInfo.speedString = TXT_NTSC_VBI;
            if (this.m_tuneInfo.songSpeed == 60) {
                this.m_tuneInfo.speedString = TXT_NTSC_CIA;
            } else if (this.m_tuneInfo.clockSpeed == 1) {
                this.m_tuneInfo.speedString = TXT_NTSC_VBI_FIXED;
            }
        }
        return cpuFreq;
    }

    private int environment(ISID2Types.sid2_env_t env) {
        switch (this.m_tuneInfo.compatibility) {
            case 2: 
            case 3: {
                env = ISID2Types.sid2_env_t.sid2_envR;
                break;
            }
            case 1: {
                if (env != ISID2Types.sid2_env_t.sid2_envR) break;
                env = ISID2Types.sid2_env_t.sid2_envBS;
            }
        }
        if (this.m_ram == null || this.m_info.environment != env) {
            this.m_info.environment = env;
            if (this.m_ram != null) {
                if (this.m_ram == this.m_rom) {
                    this.m_ram = null;
                } else {
                    this.m_rom = null;
                    this.m_ram = null;
                }
            }
            this.m_ram = new short[65536];
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                this.m_rom = this.m_ram;
                this.m_mem = new IMem(){

                    @Override
                    public short m_readMemByte(int addr) {
                        return Player.this.readMemByte_plain(addr);
                    }

                    @Override
                    public void m_writeMemByte(int addr, short data) {
                        Player.this.writeMemByte_playsid(addr, data);
                    }

                    @Override
                    public short m_readMemDataByte(int addr) {
                        return Player.this.readMemByte_plain(addr);
                    }
                };
            } else {
                this.m_rom = new short[65536];
                switch (this.m_info.environment) {
                    case sid2_envTP: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int addr) {
                                return Player.this.readMemByte_plain(addr);
                            }

                            @Override
                            public void m_writeMemByte(int addr, short data) {
                                Player.this.writeMemByte_sidplay(addr, data);
                            }

                            @Override
                            public short m_readMemDataByte(int addr) {
                                return Player.this.readMemByte_sidplaytp(addr);
                            }
                        };
                        break;
                    }
                    case sid2_envBS: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int addr) {
                                return Player.this.readMemByte_plain(addr);
                            }

                            @Override
                            public void m_writeMemByte(int addr, short data) {
                                Player.this.writeMemByte_sidplay(addr, data);
                            }

                            @Override
                            public short m_readMemDataByte(int addr) {
                                return Player.this.readMemByte_sidplaybs(addr);
                            }
                        };
                        break;
                    }
                    default: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int addr) {
                                return Player.this.readMemByte_sidplaybs(addr);
                            }

                            @Override
                            public void m_writeMemByte(int addr, short data) {
                                Player.this.writeMemByte_sidplay(addr, data);
                            }

                            @Override
                            public short m_readMemDataByte(int addr) {
                                return Player.this.readMemByte_sidplaybs(addr);
                            }
                        };
                    }
                }
            }
        }
        ISID2Types.sid2_env_t old = this.m_info.environment;
        this.m_info.environment = env;
        int ret = this.initialise();
        this.m_info.environment = old;
        return ret;
    }

    private void fakeIRQ() {
        int playAddr = this.m_tuneInfo.playAddr;
        if (playAddr != 0) {
            this.evalBankSelect(this.m_playBank);
        } else {
            playAddr = this.isKernal ? SIDEndian.endian_little16(this.m_ram, 788) : SIDEndian.endian_little16(this.m_ram, 65534);
        }
        this.cpu.triggerIRQ();
        this.sid6510.reset(playAddr, (short)0, (short)0, (short)0);
    }

    private int initialise() {
        this.mileageCorrect();
        this.m_mileage += this.time();
        this.reset();
        long page = (long)this.m_tuneInfo.loadAddr + (long)this.m_tuneInfo.c64dataLen - 1L >> 8;
        if (page > 255L) {
            this.m_errorString = "SIDPLAYER ERROR: Size of music data exceeds C64 memory.";
            return -1;
        }
        if (this.psidDrvReloc(this.m_tuneInfo, this.m_info) < 0) {
            return -1;
        }
        int start = this.m_tuneInfo.loadAddr;
        int end = start + this.m_tuneInfo.c64dataLen;
        SIDEndian.endian_little16(this.m_ram, 45, end);
        SIDEndian.endian_little16(this.m_ram, 47, end);
        SIDEndian.endian_little16(this.m_ram, 49, end);
        SIDEndian.endian_little16(this.m_ram, 172, start);
        SIDEndian.endian_little16(this.m_ram, 174, end);
        if (!this.m_tune.placeSidTuneInC64mem(this.m_ram)) {
            this.m_errorString = this.m_tuneInfo.statusString;
            return -1;
        }
        this.psidDrvInstall(this.m_info);
        this.rtc.reset();
        this.envReset(false);
        return 0;
    }

    private void mixer() {
        short[] buf = this.m_sampleBuffer;
        int bufOff = this.m_sampleIndex;
        this.m_sampleClock += this.m_samplePeriod;
        long cycles = this.m_sampleClock >> 16;
        this.m_sampleClock &= 0xFFFFL;
        this.m_sampleIndex = (int)((long)this.m_sampleIndex + this.output.output(buf, bufOff));
        this.context().schedule(this.mixerEvent, cycles, Event.event_phase_t.EVENT_CLOCK_PHI1);
        if (this.m_sampleIndex >= this.m_sampleCount) {
            this.m_running = false;
        }
    }

    private void mixerReset() {
        this.m_sampleClock = this.m_samplePeriod & 0xFFFFL;
        this.context().schedule(this.mixerEvent, this.m_samplePeriod >> 24, Event.event_phase_t.EVENT_CLOCK_PHI1);
    }

    private void mileageCorrect() {
        if (((long)(this.m_sampleCount * 2 * 10) / this.m_cfg.frequency & 1L) != 0L) {
            ++this.m_mileage;
        }
        this.m_sampleCount = 0;
    }

    private int sidCreate(SIDBuilder builder, ISID2Types.sid2_model_t userModel, ISID2Types.sid2_model_t defaultModel) {
        int i;
        this.sid[0] = this.xsid.emulation();
        this.xsid.emulation(this.nullsid);
        for (i = 0; i < 2; ++i) {
            SIDBuilder b = this.sid[i].builder();
            if (b == null) continue;
            b.unlock(this.sid[i]);
        }
        if (builder == null || !builder.bool()) {
            for (i = 0; i < 2; ++i) {
                this.sid[i] = this.nullsid;
            }
        } else {
            if (this.m_tuneInfo.sidModel == 0) {
                switch (defaultModel) {
                    case SID2_MOS6581: {
                        this.m_tuneInfo.sidModel = 1;
                        break;
                    }
                    case SID2_MOS8580: {
                        this.m_tuneInfo.sidModel = 2;
                        break;
                    }
                    case SID2_MODEL_CORRECT: {
                        this.m_tuneInfo.sidModel = 3;
                    }
                }
            }
            if (this.m_tuneInfo.sidModel == 3) {
                if (userModel == ISID2Types.sid2_model_t.SID2_MODEL_CORRECT) {
                    userModel = defaultModel;
                }
                switch (userModel) {
                    case SID2_MOS8580: {
                        this.m_tuneInfo.sidModel = 2;
                        break;
                    }
                    default: {
                        this.m_tuneInfo.sidModel = 1;
                    }
                }
            }
            switch (userModel) {
                case SID2_MODEL_CORRECT: {
                    switch (this.m_tuneInfo.sidModel) {
                        case 2: {
                            userModel = ISID2Types.sid2_model_t.SID2_MOS8580;
                            break;
                        }
                        case 1: {
                            userModel = ISID2Types.sid2_model_t.SID2_MOS6581;
                        }
                    }
                    break;
                }
                case SID2_MOS6581: {
                    this.m_tuneInfo.sidModel = 1;
                    break;
                }
                case SID2_MOS8580: {
                    this.m_tuneInfo.sidModel = 2;
                }
            }
            for (i = 0; i < 2; ++i) {
                this.sid[i] = builder.lock(this, userModel);
                if (this.sid[i] == null) {
                    this.sid[i] = this.nullsid;
                }
                if (i == 0 && !builder.bool()) {
                    return -1;
                }
                this.sid[0].optimisation(this.m_cfg.optimisation);
            }
        }
        this.xsid.emulation(this.sid[0]);
        this.sid[0] = this.xsid;
        return 0;
    }

    private void sidSamples(boolean enable) {
        int gain = 0;
        this.xsid.sidSamples(enable);
        if (!enable) {
            gain = -25;
        }
        this.xsid.gain((short)(-100 - gain));
        this.sid[0] = this.xsid.emulation();
        for (int i = 0; i < 2; ++i) {
            this.sid[i].gain((short)gain);
        }
        this.sid[0] = this.xsid;
    }

    private void reset() {
        int i;
        this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
        this.m_running = false;
        this.m_sid2crc = -1L;
        this.m_info.sid2crc = this.m_sid2crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.m_info.sid2crcCount = 0L;
        this.m_sid2crcCount = 0L;
        this.cpu = this.sid6510;
        this.sid6510.environment(this.m_info.environment);
        this.m_scheduler.reset();
        for (i = 0; i < 2; ++i) {
            SIDEmu s = this.sid[i];
            s.reset((short)15);
            s.write((short)4, (short)8);
            s.write((short)11, (short)8);
            s.write((short)18, (short)8);
            s.write((short)4, (short)0);
            s.write((short)11, (short)0);
            s.write((short)18, (short)0);
        }
        if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
            this.cia.reset();
            this.cia2.reset();
            this.vic.reset();
        } else {
            this.sid6526.reset(this.m_cfg.powerOnDelay <= 8191);
            this.sid6526.write((short)14, (short)1);
            if (this.m_tuneInfo.songSpeed == 0) {
                this.sid6526.lock();
            }
        }
        this.m_port.pr_in = 0;
        for (i = 0; i < 65536; ++i) {
            this.m_ram[i] = 0;
        }
        switch (this.m_info.environment) {
            case sid2_envPS: {
                break;
            }
            case sid2_envR: {
                for (i = 1984; i < 65536; i += 128) {
                    for (int j = 0; j < 64; ++j) {
                        this.m_ram[i + j] = 255;
                    }
                }
                for (i = 0; i < 65536; ++i) {
                    this.m_rom[i] = 0;
                }
                break;
            }
            default: {
                for (i = 0; i < 65536; ++i) {
                    this.m_rom[i] = 0;
                }
                for (i = 0; i < 8192; ++i) {
                    this.m_rom[40960 + i] = 96;
                }
            }
        }
        if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
            for (i = 0; i < IKernal.KERNAL.length; ++i) {
                this.m_rom[57344 + i] = IKernal.KERNAL[i];
            }
            for (i = 0; i < IChar.CHAR.length; ++i) {
                this.m_rom[53248 + i] = IChar.CHAR[i];
            }
            this.m_rom[64873] = 159;
            this.m_rom[58719] = 0;
            this.m_rom[64964] = 234;
            this.m_rom[64965] = 234;
            this.m_rom[64966] = 234;
            if (this.m_tuneInfo.compatibility == 3) {
                for (i = 0; i < IBasic.BASIC.length; ++i) {
                    this.m_rom[40960 + i] = IBasic.BASIC[i];
                }
            }
            int addr = 0;
            int i2 = 0;
            block14: while (i2 < IPowerOn.POWERON.length) {
                short off = IPowerOn.POWERON[i2++];
                int count = 0;
                boolean compressed = false;
                if ((off & 0x80) != 0) {
                    off = (short)(off & 0x7F);
                    if (((count = IPowerOn.POWERON[i2++]) & 0x80) != 0) {
                        count = (short)(count & 0x7F);
                        compressed = true;
                    }
                }
                count = (short)(count + 1);
                addr += off;
                if (compressed) {
                    short data = IPowerOn.POWERON[i2++];
                    while (true) {
                        int n = count;
                        count = (short)(count - 1);
                        if (n <= 0) continue block14;
                        this.m_ram[addr++] = data;
                    }
                }
                while (true) {
                    int n = count;
                    count = (short)(count - 1);
                    if (n <= 0) continue block14;
                    this.m_ram[addr++] = IPowerOn.POWERON[i2++];
                }
            }
        } else {
            for (i = 0; i < 8192; ++i) {
                this.m_rom[57344 + i] = 96;
            }
            this.m_rom[53273] = 255;
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                this.m_ram[65352] = 108;
                SIDEndian.endian_little16(this.m_ram, 65353, 788);
            }
            SIDEndian.endian_little16(this.m_ram, 788, 59953);
            SIDEndian.endian_little16(this.m_ram, 790, 65126);
            SIDEndian.endian_little16(this.m_ram, 792, 65095);
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                SIDEndian.endian_little16(this.m_rom, 65530, 65530);
            } else {
                SIDEndian.endian_little16(this.m_rom, 65530, 65091);
            }
            SIDEndian.endian_little16(this.m_rom, 65532, 64738);
            SIDEndian.endian_little16(this.m_rom, 65534, 65352);
            for (i = 0; i < 6; ++i) {
                this.m_ram[65530 + i] = this.m_rom[65530 + i];
            }
        }
        this.m_ram[678] = this.m_tuneInfo.clockSpeed == 1 ? (short)1 : 0;
    }

    private short iomap(int addr) {
        if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envPS) {
            switch (this.m_tuneInfo.compatibility) {
                case 2: 
                case 3: {
                    return 0;
                }
            }
            if (addr == 0) {
                return 0;
            }
            if (addr < 40960) {
                return 55;
            }
            if (addr < 53248) {
                return 54;
            }
            if (addr >= 57344) {
                return 53;
            }
        }
        return 52;
    }

    private short readMemByte_plain(int addr) {
        if (addr > 1) {
            return this.m_ram[addr & 0xFFFF];
        }
        if (addr != 0) {
            return this.m_port.pr_in;
        }
        return this.m_port.ddr;
    }

    private short readMemByte_io(int addr) {
        int tempAddr = addr & 0xFC1F;
        if ((tempAddr & 0xFF00) != 54272) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                switch (SIDEndian.endian_16hi8(addr)) {
                    case 0: 
                    case 1: {
                        return this.readMemByte_plain(addr);
                    }
                    case 220: {
                        return this.cia.read((short)(addr & 0xF));
                    }
                    case 221: {
                        return this.cia2.read((short)(addr & 0xF));
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        return this.vic.read((short)(addr & 0x3F));
                    }
                }
                return this.m_rom[addr & 0xFFFF];
            }
            switch (SIDEndian.endian_16hi8(addr)) {
                case 0: 
                case 1: {
                    return this.readMemByte_plain(addr);
                }
                case 220: {
                    return this.sid6526.read((short)(addr & 0xF));
                }
                case 208: {
                    switch (addr & 0x3F) {
                        case 17: 
                        case 18: {
                            return this.sid6526.read((short)(addr - 13 & 0xF));
                        }
                    }
                }
            }
            return this.m_rom[addr & 0xFFFF];
        }
        int i = this.m_sidmapper[addr >> 5 & 0x1F];
        return this.sid[i].read((short)(tempAddr & 0xFF));
    }

    private short readMemByte_sidplaytp(int addr) {
        if (addr < 53248) {
            return this.readMemByte_plain(addr);
        }
        switch (addr >> 12) {
            case 13: {
                if (this.isIO) {
                    return this.readMemByte_io(addr);
                }
                return this.m_ram[addr];
            }
        }
        return this.m_ram[addr & 0xFFFF];
    }

    private short readMemByte_sidplaybs(int addr) {
        if (addr < 40960) {
            return this.readMemByte_plain(addr);
        }
        switch (addr >> 12) {
            case 10: 
            case 11: {
                if (this.isBasic) {
                    return this.m_rom[addr];
                }
                return this.m_ram[addr];
            }
            case 12: {
                return this.m_ram[addr];
            }
            case 13: {
                if (this.isIO) {
                    return this.readMemByte_io(addr);
                }
                if (this.isChar) {
                    return this.m_rom[addr];
                }
                return this.m_ram[addr];
            }
        }
        if (this.isKernal) {
            return this.m_rom[addr & 0xFFFF];
        }
        return this.m_ram[addr & 0xFFFF];
    }

    private void writeMemByte_plain(int addr, short data) {
        if (addr > 1) {
            this.m_ram[addr & 0xFFFF] = data;
        } else if (addr != 0) {
            this.evalBankSelect(data);
        } else {
            this.m_port.ddr = data;
            this.evalBankSelect(this.m_port.pr_out);
        }
    }

    private void writeMemByte_playsid(int addr, short data) {
        int tempAddr = addr & 0xFC1F;
        if ((tempAddr & 0xFF00) != 54272) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                switch (SIDEndian.endian_16hi8(addr)) {
                    case 0: 
                    case 1: {
                        this.writeMemByte_plain(addr, data);
                        return;
                    }
                    case 220: {
                        this.cia.write((short)(addr & 0xF), data);
                        return;
                    }
                    case 221: {
                        this.cia2.write((short)(addr & 0xF), data);
                        return;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        this.vic.write((short)(addr & 0x3F), data);
                        return;
                    }
                }
                this.m_rom[addr & 0xFFFF] = data;
                return;
            }
            switch (SIDEndian.endian_16hi8(addr)) {
                case 0: 
                case 1: {
                    this.writeMemByte_plain(addr, data);
                    return;
                }
                case 220: {
                    this.sid6526.write((short)(addr & 0xF), data);
                    return;
                }
            }
            this.m_rom[addr & 0xFFFF] = data;
            return;
        }
        this.sid2crc(data);
        if ((tempAddr & 0xFF) >= 29) {
            this.xsid.write16(addr & 0x1FF, data);
        } else {
            int i = this.m_sidmapper[addr >> 5 & 0x1F];
            this.sid[i].write((short)(tempAddr & 0xFF), data);
            if (this.m_emulateStereo) {
                this.sid[1].write((short)(tempAddr & 0xFF), data);
            }
        }
    }

    private void writeMemByte_sidplay(int addr, short data) {
        if (addr < 40960) {
            this.writeMemByte_plain(addr, data);
        } else {
            switch (addr >> 12) {
                case 10: 
                case 11: 
                case 12: {
                    this.m_ram[addr] = data;
                    break;
                }
                case 13: {
                    if (this.isIO) {
                        this.writeMemByte_playsid(addr, data);
                        break;
                    }
                    this.m_ram[addr] = data;
                    break;
                }
                default: {
                    this.m_ram[addr & 0xFFFF] = data;
                }
            }
        }
    }

    private void envReset(boolean safe) {
        if (safe) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                short[] prg = new short[]{169, 127, 141, 13, 220, 96};
                ISID2Types.sid2_info_t info = new ISID2Types.sid2_info_t();
                SidTuneInfo tuneInfo = new SidTuneInfo();
                tuneInfo.relocStartPage = (short)9;
                tuneInfo.relocPages = (short)32;
                tuneInfo.initAddr = 2048;
                tuneInfo.songSpeed = (short)60;
                info.environment = this.m_info.environment;
                this.psidDrvReloc(tuneInfo, info);
                for (int i = 0; i < prg.length; ++i) {
                    this.m_ram[2048 + i] = prg[i];
                }
                this.psidDrvInstall(info);
            } else {
                this.sid6526.reset();
            }
            for (int i = 0; i < 2; ++i) {
                this.sid[i].reset((short)0);
            }
        }
        this.m_port.ddr = (short)47;
        if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envR) {
            short song = (short)(this.m_tuneInfo.currentSong - 1);
            short bank = this.iomap(this.m_tuneInfo.initAddr);
            this.evalBankSelect(bank);
            this.m_playBank = this.iomap(this.m_tuneInfo.playAddr);
            if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envPS) {
                this.sid6510.reset(this.m_tuneInfo.initAddr, song, (short)0, (short)0);
            } else {
                this.sid6510.reset(this.m_tuneInfo.initAddr, song, song, song);
            }
        } else {
            this.evalBankSelect((short)55);
            this.cpu.reset();
        }
        this.mixerReset();
        this.xsid.suppress(true);
    }

    private long monoOutGenericLeftIn(short bits) {
        return this.sid[0].output(bits) * this.m_leftVolume / 255L;
    }

    private long monoOutGenericStereoIn(short bits) {
        return (this.sid[0].output(bits) * this.m_leftVolume + this.sid[1].output(bits) * this.m_rightVolume) / 510L;
    }

    private long monoOutGenericRightIn(short bits) {
        return this.sid[1].output(bits) * this.m_rightVolume / 255L;
    }

    private long monoOut8MonoIn(short[] buffer, int off) {
        buffer[off] = (byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long monoOut8StereoIn(short[] buffer, int off) {
        buffer[off] = (byte)(this.monoOutGenericStereoIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long monoOut8StereoRIn(short[] buffer, int off) {
        buffer[off] = (byte)(this.monoOutGenericRightIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long stereoOut8MonoIn(short[] buffer, int off) {
        short sample;
        buffer[off + 0] = sample = (short)((byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L));
        buffer[off + 1] = sample;
        return 2L;
    }

    private long stereoOut8StereoIn(short[] buffer, int off) {
        buffer[off + 0] = (byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L);
        buffer[off + 1] = (byte)(this.monoOutGenericRightIn((short)8) ^ 0x80L);
        return 2L;
    }

    private long monoOut16MonoIn(short[] buffer, int off) {
        SIDEndian.endian_16(buffer, off, (int)this.monoOutGenericLeftIn((short)16));
        return 2L;
    }

    private long monoOut16StereoIn(short[] buffer, int off) {
        SIDEndian.endian_16(buffer, off, (int)this.monoOutGenericStereoIn((short)16));
        return 2L;
    }

    private long monoOut16StereoRIn(short[] buffer, int off) {
        SIDEndian.endian_16(buffer, off, (int)this.monoOutGenericRightIn((short)16));
        return 2L;
    }

    private long stereoOut16MonoIn(short[] buffer, int off) {
        int sample = (int)this.monoOutGenericLeftIn((short)16);
        SIDEndian.endian_16(buffer, off, sample);
        SIDEndian.endian_16(buffer, off + 2, sample);
        return 4L;
    }

    private long stereoOut16StereoIn(short[] buffer, int off) {
        SIDEndian.endian_16(buffer, off, (int)this.monoOutGenericLeftIn((short)16));
        SIDEndian.endian_16(buffer, off + 2, (int)this.monoOutGenericRightIn((short)16));
        return 4L;
    }

    @Override
    public void interruptIRQ(boolean state) {
        if (state) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                this.cpu.triggerIRQ();
            } else {
                this.fakeIRQ();
            }
        } else {
            this.cpu.clearIRQ();
        }
    }

    @Override
    public void interruptNMI() {
        this.cpu.triggerNMI();
    }

    @Override
    public void interruptRST() {
        this.stop();
    }

    @Override
    public void signalAEC(boolean state) {
        this.cpu.aecSignal(state);
    }

    @Override
    public short readMemRamByte(int addr) {
        return this.m_ram[addr];
    }

    @Override
    public void sid2crc(short data) {
        if (this.m_sid2crcCount < this.m_cfg.sid2crcCount) {
            this.m_info.sid2crcCount = ++this.m_sid2crcCount;
            this.m_sid2crc = this.m_sid2crc >> 8 ^ crc32Table[(int)(this.m_sid2crc & 0xFFL ^ (long)data)];
            this.m_info.sid2crc = this.m_sid2crc ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public void lightpen() {
        this.vic.lightpen();
    }

    private int psidDrvReloc(SidTuneInfo tuneInfo, ISID2Types.sid2_info_t info) {
        int startlp = tuneInfo.loadAddr >> 8;
        int endlp = tuneInfo.loadAddr + (tuneInfo.c64dataLen - 1) >> 8;
        if (info.environment != ISID2Types.sid2_env_t.sid2_envR) {
            info.driverAddr = 0;
            info.driverLength = 0;
            info.powerOnDelay = 0;
            return 0;
        }
        if (tuneInfo.compatibility == 3) {
            tuneInfo.relocStartPage = (short)4;
            tuneInfo.relocPages = (short)3;
        }
        if (tuneInfo.relocStartPage == 255) {
            tuneInfo.relocPages = 0;
        } else if (tuneInfo.relocStartPage == 0) {
            this.psidRelocAddr(tuneInfo, startlp, endlp);
        }
        if (tuneInfo.relocPages < 1) {
            this.m_errorString = ERR_PSIDDRV_NO_SPACE;
            return -1;
        }
        short[] reloc_driver = IPSIDDrv.PSIDDRV;
        int reloc_size = IPSIDDrv.PSIDDRV.length;
        int relocAddr = tuneInfo.relocStartPage << 8;
        BufPos bp = this.reloc65(reloc_driver, reloc_size, relocAddr - 10);
        if (bp == null) {
            this.m_errorString = ERR_PSIDDRV_RELOC;
            return -1;
        }
        reloc_driver = bp.fBuf;
        int reloc_driverPos = bp.fPos;
        reloc_size = bp.fSize;
        info.driverAddr = relocAddr;
        info.driverLength = reloc_size -= 10;
        info.driverLength += 255;
        info.driverLength &= 0xFF00;
        this.m_rom[65532] = reloc_driver[reloc_driverPos + 0];
        this.m_rom[65533] = reloc_driver[reloc_driverPos + 1];
        if (tuneInfo.compatibility == 3) {
            short[] prg = new short[]{169, (short)(tuneInfo.currentSong - 1), 141, 12, 3, 32, 44, 168, 76, 177, 167};
            for (int i = 0; i < prg.length; ++i) {
                this.m_rom[48979 + i] = prg[i];
            }
            this.m_rom[42926] = 76;
            SIDEndian.endian_little16(this.m_rom, 42927, 48979);
        } else {
            if (tuneInfo.compatibility == 2) {
                this.m_ram[788] = reloc_driver[reloc_driverPos + 2];
                this.m_ram[789] = reloc_driver[reloc_driverPos + 2 + 1];
            } else {
                this.m_ram[788] = reloc_driver[reloc_driverPos + 2];
                this.m_ram[789] = reloc_driver[reloc_driverPos + 2 + 1];
                this.m_ram[790] = reloc_driver[reloc_driverPos + 2 + 2];
                this.m_ram[791] = reloc_driver[reloc_driverPos + 2 + 3];
                this.m_ram[792] = reloc_driver[reloc_driverPos + 2 + 4];
                this.m_ram[793] = reloc_driver[reloc_driverPos + 2 + 5];
            }
            int addr = SIDEndian.endian_little16(reloc_driver, reloc_driverPos + 8);
            this.m_rom[42926] = 76;
            SIDEndian.endian_little16(this.m_rom, 42927, 65505);
            SIDEndian.endian_little16(this.m_ram, 808, addr);
        }
        for (int i = 0; i < reloc_size; ++i) {
            this.m_rom[i] = reloc_driver[reloc_driverPos + 10 + i];
        }
        short[] addr = this.m_rom;
        int pos = 0;
        addr[pos++] = (short)(tuneInfo.currentSong - 1);
        addr[pos] = tuneInfo.songSpeed == 0 ? (short)0 : 1;
        SIDEndian.endian_little16(addr, ++pos, tuneInfo.compatibility == 3 ? 48981 : tuneInfo.initAddr);
        SIDEndian.endian_little16(addr, pos += 2, tuneInfo.playAddr);
        pos += 2;
        info.powerOnDelay = this.m_cfg.powerOnDelay;
        if (info.powerOnDelay > 8191) {
            info.powerOnDelay = (short)(this.m_rand >> 3) & 0x1FFF;
        }
        SIDEndian.endian_little16(addr, pos, info.powerOnDelay);
        pos += 2;
        this.m_rand = this.m_rand * 13 + 1;
        addr[pos++] = this.iomap(this.m_tuneInfo.initAddr);
        addr[pos++] = this.iomap(this.m_tuneInfo.playAddr);
        short s = this.m_ram[678];
        addr[pos + 0] = s;
        addr[pos + 1] = s;
        ++pos;
        switch (this.m_tune.getInfo().clockSpeed) {
            case 1: {
                addr[pos++] = 1;
                break;
            }
            case 2: {
                addr[pos++] = 0;
                break;
            }
            default: {
                ++pos;
            }
        }
        addr[pos++] = tuneInfo.compatibility >= 2 ? 0 : 4;
        return 0;
    }

    private void psidDrvInstall(ISID2Types.sid2_info_t info) {
        for (int i = 0; i < info.driverLength; ++i) {
            this.m_ram[info.driverAddr + i] = this.m_rom[i];
        }
    }

    private void psidRelocAddr(SidTuneInfo tuneInfo, int startp, int endp) {
        int i;
        boolean[] pages = new boolean[256];
        int[] used = new int[]{0, 3, 160, 191, 208, 255, startp, startp <= endp && endp <= 255 ? endp : 255};
        for (i = 0; i < pages.length; ++i) {
            pages[i] = false;
        }
        for (i = 0; i < used.length; i += 2) {
            for (int page = used[i]; page <= used[i + 1]; ++page) {
                pages[page] = true;
            }
        }
        int lastPage = 0;
        tuneInfo.relocPages = 0;
        for (int page = 0; page < pages.length; ++page) {
            if (!pages[page]) continue;
            int relocPages = page - lastPage;
            if (relocPages > tuneInfo.relocPages) {
                tuneInfo.relocStartPage = (short)lastPage;
                tuneInfo.relocPages = (short)relocPages;
            }
            lastPage = page + 1;
        }
        if (tuneInfo.relocPages == 0) {
            tuneInfo.relocStartPage = (short)255;
        }
    }

    public Player() {
        super(new EventScheduler("SIDPlay 2"));
        int i;
        this.m_scheduler = (EventScheduler)this.context();
        this.envp = new C64Environment(){

            @Override
            protected void envReset() {
                Player.this.envReset(true);
            }

            @Override
            protected short envReadMemByte(int addr) {
                return Player.this.m_mem.m_readMemByte(addr);
            }

            @Override
            protected void envWriteMemByte(int addr, short data) {
                Player.this.m_mem.m_writeMemByte(addr, data);
            }

            @Override
            protected boolean envCheckBankJump(int addr) {
                block0 : switch (((Player)Player.this).m_info.environment) {
                    case sid2_envBS: {
                        if (addr < 40960) break;
                        switch (addr >> 12) {
                            case 10: 
                            case 11: {
                                if (!Player.this.isBasic) break block0;
                                return false;
                            }
                            case 12: {
                                break block0;
                            }
                            case 13: {
                                if (!Player.this.isIO) break block0;
                                return false;
                            }
                        }
                        if (!Player.this.isKernal) break;
                        return false;
                    }
                    case sid2_envTP: {
                        if (addr < 53248 || !Player.this.isKernal) break;
                        return false;
                    }
                }
                return true;
            }

            @Override
            protected short envReadMemDataByte(int addr) {
                return Player.this.m_mem.m_readMemDataByte(addr);
            }

            @Override
            protected void envSleep() {
                if (((Player)Player.this).m_info.environment != ISID2Types.sid2_env_t.sid2_envR) {
                    Player.this.xsid.suppress(false);
                    Player.this.xsid.suppress(true);
                }
            }

            @Override
            protected void envLoadFile(String file) {
                StringBuffer name = new StringBuffer("E:/testsuite/");
                name.append(file);
                name.append(".prg");
                Player.this.m_tune.load(name.toString());
                Player.this.stop();
            }
        };
        this.sid6510 = new SID6510(this.m_scheduler);
        this.mos6510 = new MOS6510(this.m_scheduler);
        this.cpu = this.sid6510;
        this.nullsid = new NullSID();
        this.xsid = new C64XSID(this, this.nullsid);
        this.cia = new C64CIA.C64cia1(this);
        this.cia2 = new C64CIA.C64cia2(this);
        this.sid6526 = new SID6526(this);
        this.vic = new C64VIC(this);
        this.mixerEvent = new EventMixer(this);
        this.rtc = new EventRTC(this.m_scheduler);
        this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
        this.m_rand = (int)System.currentTimeMillis();
        this.sid6510.setEnvironment(this.envp);
        this.mos6510.setEnvironment(this.envp);
        for (i = 0; i < 2; ++i) {
            this.sid[i] = this.nullsid;
        }
        this.xsid.emulation(this.sid[0]);
        this.sid[0] = this.xsid;
        for (i = 0; i < 32; ++i) {
            this.m_sidmapper[i] = 0;
        }
        this.m_info.credits = credit;
        this.m_info.channels = 1;
        this.m_info.driverAddr = 0;
        this.m_info.driverLength = 0;
        this.m_info.name = "libsidplay";
        this.m_info.tuneInfo = null;
        this.m_info.version = "2.1.1";
        this.m_info.eventContext = this.context();
        this.m_info.maxsids = 2;
        this.m_info.environment = ISID2Types.sid2_env_t.sid2_envR;
        this.m_info.sid2crc = 0L;
        this.m_info.sid2crcCount = 0L;
        this.m_cfg.clockDefault = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
        this.m_cfg.clockForced = false;
        this.m_cfg.clockSpeed = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
        this.m_cfg.environment = this.m_info.environment;
        this.m_cfg.forceDualSids = false;
        this.m_cfg.emulateStereo = this.m_emulateStereo;
        this.m_cfg.frequency = 44100L;
        this.m_cfg.optimisation = 1;
        this.m_cfg.playback = ISID2Types.sid2_playback_t.sid2_mono;
        this.m_cfg.precision = 16;
        this.m_cfg.sidDefault = ISID2Types.sid2_model_t.SID2_MODEL_CORRECT;
        this.m_cfg.sidEmulation = null;
        this.m_cfg.sidModel = ISID2Types.sid2_model_t.SID2_MODEL_CORRECT;
        this.m_cfg.sidSamples = true;
        this.m_cfg.leftVolume = 255L;
        this.m_cfg.rightVolume = 255L;
        this.m_cfg.sampleFormat = ISID2Types.sid2_sample_t.SID2_LITTLE_SIGNED;
        this.m_cfg.powerOnDelay = 8192;
        this.m_cfg.sid2crcCount = 0L;
        this.config(this.m_cfg);
        Player.credit[0] = "libsidplay V2.1.1 Engine:\n\tCopyright (C) 2000 Simon White <sidplay2@yahoo.com>\n\thttp://sidplay2.sourceforge.net\n";
        Player.credit[1] = this.xsid.credits();
        Player.credit[2] = "*MOS6510 (CPU) Emulation:\n\tCopyright (C) 2000 Simon White <sidplay2@yahoo.com>\n";
        Player.credit[3] = this.cia.credits();
        Player.credit[4] = this.vic.credits();
        Player.credit[5] = null;
    }

    public final ISID2Types.sid2_config_t config() {
        return this.m_cfg;
    }

    public final ISID2Types.sid2_info_t info() {
        return this.m_info;
    }

    public int config(ISID2Types.sid2_config_t cfg) {
        boolean monosid = false;
        if (this.m_running) {
            this.m_errorString = ERR_CONF_WHILST_ACTIVE;
            return -1;
        }
        if (cfg.frequency < 4000L) {
            this.m_errorString = ERR_UNSUPPORTED_FREQ;
            return -1;
        }
        switch (cfg.precision) {
            case 8: 
            case 16: 
            case 24: {
                if (cfg.precision <= 16) break;
                this.m_errorString = ERR_UNSUPPORTED_PRECISION;
                return -1;
            }
            default: {
                this.m_errorString = ERR_UNSUPPORTED_PRECISION;
                return -1;
            }
        }
        if (this.m_tune != null && this.m_tune.bool()) {
            if (this.m_playerState != ISID2Types.sid2_player_t.sid2_paused) {
                this.m_tuneInfo = this.m_tune.getInfo();
            }
            if (this.sidCreate(cfg.sidEmulation, cfg.sidModel, cfg.sidDefault) < 0) {
                this.m_errorString = cfg.sidEmulation.error();
                this.m_cfg.sidEmulation = null;
                if (this.m_cfg != cfg) {
                    this.config(this.m_cfg);
                }
                return -1;
            }
            if (this.m_playerState != ISID2Types.sid2_player_t.sid2_paused) {
                double cpuFreq = this.clockSpeed(cfg.clockSpeed, cfg.clockDefault, cfg.clockForced);
                this.m_samplePeriod = (long)(cpuFreq / (double)cfg.frequency * 65536.0 * this.m_fastForwardFactor);
                this.sid6526.clock((int)(cpuFreq / 50.0 + 0.5));
                if (this.m_tuneInfo.songSpeed == 60 || this.m_tuneInfo.clockSpeed == 2) {
                    this.sid6526.clock((int)(cpuFreq / 60.0 + 0.5));
                }
                if (this.m_tuneInfo.clockSpeed == 1) {
                    this.cia.clock(cpuFreq / 50.0);
                    this.cia2.clock(cpuFreq / 50.0);
                } else {
                    this.cia.clock(cpuFreq / 60.0);
                    this.cia2.clock(cpuFreq / 60.0);
                }
                if (this.environment(cfg.environment) < 0) {
                    if (this.m_cfg != cfg) {
                        this.config(this.m_cfg);
                    }
                    return -1;
                }
                this.rtc.clock(cpuFreq);
            }
        }
        this.sidSamples(cfg.sidSamples);
        for (int i = 0; i < 32; ++i) {
            this.m_sidmapper[i] = 0;
        }
        if (this.m_tuneInfo.sidChipBase2 != 0) {
            monosid = false;
            this.m_sidmapper[this.m_tuneInfo.sidChipBase2 >> 5 & 0x1F] = 1;
        }
        monosid = this.m_tuneInfo.sidChipBase2 == 0;
        this.m_info.channels = 1;
        this.m_emulateStereo = false;
        if (cfg.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
            ++this.m_info.channels;
            if (monosid && this.sid[1] != this.nullsid) {
                this.m_emulateStereo = cfg.emulateStereo;
            }
        }
        if (monosid && cfg.forceDualSids) {
            monosid = false;
            this.m_sidmapper[8] = 1;
        }
        this.m_leftVolume = cfg.leftVolume;
        this.m_rightVolume = cfg.rightVolume;
        if (cfg.playback != ISID2Types.sid2_playback_t.sid2_mono) {
            if (this.m_emulateStereo) {
                this.sid[0].voice((short)0, (short)0, true);
                this.sid[0].voice((short)2, (short)0, true);
                this.sid[1].voice((short)1, (short)0, true);
                monosid = false;
            }
            if (cfg.playback == ISID2Types.sid2_playback_t.sid2_left) {
                this.xsid.mute(true);
            }
        }
        block3 : switch (cfg.precision) {
            case 8: {
                if (monosid) {
                    if (cfg.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.stereoOut8MonoIn(buffer, off);
                            }
                        };
                        break;
                    }
                    this.output = new IOutput(){

                        @Override
                        public long output(short[] buffer, int off) {
                            return Player.this.monoOut8MonoIn(buffer, off);
                        }
                    };
                    break;
                }
                switch (cfg.playback) {
                    case sid2_stereo: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.stereoOut8StereoIn(buffer, off);
                            }
                        };
                        break;
                    }
                    case sid2_right: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut8StereoRIn(buffer, off);
                            }
                        };
                        break;
                    }
                    case sid2_left: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut8MonoIn(buffer, off);
                            }
                        };
                        break;
                    }
                    case sid2_mono: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut8StereoIn(buffer, off);
                            }
                        };
                    }
                }
                break;
            }
            case 16: {
                if (monosid) {
                    if (cfg.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.stereoOut16MonoIn(buffer, off);
                            }
                        };
                        break;
                    }
                    this.output = new IOutput(){

                        @Override
                        public long output(short[] buffer, int off) {
                            return Player.this.monoOut16MonoIn(buffer, off);
                        }
                    };
                    break;
                }
                switch (cfg.playback) {
                    case sid2_stereo: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.stereoOut16StereoIn(buffer, off);
                            }
                        };
                        break block3;
                    }
                    case sid2_right: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut16StereoRIn(buffer, off);
                            }
                        };
                        break block3;
                    }
                    case sid2_left: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut16MonoIn(buffer, off);
                            }
                        };
                        break block3;
                    }
                    case sid2_mono: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] buffer, int off) {
                                return Player.this.monoOut16StereoIn(buffer, off);
                            }
                        };
                    }
                }
            }
        }
        this.m_cfg = cfg;
        if (this.m_cfg.optimisation > 2) {
            this.m_cfg.optimisation = (byte)2;
        }
        return 0;
    }

    public int fastForward(int percent) {
        if (percent > 3200) {
            this.m_errorString = "SIDPLAYER ERROR: Percentage value out of range";
            return -1;
        }
        double fastForwardFactor = (double)percent / 100.0;
        this.m_samplePeriod = (long)((double)this.m_samplePeriod / this.m_fastForwardFactor * fastForwardFactor);
        this.m_fastForwardFactor = fastForwardFactor;
        return 0;
    }

    public int load(SidTune tune) {
        this.m_tune = tune;
        if (tune == null || !tune.bool()) {
            this.m_info.tuneInfo = null;
            return 0;
        }
        this.xsid.mute(false);
        block0: for (int i = 0; i < 2; ++i) {
            short v = 3;
            while (true) {
                short s = v;
                v = (short)(v - 1);
                if (s == 0) continue block0;
                this.sid[i].voice(v, (short)0, false);
            }
        }
        int ret = this.config(this.m_cfg);
        if (ret < 0) {
            this.m_tune = null;
            return -1;
        }
        this.m_info.tuneInfo = this.m_tuneInfo;
        return 0;
    }

    public long mileage() {
        return this.m_mileage + this.time();
    }

    public void pause() {
        if (this.m_running) {
            this.m_playerState = ISID2Types.sid2_player_t.sid2_paused;
            this.m_running = false;
        }
    }

    public long play(short[] buffer, int length) {
        if (!this.m_tune.bool()) {
            return 0L;
        }
        this.m_sampleIndex = 0;
        this.m_sampleCount = length;
        this.m_sampleBuffer = buffer;
        this.m_playerState = ISID2Types.sid2_player_t.sid2_playing;
        this.m_running = true;
        while (this.m_running) {
            this.m_scheduler.clock();
        }
        if (this.m_playerState == ISID2Types.sid2_player_t.sid2_stopped) {
            this.initialise();
        }
        return this.m_sampleIndex;
    }

    public ISID2Types.sid2_player_t state() {
        return this.m_playerState;
    }

    public void stop() {
        if (this.m_tune != null && this.m_tune.bool() && this.m_playerState != ISID2Types.sid2_player_t.sid2_stopped) {
            if (!this.m_running) {
                this.initialise();
            } else {
                this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
                this.m_running = false;
            }
        }
    }

    public long time() {
        return this.rtc.getTime();
    }

    public void debug(boolean enable) {
        this.cpu.debug(enable);
    }

    public final String error() {
        return this.m_errorString;
    }

    private int read_options(short[] buf, int pos) {
        int l = 0;
        int c = buf[pos + 0];
        while (c != 0 && c != -1) {
            c = buf[pos + (l += (c &= 0xFF))];
        }
        return ++l;
    }

    private int read_undef(short[] buf, int pos) {
        int l = 2;
        int n = buf[pos + 0] + 256 * buf[pos + 1];
        while (n != 0) {
            --n;
            while (buf[pos + l++] == 0) {
            }
        }
        return l;
    }

    private int reloc_seg(short[] buf, int bufPos, int len, short[] rtab, int rtabPos, file65 fp) {
        int adr = -1;
        while (rtab[rtabPos] != 0) {
            if ((rtab[rtabPos] & 0xFF) == 255) {
                adr += 254;
                ++rtabPos;
                continue;
            }
            adr += rtab[rtabPos] & 0xFF;
            int type = rtab[++rtabPos] & 0xE0;
            int seg = rtab[rtabPos] & 7;
            ++rtabPos;
            switch (type) {
                case 128: {
                    int old = buf[bufPos + adr] + 256 * buf[bufPos + adr + 1];
                    int newv = old + this.reldiff(seg, fp);
                    buf[bufPos + adr] = (short)(newv & 0xFF);
                    buf[bufPos + adr + 1] = (short)(newv >> 8 & 0xFF);
                    break;
                }
                case 64: {
                    int old = buf[bufPos + adr] * 256 + rtab[rtabPos];
                    int newv = old + this.reldiff(seg, fp);
                    buf[bufPos + adr] = (short)(newv >> 8 & 0xFF);
                    rtab[rtabPos] = (short)(newv & 0xFF);
                    ++rtabPos;
                    break;
                }
                case 32: {
                    int old = buf[bufPos + adr];
                    int newv = old + this.reldiff(seg, fp);
                    buf[bufPos + adr] = (short)(newv & 0xFF);
                }
            }
            if (seg != 0) continue;
            rtabPos += 2;
        }
        if (adr > len) {
            // empty if block
        }
        return ++rtabPos;
    }

    private int reloc_globals(short[] buf, int bufPos, file65 fp) {
        int n = buf[bufPos + 0] + 256 * buf[bufPos + 1];
        bufPos += 2;
        while (n != 0) {
            while (buf[bufPos++] != 0) {
            }
            short seg = buf[bufPos];
            int old = buf[bufPos + 1] + 256 * buf[bufPos + 2];
            int newv = old + this.reldiff(seg, fp);
            buf[bufPos + 1] = (short)(newv & 0xFF);
            buf[bufPos + 2] = (short)(newv >> 8 & 0xFF);
            bufPos += 3;
            --n;
        }
        return bufPos;
    }

    private BufPos reloc65(short[] buf, int fsize, int addr) {
        boolean tflag = false;
        boolean dflag = false;
        boolean bflag = false;
        boolean zflag = false;
        int tbase = 0;
        int dbase = 0;
        int bbase = 0;
        int zbase = 0;
        int extract = 0;
        file65.access$2602(this.file, buf);
        tflag = true;
        tbase = addr;
        extract = 1;
        for (int i = 0; i < 5; ++i) {
            if (this.file.buf[i] == this.cmp[i]) continue;
            return null;
        }
        int mode = this.file.buf[7] * 256 + this.file.buf[6];
        if ((mode & 0x2000) != 0) {
            return null;
        }
        if ((mode & 0x4000) != 0) {
            return null;
        }
        int hlen = 26 + this.read_options(this.file.buf, 26);
        this.file.tbase = this.file.buf[9] * 256 + this.file.buf[8];
        this.file.tlen = this.file.buf[11] * 256 + this.file.buf[10];
        this.file.tdiff = tflag ? tbase - this.file.tbase : 0;
        this.file.dbase = this.file.buf[13] * 256 + this.file.buf[12];
        this.file.dlen = this.file.buf[15] * 256 + this.file.buf[14];
        this.file.ddiff = dflag ? dbase - this.file.dbase : 0;
        this.file.bbase = this.file.buf[17] * 256 + this.file.buf[16];
        this.file.bdiff = bflag ? bbase - this.file.bbase : 0;
        this.file.zbase = this.file.buf[21] * 256 + this.file.buf[20];
        this.file.zdiff = zflag ? zbase - this.file.zbase : 0;
        file65.access$3702(this.file, this.file.buf);
        int segtPos = hlen;
        file65.access$3802(this.file, this.file.segt);
        int sehdPos = segtPos + this.file.tlen;
        file65.access$3902(this.file, this.file.segd);
        int utabPos = sehdPos + this.file.dlen;
        file65.access$4002(this.file, this.file.utab);
        int rttabPos = utabPos + this.read_undef(this.file.utab, utabPos);
        file65.access$4102(this.file, this.file.rttab);
        file65.access$4202(this.file, this.file.rdtab);
        int rdtabPos = this.reloc_seg(this.file.segt, segtPos, this.file.tlen, this.file.rttab, rttabPos, this.file);
        int extabPos = this.reloc_seg(this.file.segd, sehdPos, this.file.dlen, this.file.rdtab, rdtabPos, this.file);
        this.reloc_globals(this.file.extab, extabPos, this.file);
        if (tflag) {
            ((file65)this.file).buf[9] = (short)(tbase >> 8 & 0xFF);
            ((file65)this.file).buf[8] = (short)(tbase & 0xFF);
        }
        if (dflag) {
            ((file65)this.file).buf[13] = (short)(dbase >> 8 & 0xFF);
            ((file65)this.file).buf[12] = (short)(dbase & 0xFF);
        }
        if (bflag) {
            ((file65)this.file).buf[17] = (short)(bbase >> 8 & 0xFF);
            ((file65)this.file).buf[16] = (short)(bbase & 0xFF);
        }
        if (zflag) {
            ((file65)this.file).buf[21] = (short)(zbase >> 8 & 0xFF);
            ((file65)this.file).buf[20] = (short)(zbase & 0xFF);
        }
        switch (extract) {
            case 0: {
                return new BufPos(buf, 0, fsize);
            }
            case 1: {
                return new BufPos(this.file.segt, segtPos, this.file.tlen);
            }
            case 2: {
                return new BufPos(this.file.segd, sehdPos, this.file.dlen);
            }
        }
        return null;
    }

    private int reldiff(int s, file65 fp) {
        return s == 2 ? fp.tdiff : (s == 3 ? fp.ddiff : (s == 4 ? fp.bdiff : (s == 5 ? fp.zdiff : 0)));
    }

    private static class BufPos {
        short[] fBuf;
        int fPos;
        int fSize;

        public BufPos(short[] buf, int pos, int size) {
            this.fBuf = buf;
            this.fPos = pos;
            this.fSize = size;
        }
    }

    private static class file65 {
        private short[] buf;
        private int tbase;
        private int tlen;
        private int dbase;
        private int dlen;
        private int bbase;
        private int zbase;
        private int tdiff;
        private int ddiff;
        private int bdiff;
        private int zdiff;
        private short[] segt;
        private short[] segd;
        private short[] utab;
        private short[] rttab;
        private short[] rdtab;
        private short[] extab;

        private file65() {
        }

        static /* synthetic */ short[] access$2602(file65 x0, short[] x1) {
            x0.buf = x1;
            return x1;
        }

        static /* synthetic */ short[] access$3702(file65 x0, short[] x1) {
            x0.segt = x1;
            return x1;
        }

        static /* synthetic */ short[] access$3802(file65 x0, short[] x1) {
            x0.segd = x1;
            return x1;
        }

        static /* synthetic */ short[] access$3902(file65 x0, short[] x1) {
            x0.utab = x1;
            return x1;
        }

        static /* synthetic */ short[] access$4002(file65 x0, short[] x1) {
            x0.rttab = x1;
            return x1;
        }

        static /* synthetic */ short[] access$4102(file65 x0, short[] x1) {
            x0.rdtab = x1;
            return x1;
        }

        static /* synthetic */ short[] access$4202(file65 x0, short[] x1) {
            x0.extab = x1;
            return x1;
        }
    }

    static interface IOutput {
        public long output(short[] var1, int var2);
    }

    private static interface IMem {
        public short m_readMemByte(int var1);

        public void m_writeMemByte(int var1, short var2);

        public short m_readMemDataByte(int var1);
    }

    private static class Port {
        short pr_out;
        short ddr;
        short pr_in;

        private Port() {
        }
    }

    private static class EventRTC
    extends Event {
        private IEventContext m_eventContext;
        private long m_seconds;
        private long m_period;
        private long m_clk;

        @Override
        public void event() {
            this.m_clk += this.m_period;
            long cycles = this.m_clk >> 7;
            this.m_clk &= 0x7FL;
            ++this.m_seconds;
            this.m_eventContext.schedule(this, cycles, Event.event_phase_t.EVENT_CLOCK_PHI1);
        }

        public EventRTC(IEventContext context) {
            super("RTC");
            this.m_eventContext = context;
            this.m_seconds = 0L;
        }

        public long getTime() {
            return this.m_seconds;
        }

        public void reset() {
            this.m_seconds = 0L;
            this.m_clk = this.m_period & 0x7FL;
            this.m_eventContext.schedule(this, this.m_period >> 7, Event.event_phase_t.EVENT_CLOCK_PHI1);
        }

        public void clock(double period) {
            this.m_period = (long)(period / 10.0 * 128.0);
            this.reset();
        }
    }

    private static class EventMixer
    extends Event {
        private Player m_player;

        @Override
        public void event() {
            this.m_player.mixer();
        }

        public EventMixer(Player player) {
            super("Mixer");
            this.m_player = player;
        }
    }
}

