/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common;

public class SIDEndian {
    public static final int SID_WORDS_BIGENDIAN = 0;
    public static final int SID_WORDS_LITTLEENDIAN = 1;
    public static final int SID_WORDS = 1;

    public static final int endian_16lo8(int word, short thebyte) {
        word &= 0xFF00;
        return word |= thebyte;
    }

    public static final short endian_16lo8(int word) {
        return (short)(word & 0xFF);
    }

    public static final int endian_16hi8(int word, short thebyte) {
        word &= 0xFF;
        return word |= thebyte << 8;
    }

    public static final short endian_16hi8(int word) {
        return (short)(word >> 8 & 0xFF);
    }

    public static final int endian_16swap8(int word) {
        short lo = SIDEndian.endian_16lo8(word);
        short hi = SIDEndian.endian_16hi8(word);
        word = 0;
        word = SIDEndian.endian_16lo8(word, hi);
        word |= SIDEndian.endian_16hi8(word, lo);
        return word;
    }

    public static final int endian_16(short hi, short lo) {
        int word = 0;
        word = SIDEndian.endian_16lo8(word, lo);
        word |= SIDEndian.endian_16hi8(word, hi);
        return word;
    }

    public static final void endian_16(short[] ptr, int pos, int word) {
        ptr[pos + 0] = SIDEndian.endian_16lo8(word);
        ptr[pos + 1] = SIDEndian.endian_16hi8(word);
    }

    public static final void endian_16(char[] ptr, int pos, int word) {
        short[] newptr = new short[]{(short)ptr[pos + 0], (short)ptr[pos + 1]};
        SIDEndian.endian_16(newptr, 0, word);
        ptr[pos + 0] = (char)newptr[0];
        ptr[pos + 1] = (char)newptr[1];
    }

    public static final int endian_little16(short[] ptr, int pos) {
        return SIDEndian.endian_16(ptr[pos + 1], ptr[pos + 0]);
    }

    public static final void endian_little16(short[] ptr, int pos, int word) {
        ptr[pos + 0] = SIDEndian.endian_16lo8(word);
        ptr[pos + 1] = SIDEndian.endian_16hi8(word);
    }

    public static final int endian_big16(short[] ptr, int pos) {
        return SIDEndian.endian_16(ptr[pos + 0], ptr[pos + 1]);
    }

    public static final void endian_big16(short[] ptr, int pos, int word) {
        ptr[pos + 0] = SIDEndian.endian_16hi8(word);
        ptr[pos + 1] = SIDEndian.endian_16lo8(word);
    }

    public static final long endian_32lo16(long dword, int word) {
        dword &= 0xFFFFFFFFFFFF0000L;
        return dword |= (long)word;
    }

    public static final int endian_32lo16(long dword) {
        return (int)dword & 0xFFFF;
    }

    public static final long endian_32hi16(long dword, int word) {
        dword &= 0xFFFFL;
        return dword |= (long)word << 16;
    }

    public static final int endian_32hi16(long dword) {
        return (int)dword >> 16;
    }

    public static final long endian_32lo8(long dword, short theByte) {
        dword &= 0xFFFFFFFFFFFFFF00L;
        return dword |= (long)theByte;
    }

    public static final short endian_32lo8(long dword) {
        return (short)(dword & 0xFFL);
    }

    public static final long endian_32hi8(long dword, short theByte) {
        dword &= 0xFFFFFFFFFFFF00FFL;
        return dword |= (long)theByte << 8;
    }

    public static final short endian_32hi8(long dword) {
        return (short)(dword >> 8 & 0xFFL);
    }

    public static final long endian_32swap16(long dword) {
        int lo = SIDEndian.endian_32lo16(dword);
        int hi = SIDEndian.endian_32hi16(dword);
        dword = 0L;
        dword |= SIDEndian.endian_32lo16(dword, hi);
        dword |= SIDEndian.endian_32hi16(dword, lo);
        return dword;
    }

    public static final long endian_32swap8(long dword) {
        int lo = SIDEndian.endian_32lo16(dword);
        int hi = SIDEndian.endian_32hi16(dword);
        lo = SIDEndian.endian_16swap8(lo);
        hi = SIDEndian.endian_16swap8(hi);
        dword = 0L;
        dword |= SIDEndian.endian_32lo16(dword, hi);
        dword |= SIDEndian.endian_32hi16(dword, lo);
        return dword;
    }

    public static final long endian_32(short hihi, short hilo, short hi, short lo) {
        long dword = 0L;
        int word = 0;
        dword = SIDEndian.endian_32lo8(dword, lo);
        dword |= SIDEndian.endian_32hi8(dword, hi);
        word = SIDEndian.endian_16lo8(word, hilo);
        word |= SIDEndian.endian_16hi8(word, hihi);
        dword |= SIDEndian.endian_32hi16(dword, word);
        return dword;
    }

    public static final long endian_little32(short[] ptr, int pos) {
        return SIDEndian.endian_32(ptr[pos + 3], ptr[pos + 2], ptr[pos + 1], ptr[pos + 0]);
    }

    public static final void endian_little32(short[] ptr, int pos, long dword) {
        int word = 0;
        ptr[pos + 0] = SIDEndian.endian_32lo8(dword);
        ptr[pos + 1] = SIDEndian.endian_32hi8(dword);
        word = SIDEndian.endian_32hi16(dword);
        ptr[pos + 2] = SIDEndian.endian_16lo8(word);
        ptr[pos + 3] = SIDEndian.endian_16hi8(word);
    }

    public static final long endian_big32(short[] ptr, int pos) {
        return SIDEndian.endian_32(ptr[pos + 0], ptr[pos + 1], ptr[pos + 2], ptr[pos + 3]);
    }

    public static final void endian_big32(short[] ptr, int pos, long dword) {
        int word = 0;
        word = SIDEndian.endian_32hi16(dword);
        ptr[pos + 1] = SIDEndian.endian_16lo8(word);
        ptr[pos + 0] = SIDEndian.endian_16hi8(word);
        ptr[pos + 2] = SIDEndian.endian_32hi8(dword);
        ptr[pos + 3] = SIDEndian.endian_32lo8(dword);
    }
}

