/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common.mos6510;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.common.mos6510.C64Environment;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MOS6510
extends C64Environment {
    public static final String MOS6510_VERSION = "1.08";
    public static final String MOS6510_DATE = "23th May 2000";
    public static final String MOS6510_AUTHOR = "Simon White";
    public static final String MOS6510_EMAIL = "sidplay2@yahoo.com";
    public static final int MOS6510_INTERRUPT_DELAY = 2;
    public static final int SR_NEGATIVE = 7;
    public static final int SR_OVERFLOW = 6;
    public static final int SR_NOTUSED = 5;
    public static final int SR_BREAK = 4;
    public static final int SR_DECIMAL = 3;
    public static final int SR_INTERRUPT = 2;
    public static final int SR_ZERO = 1;
    public static final int SR_CARRY = 0;
    public static final short SP_PAGE = 1;
    public static final boolean PC64_TESTSUITE = false;
    private static final char[] _sidtune_CHRtab = new char[]{'\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\r', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', ' ', '!', '\u0001', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '$', ']', ' ', ' ', '-', '#', '|', '-', '-', '-', '-', '|', '|', '\\', '\\', '/', '\\', '\\', '/', '/', '\\', '#', '_', '#', '|', '/', 'X', 'O', '#', '|', '#', '+', '|', '|', '&', '\\', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', ' ', '|', '#', '-', '-', '|', '#', '|', '#', '/', '|', '|', '/', '\\', '\\', '-', '/', '-', '-', '|', '|', '|', '|', '-', '-', '-', '/', '\\', '\\', '/', '/', '#', '-', '#', '|', '-', '-', '-', '-', '|', '|', '\\', '\\', '/', '\\', '\\', '/', '/', '\\', '#', '_', '#', '|', '/', 'X', 'O', '#', '|', '#', '+', '|', '|', '&', '\\', ' ', '|', '#', '-', '-', '|', '#', '|', '#', '/', '|', '|', '/', '\\', '\\', '-', '/', '-', '-', '|', '|', '|', '|', '-', '-', '-', '/', '\\', '\\', '/', '/', '#'};
    private static char[] filetmp = new char[256];
    private static int filepos = 0;
    protected boolean aec;
    protected boolean m_blocked;
    protected long m_stealingClk;
    protected long m_dbgClk;
    protected static final Logger MOS6510 = Logger.getLogger(MOS6510.class.getName());
    protected boolean dodump;
    protected IEventContext eventContext;
    protected Event.event_phase_t m_phase;
    protected Event.event_phase_t m_extPhase;
    protected ProcessorCycle fetchCycle = new ProcessorCycle();
    protected ProcessorCycle[] procCycle;
    protected ProcessorOperations[] instrTable = new ProcessorOperations[256];
    protected ProcessorOperations[] interruptTable = new ProcessorOperations[3];
    protected ProcessorOperations instrCurrent;
    protected int instrStartPC;
    protected short instrOpcode;
    protected byte lastAddrCycle;
    protected byte cycleCount;
    protected int Cycle_EffectiveAddress;
    protected short Cycle_Data;
    protected int Cycle_Pointer;
    protected short Register_Accumulator;
    protected short Register_X;
    protected short Register_Y;
    protected long Register_ProgramCounter;
    protected short Register_Status;
    protected short Register_c_Flag;
    protected short Register_n_Flag;
    protected short Register_v_Flag;
    protected short Register_z_Flag;
    protected int Register_StackPointer;
    protected int Instr_Operand;
    protected Interrupts interrupts = new Interrupts();
    protected short Debug_Data;
    protected int Debug_EffectiveAddress;
    protected short Debug_Opcode;
    protected int Debug_Operand;
    protected int Debug_ProgramCounter;
    protected Event event = new Event("CPU"){

        @Override
        public void event() {
            MOS6510.this.eventContext.schedule(MOS6510.this.event, 1L, MOS6510.this.m_phase);
            MOS6510.this.clock();
        }
    };
    int line = 0;
    public static final int iIRQSMAX = 3;
    public static final int oNONE = -1;
    public static final int oRST = 0;
    public static final int oNMI = 1;
    public static final int oIRQ = 2;
    public static final int iNONE = 0;
    public static final int iRST = 1;
    public static final int iNMI = 2;
    public static final int iIRQ = 4;

    protected void clock() {
        byte by = this.cycleCount;
        this.cycleCount = (byte)(by + 1);
        byte i = by;
        if (this.procCycle[i].nosteal || this.aec) {
            this.procCycle[i].func.invoke();
            return;
        }
        if (!this.m_blocked) {
            this.m_blocked = true;
            this.m_stealingClk = this.eventContext.getTime(this.m_phase);
        }
        this.cycleCount = (byte)(this.cycleCount - 1);
        this.eventContext.cancel(this.event);
    }

    protected void Initialise() {
        this.Register_StackPointer = SIDEndian.endian_16((short)1, (short)255);
        this.cycleCount = 0;
        this.procCycle = new ProcessorCycle[]{this.fetchCycle};
        this.Register_Status = (short)48;
        this.setFlagsNZ((short)1);
        this.setFlagC((short)0);
        this.setFlagV((short)0);
        this.Register_ProgramCounter = 0L;
        this.interrupts.irqLatch = false;
        this.interrupts.irqRequest = false;
        if (this.interrupts.irqs != 0) {
            this.interrupts.irqRequest = true;
        }
        this.aec = true;
        this.m_blocked = false;
        this.eventContext.schedule(this.event, 0L, this.m_phase);
    }

    protected void RSTRequest() {
        this.envReset();
    }

    protected void NMIRequest() {
        this.Cycle_EffectiveAddress = SIDEndian.endian_16lo8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65530));
    }

    protected void NMI1Request() {
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65531));
        this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
    }

    protected void IRQRequest() {
        this.PushSR(false);
        this.setFlagI((short)1);
        this.interrupts.irqRequest = false;
    }

    protected void IRQ1Request() {
        this.Cycle_EffectiveAddress = SIDEndian.endian_16lo8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65534));
    }

    protected void IRQ2Request() {
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65535));
        this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
    }

    protected boolean interruptPending() {
        long cycles;
        byte offset;
        byte[] offTable = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0};
        if (!this.interrupts.irqLatch) {
            this.interrupts.pending = (short)(this.interrupts.pending & 0xFB);
            if (this.interrupts.irqRequest) {
                this.interrupts.pending = (short)(this.interrupts.pending | 4);
            }
        }
        byte pending = (byte)this.interrupts.pending;
        block10: while (true) {
            offset = offTable[pending];
            switch (offset) {
                case -1: {
                    return false;
                }
                case 1: {
                    cycles = this.eventContext.getTime(this.interrupts.nmiClk, this.m_extPhase);
                    if (cycles >= 2L) {
                        this.interrupts.pending = (short)(this.interrupts.pending & 0xFD);
                        break block10;
                    }
                    pending = (byte)(pending & 0xFD);
                    continue block10;
                }
                case 2: {
                    cycles = this.eventContext.getTime(this.interrupts.irqClk, this.m_extPhase);
                    if (cycles >= 2L) break block10;
                    pending = (byte)(pending & 0xFB);
                    continue block10;
                }
            }
            break;
        }
        if (MOS6510.isLoggable(Level.FINE)) {
            cycles = this.eventContext.getTime(this.m_phase);
            if (this.dodump) {
                MOS6510.fine("****************************************************\n");
                switch (offset) {
                    case 2: {
                        MOS6510.fine(String.format(" IRQ Routine (%d)\n", cycles));
                        break;
                    }
                    case 1: {
                        MOS6510.fine(String.format(" NMI Routine (%d)\n", cycles));
                        break;
                    }
                    case 0: {
                        MOS6510.fine(String.format(" RST Routine (%d)\n", cycles));
                    }
                }
                MOS6510.fine("****************************************************\n");
            }
        }
        this.instrCurrent = this.interruptTable[offset];
        this.procCycle = this.instrCurrent.cycle;
        this.cycleCount = 0;
        this.clock();
        return true;
    }

    protected void FetchOpcode() {
        this.interrupts.irqLatch = false;
        if (MOS6510.isLoggable(Level.FINE)) {
            this.m_dbgClk = this.eventContext.getTime(this.m_phase);
        }
        this.instrStartPC = SIDEndian.endian_32lo16(this.Register_ProgramCounter++);
        this.instrOpcode = this.envReadMemByte(this.instrStartPC);
        this.instrCurrent = this.instrTable[this.instrOpcode];
        this.Instr_Operand = 0;
        this.procCycle = this.instrCurrent.cycle;
        this.cycleCount = 0;
    }

    protected void NextInstr() {
        if (!this.interruptPending()) {
            this.cycleCount = 0;
            this.procCycle = new ProcessorCycle[]{this.fetchCycle};
            this.clock();
        }
    }

    protected void FetchDataByte() {
        this.Cycle_Data = this.envReadMemByte(SIDEndian.endian_32lo16(this.Register_ProgramCounter));
        ++this.Register_ProgramCounter;
        this.Instr_Operand = this.Cycle_Data;
    }

    protected void FetchLowAddr() {
        this.Cycle_EffectiveAddress = this.envReadMemByte(SIDEndian.endian_32lo16(this.Register_ProgramCounter));
        ++this.Register_ProgramCounter;
        this.Instr_Operand = this.Cycle_EffectiveAddress;
    }

    protected void FetchLowAddrX() {
        this.FetchLowAddr();
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + this.Register_X & 0xFF;
    }

    protected void FetchLowAddrY() {
        this.FetchLowAddr();
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + this.Register_Y & 0xFF;
    }

    protected void FetchHighAddr() {
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemByte(SIDEndian.endian_32lo16(this.Register_ProgramCounter)));
        ++this.Register_ProgramCounter;
        this.Instr_Operand = SIDEndian.endian_16hi8(this.Instr_Operand, SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress));
    }

    protected void FetchHighAddrX() {
        this.FetchHighAddr();
        short page = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress);
        this.Cycle_EffectiveAddress += this.Register_X;
        if (SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) == page) {
            this.cycleCount = (byte)(this.cycleCount + 1);
        }
    }

    protected void FetchHighAddrX2() {
        this.FetchHighAddr();
        this.Cycle_EffectiveAddress += this.Register_X;
    }

    protected void FetchHighAddrY() {
        this.FetchHighAddr();
        short page = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress);
        this.Cycle_EffectiveAddress += this.Register_Y;
        if (SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) == page) {
            this.cycleCount = (byte)(this.cycleCount + 1);
        }
    }

    protected void FetchHighAddrY2() {
        this.FetchHighAddr();
        this.Cycle_EffectiveAddress += this.Register_Y;
    }

    protected void FetchLowEffAddr() {
        this.Cycle_EffectiveAddress = this.envReadMemDataByte(this.Cycle_Pointer);
    }

    protected void FetchHighEffAddr() {
        this.Cycle_Pointer = SIDEndian.endian_16lo8(this.Cycle_Pointer, (short)(this.Cycle_Pointer + 1 & 0xFF));
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(this.Cycle_Pointer));
    }

    protected void FetchHighEffAddrY() {
        this.FetchHighEffAddr();
        short page = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress);
        this.Cycle_EffectiveAddress += this.Register_Y;
        if (SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) == page) {
            this.cycleCount = (byte)(this.cycleCount + 1);
        }
    }

    protected void FetchHighEffAddrY2() {
        this.FetchHighEffAddr();
        this.Cycle_EffectiveAddress += this.Register_Y;
    }

    protected void FetchLowPointer() {
        this.Cycle_Pointer = this.envReadMemByte(SIDEndian.endian_32lo16(this.Register_ProgramCounter));
        ++this.Register_ProgramCounter;
        this.Instr_Operand = this.Cycle_Pointer;
    }

    protected void FetchLowPointerX() {
        this.Cycle_Pointer = SIDEndian.endian_16hi8(this.Cycle_Pointer, this.envReadMemDataByte(this.Cycle_Pointer));
        this.Cycle_Pointer = this.Cycle_Pointer + this.Register_X & 0xFF;
    }

    protected void FetchHighPointer() {
        this.Cycle_Pointer = SIDEndian.endian_16hi8(this.Cycle_Pointer, this.envReadMemByte(SIDEndian.endian_32lo16(this.Register_ProgramCounter)));
        ++this.Register_ProgramCounter;
        this.Instr_Operand = SIDEndian.endian_16hi8(this.Instr_Operand, SIDEndian.endian_16hi8(this.Cycle_Pointer));
    }

    protected void FetchEffAddrDataByte() {
        this.Cycle_Data = this.envReadMemDataByte(this.Cycle_EffectiveAddress);
    }

    protected void PutEffAddrDataByte() {
        this.envWriteMemByte(this.Cycle_EffectiveAddress, this.Cycle_Data);
    }

    protected void PushLowPC() {
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.envWriteMemByte(addr, SIDEndian.endian_32lo8(this.Register_ProgramCounter));
        --this.Register_StackPointer;
    }

    protected void PushHighPC() {
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.envWriteMemByte(addr, SIDEndian.endian_32hi8(this.Register_ProgramCounter));
        --this.Register_StackPointer;
    }

    protected void PushSR(boolean b_flag) {
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.Register_Status = (short)(this.Register_Status & 0x3C);
        this.Register_Status = (short)(this.Register_Status | (this.getFlagN() ? 1 : 0) << 7);
        this.Register_Status = (short)(this.Register_Status | (this.getFlagV() ? 1 : 0) << 6);
        this.Register_Status = (short)(this.Register_Status | (this.getFlagZ() ? 1 : 0) << 1);
        this.Register_Status = (short)(this.Register_Status | (this.getFlagC() ? 1 : 0) << 0);
        this.envWriteMemByte(addr, (short)(this.Register_Status & (~((!b_flag ? 1 : 0) << 4) & 0xFF)));
        --this.Register_StackPointer;
    }

    protected void PushSR() {
        this.PushSR(true);
    }

    protected void PopLowPC() {
        ++this.Register_StackPointer;
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.Cycle_EffectiveAddress = SIDEndian.endian_16lo8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(addr));
    }

    protected void PopHighPC() {
        ++this.Register_StackPointer;
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(addr));
    }

    protected void PopSR() {
        boolean oldFlagI = this.getFlagI();
        ++this.Register_StackPointer;
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.Register_Status = this.envReadMemDataByte(addr);
        this.Register_Status = (short)(this.Register_Status | 0x30);
        this.setFlagN(this.Register_Status);
        this.setFlagV((short)(this.Register_Status & 0x40));
        this.setFlagZ((short)((this.Register_Status & 2) == 0 ? 1 : 0));
        this.setFlagC((short)(this.Register_Status & 1));
        boolean newFlagI = this.getFlagI();
        this.interrupts.irqLatch = oldFlagI ^ newFlagI;
        if (!newFlagI && this.interrupts.irqs != 0) {
            this.interrupts.irqRequest = true;
        }
    }

    protected void WasteCycle() {
    }

    protected void DebugCycle() {
        if (this.dodump) {
            this.DumpState();
        }
        this.clock();
    }

    protected void adc_instr() {
        this.Perform_ADC();
        this.clock();
    }

    protected void alr_instr() {
        this.Register_Accumulator = (short)(this.Register_Accumulator & this.Cycle_Data);
        this.setFlagC((short)(this.Register_Accumulator & 1));
        this.Register_Accumulator = (short)(this.Register_Accumulator >> 1);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void anc_instr() {
        this.Register_Accumulator = (short)(this.Register_Accumulator & this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
        this.setFlagC((short)(this.getFlagN() ? 1 : 0));
        this.clock();
    }

    protected void and_instr() {
        this.Register_Accumulator = (short)(this.Register_Accumulator & this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void ane_instr() {
        this.Register_Accumulator = (short)((this.Register_Accumulator | 0xEE) & this.Register_X & this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void arr_instr() {
        short data = (short)(this.Cycle_Data & this.Register_Accumulator);
        this.Register_Accumulator = (short)(data >> 1);
        if (this.getFlagC()) {
            this.Register_Accumulator = (short)(this.Register_Accumulator | 0x80);
        }
        if (this.getFlagD()) {
            this.setFlagN((short)0);
            if (this.getFlagC()) {
                this.setFlagN((short)128);
            }
            this.setFlagZ(this.Register_Accumulator);
            this.setFlagV((short)((data ^ this.Register_Accumulator) & 0x40));
            if ((data & 0xF) + (data & 1) > 5) {
                this.Register_Accumulator = (short)(this.Register_Accumulator & 0xF0 | this.Register_Accumulator + 6 & 0xF);
            }
            this.setFlagC((short)((data + (data & 0x10) & 0x1F0) > 80 ? 1 : 0));
            if (this.getFlagC()) {
                this.Register_Accumulator = (short)(this.Register_Accumulator + 96);
            }
        } else {
            this.setFlagsNZ(this.Register_Accumulator);
            this.setFlagC((short)(this.Register_Accumulator & 0x40));
            this.setFlagV((short)(this.Register_Accumulator & 0x40 ^ (this.Register_Accumulator & 0x20) << 1));
        }
        this.clock();
    }

    protected void asl_instr() {
        this.PutEffAddrDataByte();
        this.setFlagC((short)(this.Cycle_Data & 0x80));
        this.Cycle_Data = (short)(this.Cycle_Data << 1 & 0xFF);
        this.setFlagsNZ(this.Cycle_Data);
    }

    protected void asla_instr() {
        this.setFlagC((short)(this.Register_Accumulator & 0x80));
        this.Register_Accumulator = (short)(this.Register_Accumulator << 1 & 0xFF);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void aso_instr() {
        this.PutEffAddrDataByte();
        this.setFlagC((short)(this.Cycle_Data & 0x80));
        this.Cycle_Data = (short)(this.Cycle_Data << 1 & 0xFF);
        this.Register_Accumulator = (short)(this.Register_Accumulator | this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
    }

    protected void axa_instr() {
        this.Cycle_Data = (short)(this.Register_X & this.Register_Accumulator & SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) + 1);
        this.PutEffAddrDataByte();
    }

    protected void axs_instr() {
        this.Cycle_Data = (short)(this.Register_Accumulator & this.Register_X);
        this.PutEffAddrDataByte();
    }

    protected void bcc_instr() {
        this.branch_instr(!this.getFlagC());
    }

    protected void bcs_instr() {
        this.branch_instr(this.getFlagC());
    }

    protected void beq_instr() {
        this.branch_instr(this.getFlagZ());
    }

    protected void bit_instr() {
        this.setFlagZ((short)(this.Register_Accumulator & this.Cycle_Data));
        this.setFlagN(this.Cycle_Data);
        this.setFlagV((short)(this.Cycle_Data & 0x40));
        this.clock();
    }

    protected void bmi_instr() {
        this.branch_instr(this.getFlagN());
    }

    protected void bne_instr() {
        this.branch_instr(!this.getFlagZ());
    }

    protected void branch_instr(boolean condition) {
        if (condition) {
            short page = SIDEndian.endian_32hi8(this.Register_ProgramCounter);
            this.Register_ProgramCounter += (long)((byte)this.Cycle_Data);
            if (SIDEndian.endian_32hi8(this.Register_ProgramCounter) != page) {
                this.cycleCount = (byte)(this.cycleCount + 1);
            }
        } else {
            this.cycleCount = (byte)(this.cycleCount + 2);
            this.clock();
        }
    }

    protected void branch2_instr() {
        ++this.interrupts.irqClk;
        ++this.interrupts.nmiClk;
        this.cycleCount = (byte)(this.cycleCount + 1);
        this.clock();
    }

    protected void bpl_instr() {
        this.branch_instr(!this.getFlagN());
    }

    protected void brk_instr() {
        long cycles;
        this.PushSR();
        this.setFlagI((short)1);
        this.interrupts.irqRequest = false;
        if ((this.interrupts.pending & 2) != 0 && (cycles = this.eventContext.getTime(this.interrupts.nmiClk, this.m_extPhase)) > 2L) {
            this.interrupts.pending = (short)(this.interrupts.pending & 0xFD);
            this.instrCurrent = this.interruptTable[1];
            this.procCycle = this.instrCurrent.cycle;
        }
    }

    protected void bvc_instr() {
        this.branch_instr(!this.getFlagV());
    }

    protected void bvs_instr() {
        this.branch_instr(this.getFlagV());
    }

    protected void clc_instr() {
        this.setFlagC((short)0);
        this.clock();
    }

    protected void cld_instr() {
        this.setFlagD((short)0);
        this.clock();
    }

    protected void cli_instr() {
        boolean oldFlagI = this.getFlagI();
        this.setFlagI((short)0);
        this.interrupts.irqLatch = oldFlagI ^ this.getFlagI();
        if (this.interrupts.irqs != 0) {
            this.interrupts.irqRequest = true;
        }
        this.clock();
    }

    protected void clv_instr() {
        this.setFlagV((short)0);
        this.clock();
    }

    protected void cmp_instr() {
        int tmp = this.Register_Accumulator - this.Cycle_Data & 0xFFFF;
        this.setFlagsNZ((short)tmp);
        this.setFlagC((short)(tmp < 256 ? 1 : 0));
        this.clock();
    }

    protected void cpx_instr() {
        int tmp = this.Register_X - this.Cycle_Data & 0xFFFF;
        this.setFlagsNZ((short)tmp);
        this.setFlagC((short)(tmp < 256 ? 1 : 0));
        this.clock();
    }

    protected void cpy_instr() {
        int tmp = this.Register_Y - this.Cycle_Data & 0xFFFF;
        this.setFlagsNZ((short)tmp);
        this.setFlagC((short)(tmp < 256 ? 1 : 0));
        this.clock();
    }

    protected void dcm_instr() {
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data - 1 & 0xFF);
        int tmp = this.Register_Accumulator - this.Cycle_Data;
        this.setFlagsNZ((short)tmp);
        this.setFlagC((short)(tmp < 256 ? 1 : 0));
    }

    protected void dec_instr() {
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data - 1 & 0xFF);
        this.setFlagsNZ(this.Cycle_Data);
    }

    protected void dex_instr() {
        this.Register_X = (short)(this.Register_X - 1 & 0xFF);
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void dey_instr() {
        this.Register_Y = (short)(this.Register_Y - 1 & 0xFF);
        this.setFlagsNZ(this.Register_Y);
        this.clock();
    }

    protected void eor_instr() {
        this.Register_Accumulator = (short)(this.Register_Accumulator ^ this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void inc_instr() {
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data + 1 & 0xFF);
        this.setFlagsNZ(this.Cycle_Data);
    }

    protected void ins_instr() {
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data + 1);
        this.Perform_SBC();
    }

    protected void inx_instr() {
        this.Register_X = (short)(this.Register_X + 1 & 0xFF);
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void iny_instr() {
        this.Register_Y = (short)(this.Register_Y + 1 & 0xFF);
        this.setFlagsNZ(this.Register_Y);
        this.clock();
    }

    protected void jmp_instr() {
        this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
        this.clock();
    }

    protected void jsr_instr() {
        --this.Register_ProgramCounter;
        this.PushHighPC();
    }

    protected void las_instr() {
        this.Cycle_Data = (short)(this.Cycle_Data & SIDEndian.endian_16lo8(this.Register_StackPointer));
        this.setFlagsNZ(this.Cycle_Data);
        this.Register_Accumulator = this.Cycle_Data;
        this.Register_X = this.Cycle_Data;
        this.Register_StackPointer = this.Cycle_Data;
        this.clock();
    }

    protected void lax_instr() {
        this.Register_Accumulator = this.Register_X = this.Cycle_Data;
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void lda_instr() {
        this.Register_Accumulator = this.Cycle_Data;
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void ldx_instr() {
        this.Register_X = this.Cycle_Data;
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void ldy_instr() {
        this.Register_Y = this.Cycle_Data;
        this.setFlagsNZ(this.Register_Y);
        this.clock();
    }

    protected void lse_instr() {
        this.PutEffAddrDataByte();
        this.setFlagC((short)(this.Cycle_Data & 1));
        this.Cycle_Data = (short)(this.Cycle_Data >> 1);
        this.Register_Accumulator = (short)(this.Register_Accumulator ^ this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
    }

    protected void lsr_instr() {
        this.PutEffAddrDataByte();
        this.setFlagC((short)(this.Cycle_Data & 1));
        this.Cycle_Data = (short)(this.Cycle_Data >> 1);
        this.setFlagsNZ(this.Cycle_Data);
    }

    protected void lsra_instr() {
        this.setFlagC((short)(this.Register_Accumulator & 1));
        this.Register_Accumulator = (short)(this.Register_Accumulator >> 1);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void oal_instr() {
        this.Register_X = this.Register_Accumulator = (short)(this.Cycle_Data & (this.Register_Accumulator | 0xEE));
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void ora_instr() {
        this.Register_Accumulator = (short)(this.Register_Accumulator | this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void pha_instr() {
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.envWriteMemByte(addr, this.Register_Accumulator);
        --this.Register_StackPointer;
    }

    protected void pla_instr() {
        ++this.Register_StackPointer;
        int addr = this.Register_StackPointer;
        addr = SIDEndian.endian_16hi8(addr, (short)1);
        this.Register_Accumulator = this.envReadMemDataByte(addr);
        this.setFlagsNZ(this.Register_Accumulator);
    }

    protected void rla_instr() {
        short tmp = (short)(this.Cycle_Data & 0x80);
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data << 1 & 0xFF);
        if (this.getFlagC()) {
            this.Cycle_Data = (short)(this.Cycle_Data | 1);
        }
        this.setFlagC(tmp);
        this.Register_Accumulator = (short)(this.Register_Accumulator & this.Cycle_Data);
        this.setFlagsNZ(this.Register_Accumulator);
    }

    protected void rol_instr() {
        short tmp = (short)(this.Cycle_Data & 0x80);
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data << 1 & 0xFF);
        if (this.getFlagC()) {
            this.Cycle_Data = (short)(this.Cycle_Data | 1);
        }
        this.setFlagsNZ(this.Cycle_Data);
        this.setFlagC(tmp);
    }

    protected void rola_instr() {
        short tmp = (short)(this.Register_Accumulator & 0x80);
        this.Register_Accumulator = (short)(this.Register_Accumulator << 1 & 0xFF);
        if (this.getFlagC()) {
            this.Register_Accumulator = (short)(this.Register_Accumulator | 1);
        }
        this.setFlagsNZ(this.Register_Accumulator);
        this.setFlagC(tmp);
        this.clock();
    }

    protected void ror_instr() {
        short tmp = (short)(this.Cycle_Data & 1);
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data >> 1);
        if (this.getFlagC()) {
            this.Cycle_Data = (short)(this.Cycle_Data | 0x80);
        }
        this.setFlagsNZ(this.Cycle_Data);
        this.setFlagC(tmp);
    }

    protected void rora_instr() {
        short tmp = (short)(this.Register_Accumulator & 1);
        this.Register_Accumulator = (short)(this.Register_Accumulator >> 1);
        if (this.getFlagC()) {
            this.Register_Accumulator = (short)(this.Register_Accumulator | 0x80);
        }
        this.setFlagsNZ(this.Register_Accumulator);
        this.setFlagC(tmp);
        this.clock();
    }

    protected void rra_instr() {
        short tmp = (short)(this.Cycle_Data & 1);
        this.PutEffAddrDataByte();
        this.Cycle_Data = (short)(this.Cycle_Data >> 1);
        if (this.getFlagC()) {
            this.Cycle_Data = (short)(this.Cycle_Data | 0x80);
        }
        this.setFlagC(tmp);
        this.Perform_ADC();
    }

    protected void rti_instr() {
        if (MOS6510.isLoggable(Level.FINE) && this.dodump) {
            MOS6510.fine("****************************************************\n\n");
        }
        this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
        this.interrupts.irqLatch = false;
        this.clock();
    }

    protected void rts_instr() {
        this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
        ++this.Register_ProgramCounter;
    }

    protected void sbx_instr() {
        long tmp = (this.Register_X & this.Register_Accumulator) - this.Cycle_Data;
        this.Register_X = (short)(tmp & 0xFFL);
        this.setFlagsNZ(this.Register_X);
        this.setFlagC((short)(tmp < 256L ? 1 : 0));
        this.clock();
    }

    protected void say_instr() {
        this.Cycle_Data = (short)(this.Register_Y & SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) + 1);
        this.PutEffAddrDataByte();
    }

    protected void sbc_instr() {
        this.Perform_SBC();
        this.clock();
    }

    protected void sec_instr() {
        this.setFlagC((short)1);
        this.clock();
    }

    protected void sed_instr() {
        this.setFlagD((short)1);
        this.clock();
    }

    protected void sei_instr() {
        boolean oldFlagI = this.getFlagI();
        this.setFlagI((short)1);
        this.interrupts.irqLatch = oldFlagI ^ this.getFlagI();
        this.interrupts.irqRequest = false;
        this.clock();
    }

    protected void shs_instr() {
        this.Register_StackPointer = SIDEndian.endian_16lo8(this.Register_StackPointer, (short)(this.Register_Accumulator & this.Register_X));
        this.Cycle_Data = (short)(SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) + 1 & this.Register_StackPointer);
        this.PutEffAddrDataByte();
    }

    protected void sta_instr() {
        this.Cycle_Data = this.Register_Accumulator;
        this.PutEffAddrDataByte();
    }

    protected void stx_instr() {
        this.Cycle_Data = this.Register_X;
        this.PutEffAddrDataByte();
    }

    protected void sty_instr() {
        this.Cycle_Data = this.Register_Y;
        this.PutEffAddrDataByte();
    }

    protected void tas_instr() {
        this.Register_StackPointer = SIDEndian.endian_16lo8(this.Register_StackPointer, (short)(this.Register_Accumulator & this.Register_X));
        int tmp = this.Register_StackPointer & this.Cycle_EffectiveAddress + 1;
        this.Cycle_Data = SIDEndian.endian_16lo8(tmp);
    }

    protected void tax_instr() {
        this.Register_X = this.Register_Accumulator;
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void tay_instr() {
        this.Register_Y = this.Register_Accumulator;
        this.setFlagsNZ(this.Register_Y);
        this.clock();
    }

    protected void tsx_instr() {
        this.Register_X = SIDEndian.endian_16lo8(this.Register_StackPointer);
        this.setFlagsNZ(this.Register_X);
        this.clock();
    }

    protected void txa_instr() {
        this.Register_Accumulator = this.Register_X;
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void txs_instr() {
        this.Register_StackPointer = SIDEndian.endian_16lo8(this.Register_StackPointer, this.Register_X);
        this.clock();
    }

    protected void tya_instr() {
        this.Register_Accumulator = this.Register_Y;
        this.setFlagsNZ(this.Register_Accumulator);
        this.clock();
    }

    protected void xas_instr() {
        this.Cycle_Data = (short)(this.Register_X & SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress) + 1);
        this.PutEffAddrDataByte();
    }

    protected void illegal_instr() {
        MOS6510.log(Level.SEVERE, "\n\n ILLEGAL INSTRUCTION, resetting emulation. **************\n");
        this.DumpState();
        MOS6510.log(Level.SEVERE, "*********************************************************\n");
        this.envReset();
    }

    protected void Perform_ADC() {
        int C = this.getFlagC() ? 1 : 0;
        short A = this.Register_Accumulator;
        short s = this.Cycle_Data;
        int regAC2 = A + s + C;
        if (this.getFlagD()) {
            int lo = (A & 0xF) + (s & 0xF) + C;
            int hi = (A & 0xF0) + (s & 0xF0);
            if (lo > 9) {
                lo += 6;
            }
            if (lo > 15) {
                hi += 16;
            }
            this.setFlagZ((short)regAC2);
            this.setFlagN((short)hi);
            this.setFlagV(((hi ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) == 0 ? (short)1 : 0);
            if (hi > 144) {
                hi += 96;
            }
            this.setFlagC(hi > 255 ? (short)1 : 0);
            this.Register_Accumulator = (short)(hi | lo & 0xF);
        } else {
            this.setFlagC(regAC2 > 255 ? (short)1 : 0);
            this.setFlagV(((regAC2 ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) == 0 ? (short)1 : 0);
            this.Register_Accumulator = (short)(regAC2 & 0xFF);
            this.setFlagsNZ(this.Register_Accumulator);
        }
    }

    protected void Perform_SBC() {
        int C = this.getFlagC() ? 0 : 1;
        short A = this.Register_Accumulator;
        short s = this.Cycle_Data;
        int regAC2 = A - s - C & 0xFFFF;
        this.setFlagC(regAC2 < 256 ? (short)1 : 0);
        this.setFlagV(((regAC2 ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) != 0 ? (short)1 : 0);
        this.setFlagsNZ((short)regAC2);
        if (this.getFlagD()) {
            int lo = (A & 0xF) - (s & 0xF) - C;
            int hi = (A & 0xF0) - (s & 0xF0);
            if ((lo & 0x10) != 0) {
                lo -= 6;
                hi -= 16;
            }
            if ((hi & 0x100) != 0) {
                hi -= 96;
            }
            this.Register_Accumulator = (short)(hi | lo & 0xF);
        } else {
            this.Register_Accumulator = (short)(regAC2 & 0xFF);
        }
    }

    protected void IRQRequest_sidplay_irq() {
        this.IRQRequest();
    }

    protected void PushHighPC_sidplay_brk() {
        this.PushHighPC();
    }

    protected void PopSR_sidplay_rti() {
        this.PopSR();
    }

    public MOS6510(IEventContext context) {
        int pass;
        ProcessorOperations instr;
        int i;
        this.eventContext = context;
        this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI2;
        this.m_extPhase = Event.event_phase_t.EVENT_CLOCK_PHI1;
        boolean legalMode = true;
        boolean legalInstr = true;
        for (i = 0; i < 256; ++i) {
            if (MOS6510.isLoggable(Level.FINE)) {
                MOS6510.fine(String.format("Building Command %d[%02x]..", i, i));
            }
            instr = this.instrTable[i] = new ProcessorOperations();
            this.procCycle = null;
            for (pass = 0; pass < 2; ++pass) {
                int c;
                int WRITE = 0;
                int READ = 1;
                int access = WRITE;
                this.cycleCount = (byte)-1;
                legalMode = true;
                legalInstr = true;
                switch (i) {
                    case 8: 
                    case 10: 
                    case 24: 
                    case 26: 
                    case 40: 
                    case 42: 
                    case 56: 
                    case 58: 
                    case 64: 
                    case 72: 
                    case 74: 
                    case 88: 
                    case 90: 
                    case 96: 
                    case 104: 
                    case 106: 
                    case 120: 
                    case 122: 
                    case 136: 
                    case 138: 
                    case 152: 
                    case 154: 
                    case 168: 
                    case 170: 
                    case 184: 
                    case 186: 
                    case 200: 
                    case 202: 
                    case 216: 
                    case 218: 
                    case 232: 
                    case 234: 
                    case 248: 
                    case 250: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 0: 
                    case 9: 
                    case 11: 
                    case 16: 
                    case 41: 
                    case 43: 
                    case 48: 
                    case 73: 
                    case 75: 
                    case 80: 
                    case 105: 
                    case 107: 
                    case 112: 
                    case 128: 
                    case 130: 
                    case 137: 
                    case 139: 
                    case 144: 
                    case 160: 
                    case 162: 
                    case 169: 
                    case 171: 
                    case 176: 
                    case 192: 
                    case 194: 
                    case 201: 
                    case 203: 
                    case 208: 
                    case 224: 
                    case 226: 
                    case 233: 
                    case 235: 
                    case 240: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchDataByte();
                            }
                        };
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: {
                        ++access;
                    }
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 180: 
                    case 181: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: {
                        ++access;
                    }
                    case 148: 
                    case 149: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddrX();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 182: 
                    case 183: {
                        access = READ;
                    }
                    case 150: 
                    case 151: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddrY();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 236: 
                    case 237: 
                    case 238: 
                    case 239: {
                        ++access;
                    }
                    case 32: 
                    case 76: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighAddr();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 28: 
                    case 29: 
                    case 60: 
                    case 61: 
                    case 92: 
                    case 93: 
                    case 124: 
                    case 125: 
                    case 188: 
                    case 189: 
                    case 220: 
                    case 221: 
                    case 252: 
                    case 253: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighAddrX();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 62: 
                    case 63: 
                    case 94: 
                    case 95: 
                    case 126: 
                    case 127: 
                    case 222: 
                    case 223: 
                    case 254: 
                    case 255: {
                        access = READ;
                    }
                    case 156: 
                    case 157: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighAddrX2();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 25: 
                    case 57: 
                    case 89: 
                    case 121: 
                    case 185: 
                    case 187: 
                    case 190: 
                    case 191: 
                    case 217: 
                    case 249: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighAddrY();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 27: 
                    case 59: 
                    case 91: 
                    case 123: 
                    case 219: 
                    case 251: {
                        access = READ;
                    }
                    case 153: 
                    case 155: 
                    case 158: 
                    case 159: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighAddrY2();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 108: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowPointer();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighPointer();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowEffAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchHighEffAddr();
                            }
                        };
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 33: 
                    case 35: 
                    case 65: 
                    case 67: 
                    case 97: 
                    case 99: 
                    case 161: 
                    case 163: 
                    case 193: 
                    case 195: 
                    case 225: 
                    case 227: {
                        ++access;
                    }
                    case 129: 
                    case 131: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowPointer();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowPointerX();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowEffAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighEffAddr();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 17: 
                    case 49: 
                    case 81: 
                    case 113: 
                    case 177: 
                    case 179: 
                    case 209: 
                    case 241: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowPointer();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowEffAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighEffAddrY();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 19: 
                    case 51: 
                    case 83: 
                    case 115: 
                    case 211: 
                    case 243: {
                        access = READ;
                    }
                    case 145: 
                    case 147: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowPointer();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchLowEffAddr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.FetchHighEffAddrY2();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        if (access != READ) break;
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    default: {
                        legalMode = false;
                    }
                }
                if (pass != 0) {
                    c = -1;
                    while (c < this.cycleCount) {
                        this.procCycle[++c].nosteal = false;
                    }
                }
                if (MOS6510.isLoggable(Level.FINE) && legalMode) {
                    this.cycleCount = (byte)(this.cycleCount + 1);
                    if (pass != 0) {
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.DebugCycle();
                            }
                        };
                    }
                }
                switch (i) {
                    case 97: 
                    case 101: 
                    case 105: 
                    case 109: 
                    case 113: 
                    case 117: 
                    case 121: 
                    case 125: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.adc_instr();
                            }
                        };
                        break;
                    }
                    case 11: 
                    case 43: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.anc_instr();
                            }
                        };
                        break;
                    }
                    case 33: 
                    case 37: 
                    case 41: 
                    case 45: 
                    case 49: 
                    case 53: 
                    case 57: 
                    case 61: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.and_instr();
                            }
                        };
                        break;
                    }
                    case 139: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.ane_instr();
                            }
                        };
                        break;
                    }
                    case 107: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.arr_instr();
                            }
                        };
                        break;
                    }
                    case 10: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.asla_instr();
                            }
                        };
                        break;
                    }
                    case 6: 
                    case 14: 
                    case 22: 
                    case 30: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.asl_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 75: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.alr_instr();
                            }
                        };
                        break;
                    }
                    case 144: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bcc_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 176: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bcs_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 240: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.beq_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 36: 
                    case 44: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.bit_instr();
                            }
                        };
                        break;
                    }
                    case 48: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bmi_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 208: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bne_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 16: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bpl_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 0: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushHighPC_sidplay_brk();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushLowPC();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.brk_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQ1Request();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQ2Request();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchOpcode();
                            }
                        };
                        break;
                    }
                    case 80: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bvc_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 112: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.bvs_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.branch2_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.WasteCycle();
                            }
                        };
                        break;
                    }
                    case 24: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.clc_instr();
                            }
                        };
                        break;
                    }
                    case 216: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.cld_instr();
                            }
                        };
                        break;
                    }
                    case 88: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.cli_instr();
                            }
                        };
                        break;
                    }
                    case 184: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.clv_instr();
                            }
                        };
                        break;
                    }
                    case 193: 
                    case 197: 
                    case 201: 
                    case 205: 
                    case 209: 
                    case 213: 
                    case 217: 
                    case 221: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.cmp_instr();
                            }
                        };
                        break;
                    }
                    case 224: 
                    case 228: 
                    case 236: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.cpx_instr();
                            }
                        };
                        break;
                    }
                    case 192: 
                    case 196: 
                    case 204: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.cpy_instr();
                            }
                        };
                        break;
                    }
                    case 195: 
                    case 199: 
                    case 207: 
                    case 211: 
                    case 215: 
                    case 219: 
                    case 223: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.dcm_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 198: 
                    case 206: 
                    case 214: 
                    case 222: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.dec_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 202: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.dex_instr();
                            }
                        };
                        break;
                    }
                    case 136: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.dey_instr();
                            }
                        };
                        break;
                    }
                    case 65: 
                    case 69: 
                    case 73: 
                    case 77: 
                    case 81: 
                    case 85: 
                    case 89: 
                    case 93: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.eor_instr();
                            }
                        };
                        break;
                    }
                    case 230: 
                    case 238: 
                    case 246: 
                    case 254: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.inc_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 232: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.inx_instr();
                            }
                        };
                        break;
                    }
                    case 200: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.iny_instr();
                            }
                        };
                        break;
                    }
                    case 227: 
                    case 231: 
                    case 239: 
                    case 243: 
                    case 247: 
                    case 251: 
                    case 255: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.ins_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 32: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.jsr_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushLowPC();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                    }
                    case 76: 
                    case 108: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.jmp_instr();
                            }
                        };
                        break;
                    }
                    case 187: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.las_instr();
                            }
                        };
                        break;
                    }
                    case 163: 
                    case 167: 
                    case 175: 
                    case 179: 
                    case 183: 
                    case 191: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.lax_instr();
                            }
                        };
                        break;
                    }
                    case 161: 
                    case 165: 
                    case 169: 
                    case 173: 
                    case 177: 
                    case 181: 
                    case 185: 
                    case 189: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.lda_instr();
                            }
                        };
                        break;
                    }
                    case 162: 
                    case 166: 
                    case 174: 
                    case 182: 
                    case 190: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.ldx_instr();
                            }
                        };
                        break;
                    }
                    case 160: 
                    case 164: 
                    case 172: 
                    case 180: 
                    case 188: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.ldy_instr();
                            }
                        };
                        break;
                    }
                    case 74: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.lsra_instr();
                            }
                        };
                        break;
                    }
                    case 70: 
                    case 78: 
                    case 86: 
                    case 94: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.lsr_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 4: 
                    case 12: 
                    case 20: 
                    case 26: 
                    case 28: 
                    case 52: 
                    case 58: 
                    case 60: 
                    case 68: 
                    case 84: 
                    case 90: 
                    case 92: 
                    case 100: 
                    case 116: 
                    case 122: 
                    case 124: 
                    case 128: 
                    case 130: 
                    case 137: 
                    case 194: 
                    case 212: 
                    case 218: 
                    case 220: 
                    case 226: 
                    case 234: 
                    case 244: 
                    case 250: 
                    case 252: {
                        break;
                    }
                    case 171: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.oal_instr();
                            }
                        };
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 9: 
                    case 13: 
                    case 17: 
                    case 21: 
                    case 25: 
                    case 29: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.ora_instr();
                            }
                        };
                        break;
                    }
                    case 72: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.pha_instr();
                            }
                        };
                        break;
                    }
                    case 8: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PushSR();
                            }
                        };
                        break;
                    }
                    case 104: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.pla_instr();
                                }
                            };
                        }
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].nosteal = false;
                        break;
                    }
                    case 40: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopSR();
                                }
                            };
                        }
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].nosteal = false;
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 51: 
                    case 55: 
                    case 59: 
                    case 63: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.rla_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 42: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.rola_instr();
                            }
                        };
                        break;
                    }
                    case 38: 
                    case 46: 
                    case 54: 
                    case 62: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.rol_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 106: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.rora_instr();
                            }
                        };
                        break;
                    }
                    case 102: 
                    case 110: 
                    case 118: 
                    case 126: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.ror_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 99: 
                    case 103: 
                    case 111: 
                    case 115: 
                    case 119: 
                    case 123: 
                    case 127: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.rra_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 64: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopSR_sidplay_rti();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopLowPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopHighPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.rti_instr();
                            }
                        };
                        break;
                    }
                    case 96: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopLowPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PopHighPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = false;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.rts_instr();
                            }
                        };
                        break;
                    }
                    case 131: 
                    case 135: 
                    case 143: 
                    case 151: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.axs_instr();
                            }
                        };
                        break;
                    }
                    case 225: 
                    case 229: 
                    case 233: 
                    case 235: 
                    case 237: 
                    case 241: 
                    case 245: 
                    case 249: 
                    case 253: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sbc_instr();
                            }
                        };
                        break;
                    }
                    case 203: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sbx_instr();
                            }
                        };
                        break;
                    }
                    case 56: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sec_instr();
                            }
                        };
                        break;
                    }
                    case 248: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sed_instr();
                            }
                        };
                        break;
                    }
                    case 120: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sei_instr();
                            }
                        };
                        break;
                    }
                    case 147: 
                    case 159: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.axa_instr();
                            }
                        };
                        break;
                    }
                    case 155: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.shs_instr();
                            }
                        };
                        break;
                    }
                    case 158: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.xas_instr();
                            }
                        };
                        break;
                    }
                    case 156: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.say_instr();
                            }
                        };
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 15: 
                    case 19: 
                    case 23: 
                    case 27: 
                    case 31: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.aso_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 67: 
                    case 71: 
                    case 79: 
                    case 83: 
                    case 87: 
                    case 91: 
                    case 95: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.lse_instr();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.PutEffAddrDataByte();
                            }
                        };
                        break;
                    }
                    case 129: 
                    case 133: 
                    case 141: 
                    case 145: 
                    case 149: 
                    case 153: 
                    case 157: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sta_instr();
                            }
                        };
                        break;
                    }
                    case 134: 
                    case 142: 
                    case 150: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.stx_instr();
                            }
                        };
                        break;
                    }
                    case 132: 
                    case 140: 
                    case 148: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.sty_instr();
                            }
                        };
                        break;
                    }
                    case 170: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.tax_instr();
                            }
                        };
                        break;
                    }
                    case 168: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.tay_instr();
                            }
                        };
                        break;
                    }
                    case 186: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.tsx_instr();
                            }
                        };
                        break;
                    }
                    case 138: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.txa_instr();
                            }
                        };
                        break;
                    }
                    case 154: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.txs_instr();
                            }
                        };
                        break;
                    }
                    case 152: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.tya_instr();
                            }
                        };
                        break;
                    }
                    default: {
                        legalInstr = false;
                    }
                }
                if (!legalMode && !legalInstr) {
                    this.cycleCount = (byte)(this.cycleCount + 1);
                    if (pass != 0) {
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.illegal_instr();
                            }
                        };
                    }
                } else if (!legalMode || !legalInstr) {
                    System.err.printf("\nInstruction 0x%x: Not built correctly.\n\n", i);
                    throw new RuntimeException("MOS6510 ERROR: no legal mode nor legal instruction");
                }
                this.cycleCount = (byte)(this.cycleCount + 1);
                if (pass != 0) {
                    this.procCycle[this.cycleCount].func = new IFunc(){

                        @Override
                        public void invoke() {
                            MOS6510.this.NextInstr();
                        }
                    };
                }
                this.cycleCount = (byte)(this.cycleCount + 1);
                if (pass == 0 && this.cycleCount != 0) {
                    instr.cycle = new ProcessorCycle[this.cycleCount];
                    this.procCycle = instr.cycle;
                    c = this.cycleCount;
                    while (c > 0) {
                        this.procCycle[--c] = new ProcessorCycle();
                        this.procCycle[c].nosteal = true;
                    }
                }
                if (!MOS6510.isLoggable(Level.FINE)) continue;
                MOS6510.fine(".");
            }
            if (!MOS6510.isLoggable(Level.FINE)) continue;
            MOS6510.fine(String.format("Done [%d Cycles]\n", this.cycleCount));
        }
        for (i = 0; i < 3; ++i) {
            if (MOS6510.isLoggable(Level.FINE)) {
                MOS6510.fine(String.format("Building Interrupt %d[%02x]..", i, i));
            }
            instr = this.interruptTable[i] = new ProcessorOperations();
            instr.cycle = null;
            for (pass = 0; pass < 2; ++pass) {
                this.cycleCount = (byte)-1;
                if (pass != 0) {
                    this.procCycle = instr.cycle;
                }
                switch (i) {
                    case 0: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.RSTRequest();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchOpcode();
                            }
                        };
                        break;
                    }
                    case 1: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushHighPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushLowPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQRequest();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.NMIRequest();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.NMI1Request();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchOpcode();
                            }
                        };
                        break;
                    }
                    case 2: {
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.WasteCycle();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushHighPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.PushLowPC();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQRequest_sidplay_irq();
                                }
                            };
                        }
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].nosteal = true;
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQ1Request();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass != 0) {
                            this.procCycle[this.cycleCount].func = new IFunc(){

                                @Override
                                public void invoke() {
                                    MOS6510.this.IRQ2Request();
                                }
                            };
                        }
                        this.cycleCount = (byte)(this.cycleCount + 1);
                        if (pass == 0) break;
                        this.procCycle[this.cycleCount].func = new IFunc(){

                            @Override
                            public void invoke() {
                                MOS6510.this.FetchOpcode();
                            }
                        };
                    }
                }
                this.cycleCount = (byte)(this.cycleCount + 1);
                if (pass == 0 && this.cycleCount != 0) {
                    instr.cycle = new ProcessorCycle[this.cycleCount];
                    this.procCycle = instr.cycle;
                    for (int c = 0; c < this.cycleCount; ++c) {
                        this.procCycle[c] = new ProcessorCycle();
                        this.procCycle[c].nosteal = false;
                    }
                }
                if (!MOS6510.isLoggable(Level.FINE)) continue;
                MOS6510.fine(".");
            }
            if (!MOS6510.isLoggable(Level.FINE)) continue;
            MOS6510.fine(String.format("Done [%d Cycles]\n", this.cycleCount));
        }
        this.Register_Accumulator = 0;
        this.Register_X = 0;
        this.Register_Y = 0;
        this.Cycle_EffectiveAddress = 0;
        this.Cycle_Data = 0;
        this.fetchCycle.func = new IFunc(){

            @Override
            public void invoke() {
                MOS6510.this.FetchOpcode();
            }
        };
        this.dodump = false;
        this.Initialise();
    }

    public void reset() {
        this.interrupts.pending = 0;
        this.interrupts.irqs = 0;
        this.Initialise();
        this.Cycle_EffectiveAddress = SIDEndian.endian_16lo8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65532));
        this.Cycle_EffectiveAddress = SIDEndian.endian_16hi8(this.Cycle_EffectiveAddress, this.envReadMemDataByte(65533));
        this.Register_ProgramCounter = this.Cycle_EffectiveAddress;
    }

    public void credits(StringBuffer sbuffer) {
        sbuffer.append(String.format("Module     : MOS6510 Cycle Exact Emulation\n", new Object[0]));
        sbuffer.append(String.format("Written By : %s\n", MOS6510_AUTHOR));
        sbuffer.append(String.format("Version    : %s\n", MOS6510_VERSION));
        sbuffer.append(String.format("Released   : %s\n", MOS6510_DATE));
        sbuffer.append(String.format("Email      : %s\n", MOS6510_EMAIL));
    }

    public void DumpState() {
        int address;
        StringBuffer m_fdbg = new StringBuffer();
        m_fdbg.append(String.format("%5d :", this.line++));
        m_fdbg.append(String.format(" PC  I  A  X  Y  SP  DR PR NV-BDIZC  Instruction (%d)\n", this.m_dbgClk));
        m_fdbg.append(String.format("XXXXXXX%04x ", this.instrStartPC));
        m_fdbg.append(String.format("%d ", this.interrupts.irqs));
        m_fdbg.append(String.format("%02x ", this.Register_Accumulator));
        m_fdbg.append(String.format("%02x ", this.Register_X));
        m_fdbg.append(String.format("%02x ", this.Register_Y));
        m_fdbg.append(String.format("01%02x ", SIDEndian.endian_16lo8(this.Register_StackPointer)));
        m_fdbg.append(String.format("%02x ", this.envReadMemDataByte(0)));
        m_fdbg.append(String.format("%02x ", this.envReadMemDataByte(1)));
        if (this.getFlagN()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if (this.getFlagV()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if ((this.Register_Status & 0x20) != 0) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if ((this.Register_Status & 0x10) != 0) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if (this.getFlagD()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if (this.getFlagI()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if (this.getFlagZ()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        if (this.getFlagC()) {
            m_fdbg.append("1");
        } else {
            m_fdbg.append("0");
        }
        short opcode = this.instrOpcode;
        int operand = this.Instr_Operand;
        short data = this.Cycle_Data;
        switch (opcode) {
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                address = (int)(this.Register_ProgramCounter + (long)((byte)operand));
                break;
            }
            default: {
                address = this.Cycle_EffectiveAddress;
            }
        }
        m_fdbg.append(String.format("  %02x ", opcode));
        switch (opcode) {
            case 10: 
            case 42: 
            case 74: 
            case 106: {
                m_fdbg.append("      ");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                m_fdbg.append(String.format("%02x    ", (short)operand));
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 148: 
            case 149: 
            case 180: 
            case 181: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                m_fdbg.append(String.format("%02x    ", (short)operand));
                break;
            }
            case 150: 
            case 151: 
            case 182: 
            case 183: {
                m_fdbg.append(String.format("%02x    ", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 109: 
            case 110: 
            case 111: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                m_fdbg.append(String.format("%02x %02x ", SIDEndian.endian_16lo8(operand), SIDEndian.endian_16hi8(operand)));
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 156: 
            case 157: 
            case 188: 
            case 189: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                m_fdbg.append(String.format("%02x %02x ", SIDEndian.endian_16lo8(operand), SIDEndian.endian_16hi8(operand)));
                break;
            }
            case 25: 
            case 27: 
            case 57: 
            case 59: 
            case 89: 
            case 91: 
            case 121: 
            case 123: 
            case 153: 
            case 155: 
            case 158: 
            case 159: 
            case 185: 
            case 187: 
            case 190: 
            case 191: 
            case 217: 
            case 219: 
            case 249: 
            case 251: {
                m_fdbg.append(String.format("%02x %02x ", SIDEndian.endian_16lo8(operand), SIDEndian.endian_16hi8(operand)));
                break;
            }
            case 9: 
            case 11: 
            case 41: 
            case 43: 
            case 73: 
            case 75: 
            case 105: 
            case 107: 
            case 128: 
            case 130: 
            case 137: 
            case 139: 
            case 160: 
            case 162: 
            case 169: 
            case 171: 
            case 192: 
            case 194: 
            case 201: 
            case 203: 
            case 224: 
            case 226: 
            case 233: 
            case 235: {
                m_fdbg.append(String.format("%02x    ", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                m_fdbg.append(String.format("%02x    ", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 108: {
                m_fdbg.append(String.format("%02x %02x ", SIDEndian.endian_16lo8(operand), SIDEndian.endian_16hi8(operand)));
                break;
            }
            case 1: 
            case 3: 
            case 33: 
            case 35: 
            case 65: 
            case 67: 
            case 97: 
            case 99: 
            case 129: 
            case 131: 
            case 161: 
            case 163: 
            case 193: 
            case 195: 
            case 225: 
            case 227: {
                m_fdbg.append(String.format("%02x    ", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 17: 
            case 19: 
            case 49: 
            case 51: 
            case 81: 
            case 83: 
            case 113: 
            case 115: 
            case 145: 
            case 147: 
            case 177: 
            case 179: 
            case 209: 
            case 211: 
            case 241: 
            case 243: {
                m_fdbg.append(String.format("%02x    ", SIDEndian.endian_16lo8(operand)));
                break;
            }
            default: {
                m_fdbg.append("      ");
            }
        }
        switch (opcode) {
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 125: {
                m_fdbg.append(" ADC");
                break;
            }
            case 11: 
            case 43: {
                m_fdbg.append("*ANC");
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 49: 
            case 53: 
            case 57: 
            case 61: {
                m_fdbg.append(" AND");
                break;
            }
            case 139: {
                m_fdbg.append("*ANE");
                break;
            }
            case 107: {
                m_fdbg.append("*ARR");
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 22: 
            case 30: {
                m_fdbg.append(" ASL");
                break;
            }
            case 75: {
                m_fdbg.append("*ASR");
                break;
            }
            case 144: {
                m_fdbg.append(" BCC");
                break;
            }
            case 176: {
                m_fdbg.append(" BCS");
                break;
            }
            case 240: {
                m_fdbg.append(" BEQ");
                break;
            }
            case 36: 
            case 44: {
                m_fdbg.append(" BIT");
                break;
            }
            case 48: {
                m_fdbg.append(" BMI");
                break;
            }
            case 208: {
                m_fdbg.append(" BNE");
                break;
            }
            case 16: {
                m_fdbg.append(" BPL");
                break;
            }
            case 0: {
                m_fdbg.append(" BRK");
                break;
            }
            case 80: {
                m_fdbg.append(" BVC");
                break;
            }
            case 112: {
                m_fdbg.append(" BVS");
                break;
            }
            case 24: {
                m_fdbg.append(" CLC");
                break;
            }
            case 216: {
                m_fdbg.append(" CLD");
                break;
            }
            case 88: {
                m_fdbg.append(" CLI");
                break;
            }
            case 184: {
                m_fdbg.append(" CLV");
                break;
            }
            case 193: 
            case 197: 
            case 201: 
            case 205: 
            case 209: 
            case 213: 
            case 217: 
            case 221: {
                m_fdbg.append(" CMP");
                break;
            }
            case 224: 
            case 228: 
            case 236: {
                m_fdbg.append(" CPX");
                break;
            }
            case 192: 
            case 196: 
            case 204: {
                m_fdbg.append(" CPY");
                break;
            }
            case 195: 
            case 199: 
            case 207: 
            case 211: 
            case 215: 
            case 219: 
            case 223: {
                m_fdbg.append("*DCP");
                break;
            }
            case 198: 
            case 206: 
            case 214: 
            case 222: {
                m_fdbg.append(" DEC");
                break;
            }
            case 202: {
                m_fdbg.append(" DEX");
                break;
            }
            case 136: {
                m_fdbg.append(" DEY");
                break;
            }
            case 65: 
            case 69: 
            case 73: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 93: {
                m_fdbg.append(" EOR");
                break;
            }
            case 230: 
            case 238: 
            case 246: 
            case 254: {
                m_fdbg.append(" INC");
                break;
            }
            case 232: {
                m_fdbg.append(" INX");
                break;
            }
            case 200: {
                m_fdbg.append(" INY");
                break;
            }
            case 227: 
            case 231: 
            case 239: 
            case 243: 
            case 247: 
            case 251: 
            case 255: {
                m_fdbg.append("*ISB");
                break;
            }
            case 76: 
            case 108: {
                m_fdbg.append(" JMP");
                break;
            }
            case 32: {
                m_fdbg.append(" JSR");
                break;
            }
            case 187: {
                m_fdbg.append("*LAS");
                break;
            }
            case 163: 
            case 167: 
            case 175: 
            case 179: 
            case 183: 
            case 191: {
                m_fdbg.append("*LAX");
                break;
            }
            case 161: 
            case 165: 
            case 169: 
            case 173: 
            case 177: 
            case 181: 
            case 185: 
            case 189: {
                m_fdbg.append(" LDA");
                break;
            }
            case 162: 
            case 166: 
            case 174: 
            case 182: 
            case 190: {
                m_fdbg.append(" LDX");
                break;
            }
            case 160: 
            case 164: 
            case 172: 
            case 180: 
            case 188: {
                m_fdbg.append(" LDY");
                break;
            }
            case 70: 
            case 74: 
            case 78: 
            case 86: 
            case 94: {
                m_fdbg.append(" LSR");
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 26: 
            case 28: 
            case 52: 
            case 58: 
            case 60: 
            case 68: 
            case 84: 
            case 90: 
            case 92: 
            case 100: 
            case 116: 
            case 122: 
            case 124: 
            case 128: 
            case 130: 
            case 137: 
            case 194: 
            case 212: 
            case 218: 
            case 220: 
            case 226: 
            case 234: 
            case 244: 
            case 250: 
            case 252: {
                if (opcode != 234) {
                    m_fdbg.append("*");
                } else {
                    m_fdbg.append(" ");
                }
                m_fdbg.append("NOP");
                break;
            }
            case 171: {
                m_fdbg.append("*LXA");
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 29: {
                m_fdbg.append(" ORA");
                break;
            }
            case 72: {
                m_fdbg.append(" PHA");
                break;
            }
            case 8: {
                m_fdbg.append(" PHP");
                break;
            }
            case 104: {
                m_fdbg.append(" PLA");
                break;
            }
            case 40: {
                m_fdbg.append(" PLP");
                break;
            }
            case 35: 
            case 39: 
            case 47: 
            case 51: 
            case 55: 
            case 59: 
            case 63: {
                m_fdbg.append("*RLA");
                break;
            }
            case 38: 
            case 42: 
            case 46: 
            case 54: 
            case 62: {
                m_fdbg.append(" ROL");
                break;
            }
            case 102: 
            case 106: 
            case 110: 
            case 118: 
            case 126: {
                m_fdbg.append(" ROR");
                break;
            }
            case 99: 
            case 103: 
            case 111: 
            case 115: 
            case 119: 
            case 123: 
            case 127: {
                m_fdbg.append("*RRA");
                break;
            }
            case 64: {
                m_fdbg.append(" RTI");
                break;
            }
            case 96: {
                m_fdbg.append(" RTS");
                break;
            }
            case 131: 
            case 135: 
            case 143: 
            case 151: {
                m_fdbg.append("*SAX");
                break;
            }
            case 233: 
            case 235: {
                if (opcode != 233) {
                    m_fdbg.append("*");
                } else {
                    m_fdbg.append(" ");
                }
                m_fdbg.append("SBC");
                break;
            }
            case 225: 
            case 229: 
            case 237: 
            case 241: 
            case 245: 
            case 249: 
            case 253: {
                m_fdbg.append(" SBC");
                break;
            }
            case 203: {
                m_fdbg.append("*SBX");
                break;
            }
            case 56: {
                m_fdbg.append(" SEC");
                break;
            }
            case 248: {
                m_fdbg.append(" SED");
                break;
            }
            case 120: {
                m_fdbg.append(" SEI");
                break;
            }
            case 147: 
            case 159: {
                m_fdbg.append("*SHA");
                break;
            }
            case 155: {
                m_fdbg.append("*SHS");
                break;
            }
            case 158: {
                m_fdbg.append("*SHX");
                break;
            }
            case 156: {
                m_fdbg.append("*SHY");
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 31: {
                m_fdbg.append("*SLO");
                break;
            }
            case 67: 
            case 71: 
            case 79: 
            case 83: 
            case 87: 
            case 91: 
            case 95: {
                m_fdbg.append("*SRE");
                break;
            }
            case 129: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 157: {
                m_fdbg.append(" STA");
                break;
            }
            case 134: 
            case 142: 
            case 150: {
                m_fdbg.append(" STX");
                break;
            }
            case 132: 
            case 140: 
            case 148: {
                m_fdbg.append(" STY");
                break;
            }
            case 170: {
                m_fdbg.append(" TAX");
                break;
            }
            case 168: {
                m_fdbg.append(" TAY");
                break;
            }
            case 186: {
                m_fdbg.append(" TSX");
                break;
            }
            case 138: {
                m_fdbg.append(" TXA");
                break;
            }
            case 154: {
                m_fdbg.append(" TXS");
                break;
            }
            case 152: {
                m_fdbg.append(" TYA");
                break;
            }
            default: {
                m_fdbg.append("*HLT");
            }
        }
        switch (opcode) {
            case 10: 
            case 42: 
            case 74: 
            case 106: {
                m_fdbg.append("n  A");
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 69: 
            case 70: 
            case 71: 
            case 101: 
            case 102: 
            case 103: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                m_fdbg.append(String.format("z  %02x {%02x}", (short)operand, data));
                break;
            }
            case 4: 
            case 68: 
            case 100: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                if (!MOS6510.isLoggable(Level.FINE) && (opcode == 4 || opcode == 68 || opcode == 100)) break;
                m_fdbg.append(String.format("z  %02x", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 53: 
            case 54: 
            case 55: 
            case 85: 
            case 86: 
            case 87: 
            case 117: 
            case 118: 
            case 119: 
            case 180: 
            case 181: 
            case 213: 
            case 214: 
            case 215: 
            case 245: 
            case 246: 
            case 247: {
                m_fdbg.append(String.format("zx %02x,X", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 20: 
            case 52: 
            case 84: 
            case 116: 
            case 148: 
            case 149: 
            case 212: 
            case 244: {
                if (!MOS6510.isLoggable(Level.FINE) && (opcode == 20 || opcode == 52 || opcode == 84 || opcode == 116 || opcode == 212 || opcode == 244)) break;
                m_fdbg.append(String.format("zx %02x,X", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 182: 
            case 183: {
                m_fdbg.append(String.format("zy %02x,Y", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 150: 
            case 151: {
                m_fdbg.append(String.format("zy %02x,Y", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 77: 
            case 78: 
            case 79: 
            case 109: 
            case 110: 
            case 111: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                m_fdbg.append(String.format("a  %04x {%02x}", operand, data));
                break;
            }
            case 12: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                if (!MOS6510.isLoggable(Level.FINE) && opcode == 12) break;
                m_fdbg.append(String.format("a  %04x", operand));
                break;
            }
            case 32: 
            case 76: {
                m_fdbg.append(String.format("w  %04x", operand));
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 61: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 95: 
            case 125: 
            case 126: 
            case 127: 
            case 188: 
            case 189: 
            case 221: 
            case 222: 
            case 223: 
            case 253: 
            case 254: 
            case 255: {
                m_fdbg.append(String.format("ax %04x,X", operand));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 28: 
            case 60: 
            case 92: 
            case 124: 
            case 156: 
            case 157: 
            case 220: 
            case 252: {
                if (!MOS6510.isLoggable(Level.FINE) && (opcode == 28 || opcode == 60 || opcode == 92 || opcode == 124 || opcode == 220 || opcode == 252)) break;
                m_fdbg.append(String.format("ax %04x,X", operand));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 25: 
            case 27: 
            case 57: 
            case 59: 
            case 89: 
            case 91: 
            case 121: 
            case 123: 
            case 155: 
            case 185: 
            case 187: 
            case 190: 
            case 191: 
            case 217: 
            case 219: 
            case 249: 
            case 251: {
                m_fdbg.append(String.format("ay %04x,Y", operand));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 153: 
            case 158: 
            case 159: {
                m_fdbg.append(String.format("ay %04x,Y", operand));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 9: 
            case 11: 
            case 41: 
            case 43: 
            case 73: 
            case 75: 
            case 105: 
            case 107: 
            case 128: 
            case 130: 
            case 137: 
            case 139: 
            case 160: 
            case 162: 
            case 169: 
            case 171: 
            case 192: 
            case 194: 
            case 201: 
            case 203: 
            case 224: 
            case 226: 
            case 233: 
            case 235: {
                if (!MOS6510.isLoggable(Level.FINE) && (opcode == 128 || opcode == 130 || opcode == 194 || opcode == 226 || opcode == 137)) break;
                m_fdbg.append(String.format("b  #%02x", SIDEndian.endian_16lo8(operand)));
                break;
            }
            case 16: 
            case 48: 
            case 80: 
            case 112: 
            case 144: 
            case 176: 
            case 208: 
            case 240: {
                m_fdbg.append(String.format("r  #%02x", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 108: {
                m_fdbg.append(String.format("i  (%04x)", operand));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 1: 
            case 3: 
            case 33: 
            case 35: 
            case 65: 
            case 67: 
            case 97: 
            case 99: 
            case 161: 
            case 163: 
            case 193: 
            case 195: 
            case 225: 
            case 227: {
                m_fdbg.append(String.format("ix (%02x,X)", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 129: 
            case 131: {
                m_fdbg.append(String.format("ix (%02x,X)", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
            case 17: 
            case 19: 
            case 49: 
            case 51: 
            case 81: 
            case 83: 
            case 113: 
            case 115: 
            case 177: 
            case 179: 
            case 209: 
            case 211: 
            case 241: 
            case 243: {
                m_fdbg.append(String.format("iy (%02x),Y", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]{%02x}", address, data));
                break;
            }
            case 145: 
            case 147: {
                m_fdbg.append(String.format("iy (%02x),Y", SIDEndian.endian_16lo8(operand)));
                m_fdbg.append(String.format(" [%04x]", address));
                break;
            }
        }
        m_fdbg.append("\n");
        MOS6510.info(m_fdbg.toString());
    }

    public void aecSignal(boolean state) {
        if (this.aec != state) {
            long clock = this.eventContext.getTime(this.m_extPhase);
            this.aec = state;
            if (state && this.m_blocked) {
                long stolen = clock - this.m_stealingClk;
                this.interrupts.nmiClk += stolen;
                this.interrupts.irqClk += stolen;
                if (this.interrupts.nmiClk > clock) {
                    this.interrupts.nmiClk = clock - 1L;
                }
                if (this.interrupts.irqClk > clock) {
                    this.interrupts.irqClk = clock - 1L;
                }
                this.m_blocked = false;
            }
            this.eventContext.schedule(this.event, this.eventContext.phase() == this.m_phase ? 1 : 0, this.m_phase);
        }
    }

    public void triggerRST() {
        this.interrupts.pending = (short)(this.interrupts.pending | 1);
    }

    public void triggerNMI() {
        this.interrupts.pending = (short)(this.interrupts.pending | 2);
        this.interrupts.nmiClk = this.eventContext.getTime(this.m_extPhase);
    }

    public void triggerIRQ() {
        if (!this.getFlagI()) {
            this.interrupts.irqRequest = true;
        }
        short s = this.interrupts.irqs;
        this.interrupts.irqs = (short)(s + 1);
        if (s == 0) {
            this.interrupts.irqClk = this.eventContext.getTime(this.m_extPhase);
        }
        if (this.interrupts.irqs > 3) {
            MOS6510.log(Level.SEVERE, "\nMOS6510 ERROR: An external component is not clearing down it's IRQs.\n\n");
            throw new RuntimeException("MOS6510 Error: too many IRQs");
        }
    }

    public void clearIRQ() {
        if (this.interrupts.irqs > 0 && (this.interrupts.irqs = (short)(this.interrupts.irqs - 1)) == 0) {
            this.interrupts.irqRequest = false;
        }
    }

    void setFlagsNZ(short x) {
        this.Register_z_Flag = this.Register_n_Flag = x;
    }

    void setFlagN(short x) {
        this.Register_n_Flag = x;
    }

    void setFlagV(short x) {
        this.Register_v_Flag = x;
    }

    void setFlagD(short x) {
        this.Register_Status = (short)(this.Register_Status & 0xF7 | (x != 0 ? 1 : 0) << 3);
    }

    void setFlagI(short x) {
        this.Register_Status = (short)(this.Register_Status & 0xFB | (x != 0 ? 1 : 0) << 2);
    }

    void setFlagZ(short x) {
        this.Register_z_Flag = x;
    }

    void setFlagC(short x) {
        this.Register_c_Flag = x;
    }

    boolean getFlagN() {
        return (this.Register_n_Flag & 0x80) != 0;
    }

    boolean getFlagV() {
        return this.Register_v_Flag != 0;
    }

    boolean getFlagD() {
        return (this.Register_Status & 8) != 0;
    }

    boolean getFlagI() {
        return (this.Register_Status & 4) != 0;
    }

    boolean getFlagZ() {
        return this.Register_z_Flag == 0;
    }

    boolean getFlagC() {
        return this.Register_c_Flag != 0;
    }

    public void debug(boolean enable) {
        this.dodump = enable;
    }

    protected static class Interrupts {
        short pending;
        short irqs;
        long nmiClk;
        long irqClk;
        boolean irqRequest;
        boolean irqLatch;

        protected Interrupts() {
        }
    }

    protected static class ProcessorOperations {
        ProcessorCycle[] cycle = null;

        ProcessorOperations() {
        }
    }

    protected static class ProcessorCycle {
        IFunc func = null;
        boolean nosteal = false;

        ProcessorCycle() {
        }
    }

    protected static interface IFunc {
        public void invoke();
    }
}

