/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.common.mos6510;

import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.common.mos6510.MOS6510;
import java.util.logging.Level;

public class SID6510
extends MOS6510 {
    private boolean m_sleeping;
    private ISID2Types.sid2_env_t m_mode;
    private long m_delayClk;
    private boolean m_framelock = false;
    private MOS6510.ProcessorCycle delayCycle = new MOS6510.ProcessorCycle();

    public SID6510(IEventContext context) {
        super(context);
        this.m_mode = ISID2Types.sid2_env_t.sid2_envR;
        this.delayCycle.func = new MOS6510.IFunc(){

            @Override
            public void invoke() {
                SID6510.this.sid_delay();
            }
        };
    }

    @Override
    public void reset() {
        this.m_sleeping = false;
        super.reset();
    }

    public void reset(int pc, short a, short x, short y) {
        this.reset();
        this.Register_Accumulator = a;
        this.Register_X = x;
        this.Register_Y = y;
        this.Register_ProgramCounter = pc;
    }

    public void environment(ISID2Types.sid2_env_t mode) {
        this.m_mode = mode;
    }

    @Override
    public void triggerRST() {
        super.triggerRST();
        if (this.m_sleeping) {
            this.m_sleeping = false;
            this.eventContext.schedule(this.event, this.eventContext.phase() == this.m_phase ? 1L : 0L, this.m_phase);
        }
    }

    @Override
    public void triggerNMI() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            super.triggerNMI();
            if (this.m_sleeping) {
                this.m_sleeping = false;
                this.eventContext.schedule(this.event, this.eventContext.phase() == this.m_phase ? 1L : 0L, this.m_phase);
            }
        }
    }

    @Override
    public void triggerIRQ() {
        switch (this.m_mode) {
            default: {
                if (MOS6510.isLoggable(Level.FINE) && this.dodump) {
                    MOS6510.fine("****************************************************\n");
                    MOS6510.fine(" Fake IRQ Routine\n");
                    MOS6510.fine("****************************************************\n");
                }
                return;
            }
            case sid2_envR: 
        }
        super.triggerIRQ();
        if (this.m_sleeping) {
            boolean bl = this.m_sleeping = !this.interrupts.irqRequest && this.interrupts.pending == 0;
            if (!this.m_sleeping) {
                this.eventContext.schedule(this.event, this.eventContext.phase() == this.m_phase ? 1L : 0L, this.m_phase);
            }
        }
    }

    public void sleep() {
        this.m_delayClk = this.m_stealingClk = this.eventContext.getTime(this.m_phase);
        this.procCycle = new MOS6510.ProcessorCycle[]{this.delayCycle};
        this.cycleCount = 0;
        this.m_sleeping = !this.interrupts.irqRequest && this.interrupts.pending == 0;
        this.envSleep();
    }

    @Override
    protected void illegal_instr() {
        this.sid_illegal();
    }

    @Override
    protected void jmp_instr() {
        this.sid_jmp();
    }

    @Override
    protected void cli_instr() {
        this.sid_cli();
    }

    @Override
    protected void PopSR_sidplay_rti() {
        this.sid_rti();
    }

    @Override
    protected void PushHighPC_sidplay_brk() {
        this.sid_brk();
    }

    @Override
    protected void IRQRequest_sidplay_irq() {
        this.sid_irq();
    }

    @Override
    protected void FetchOpcode() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            super.FetchOpcode();
            return;
        }
        this.m_sleeping |= SIDEndian.endian_16hi8(this.Register_StackPointer) != 1;
        this.m_sleeping |= SIDEndian.endian_32hi16(this.Register_ProgramCounter) != 0;
        if (!this.m_sleeping) {
            super.FetchOpcode();
        }
        if (!this.m_framelock) {
            int timeout;
            this.m_framelock = true;
            for (timeout = 6000000; !this.m_sleeping && timeout != 0; --timeout) {
                super.clock();
            }
            if (timeout == 0) {
                MOS6510.log(Level.SEVERE, "\n\nINFINITE LOOP DETECTED *********************************\n");
                this.envReset();
            }
            this.sleep();
            this.m_framelock = false;
        }
    }

    private void sid_illegal() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            super.illegal_instr();
            return;
        }
        if (MOS6510.isLoggable(Level.FINE)) {
            this.DumpState();
        }
    }

    private void sid_delay() {
        long stolen = this.eventContext.getTime(this.m_stealingClk, this.m_phase);
        long delayed = this.eventContext.getTime(this.m_delayClk, this.m_phase);
        if (delayed > stolen) {
            delayed -= stolen;
            this.m_delayClk += stolen;
            this.m_stealingClk = this.m_delayClk;
        }
        this.cycleCount = (byte)(this.cycleCount - 1);
        if (this.m_sleeping) {
            this.eventContext.cancel(this.event);
        } else {
            long cycle = delayed % 3L;
            if (cycle == 0L && this.interruptPending()) {
                return;
            }
            this.eventContext.schedule(this.event, 3L - cycle, this.m_phase);
        }
    }

    private void sid_brk() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            super.PushHighPC();
            return;
        }
        this.sei_instr();
        this.sid_rts();
        this.FetchOpcode();
    }

    private void sid_jmp() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            if (this.Cycle_EffectiveAddress == this.instrStartPC) {
                this.Register_ProgramCounter = SIDEndian.endian_32lo16(this.Register_ProgramCounter, this.Cycle_EffectiveAddress);
                if (!this.interruptPending()) {
                    this.sleep();
                }
            } else {
                super.jmp_instr();
            }
            return;
        }
        if (this.envCheckBankJump(this.Cycle_EffectiveAddress)) {
            super.jmp_instr();
        } else {
            this.sid_rts();
        }
    }

    private void sid_rts() {
        this.PopLowPC();
        this.PopHighPC();
        this.rts_instr();
    }

    private void sid_cli() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            super.cli_instr();
        }
    }

    private void sid_rti() {
        if (this.m_mode == ISID2Types.sid2_env_t.sid2_envR) {
            this.PopSR();
            return;
        }
        this.sid_rts();
        this.FetchOpcode();
    }

    private void sid_irq() {
        super.IRQRequest();
        if (this.m_mode != ISID2Types.sid2_env_t.sid2_envR) {
            ++this.Register_StackPointer;
        }
    }
}

