/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.sidtune.SmartPtr_sidtt;

public class P00 {
    private static final int X00_ID_LEN = 8;
    private static final int X00_NAME_LEN = 17;
    private static final String _sidtune_id = "C64File";
    private static final String _sidtune_format_del = "Unsupported tape image file (DEL)";
    private static final String _sidtune_format_seq = "Unsupported tape image file (SEQ)";
    private static final String _sidtune_format_prg = "Tape image file (PRG)";
    private static final String _sidtune_format_usr = "Unsupported USR file (USR)";
    private static final String _sidtune_format_rel = "Unsupported tape image file (REL)";
    private static final String _sidtune_truncated = "ERROR: File is most likely truncated";
    private SidTune sidtune;
    private SidTuneInfo info;

    public P00(SidTune sidtune) {
        this.sidtune = sidtune;
        this.info = sidtune.info;
    }

    protected SidTune.LoadStatus X00_fileSupport(String fileName, Buffer_sidtt dataBuf) {
        int lastIndexOf = fileName.lastIndexOf(".");
        String ext = lastIndexOf != -1 ? fileName.substring(lastIndexOf) : "";
        String format = null;
        X00Header pHeader = new X00Header(dataBuf.get());
        int bufLen = dataBuf.len();
        if (ext.length() != 4) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (!Character.isDigit(ext.charAt(2)) || !Character.isDigit(ext.charAt(3))) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        X00Format type = X00Format.X00_UNKNOWN;
        switch (Character.toUpperCase(ext.charAt(1))) {
            case 'D': {
                type = X00Format.X00_DEL;
                format = _sidtune_format_del;
                break;
            }
            case 'S': {
                type = X00Format.X00_SEQ;
                format = _sidtune_format_seq;
                break;
            }
            case 'P': {
                type = X00Format.X00_PRG;
                format = _sidtune_format_prg;
                break;
            }
            case 'U': {
                type = X00Format.X00_USR;
                format = _sidtune_format_usr;
                break;
            }
            case 'R': {
                type = X00Format.X00_REL;
                format = _sidtune_format_rel;
            }
        }
        if (type == X00Format.X00_UNKNOWN) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        int idLen = new String(pHeader.id).indexOf(0);
        if (idLen == -1) {
            idLen = pHeader.id.length;
        }
        if (bufLen < 8) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (!new String(pHeader.id, 0, idLen).equals(_sidtune_id)) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        this.info.formatString = format;
        if (type != X00Format.X00_PRG) {
            return SidTune.LoadStatus.LOAD_ERROR;
        }
        if (bufLen < 28) {
            this.info.formatString = _sidtune_truncated;
            return SidTune.LoadStatus.LOAD_ERROR;
        }
        int nameLen = new String(pHeader.name).indexOf(0);
        if (nameLen == -1) {
            nameLen = pHeader.name.length;
        }
        short[] buf = new short[nameLen];
        for (int j = 0; j < nameLen; ++j) {
            buf[j] = (short)pHeader.name[j];
        }
        SmartPtr_sidtt spPet = new SmartPtr_sidtt(buf, nameLen, false);
        StringBuffer lineInfo = new StringBuffer();
        this.sidtune.convertPetsciiToAscii(spPet, lineInfo);
        this.sidtune.infoString[0] = lineInfo.toString();
        this.sidtune.fileOffset = 26;
        this.info.songs = 1;
        this.info.startSong = 1;
        this.info.compatibility = 3;
        this.info.numberOfInfoStrings = 1;
        this.info.infoString[0] = this.sidtune.infoString[0];
        this.sidtune.convertOldStyleSpeedToTables(-1L, this.info.clockSpeed);
        return SidTune.LoadStatus.LOAD_OK;
    }

    static enum X00Format {
        X00_UNKNOWN,
        X00_DEL,
        X00_SEQ,
        X00_PRG,
        X00_USR,
        X00_REL;

    }

    private static class X00Header {
        public static final int SIZE = 26;
        char[] id = new char[8];
        char[] name = new char[17];

        public X00Header(short[] s) {
            int i;
            int off = 0;
            for (i = 0; i < 8; ++i) {
                this.id[i] = (char)s[off++];
            }
            for (i = 0; i < 17; ++i) {
                this.name[i] = (char)s[off++];
            }
        }
    }
}

