/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.InfoFile;
import de.quippy.sidplay.libsidplay.components.sidtune.Mus;
import de.quippy.sidplay.libsidplay.components.sidtune.P00;
import de.quippy.sidplay.libsidplay.components.sidtune.PP20;
import de.quippy.sidplay.libsidplay.components.sidtune.PSid;
import de.quippy.sidplay.libsidplay.components.sidtune.Prg;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.sidtune.SmartPtr_sidtt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class SidTune {
    private static final Logger TUNE = Logger.getLogger(SidTune.class.getName());
    public static final int SIDTUNE_MAX_SONGS = 256;
    public static final int SIDTUNE_MAX_CREDIT_STRINGS = 10;
    public static final int SIDTUNE_MAX_CREDIT_STRLEN = 81;
    public static final int SIDTUNE_MAX_MEMORY = 65536;
    public static final int SIDTUNE_MAX_FILELEN = 65662;
    public static final int SIDTUNE_SPEED_VBI = 0;
    public static final int SIDTUNE_SPEED_CIA_1A = 60;
    public static final int SIDTUNE_CLOCK_UNKNOWN = 0;
    public static final int SIDTUNE_CLOCK_PAL = 1;
    public static final int SIDTUNE_CLOCK_NTSC = 2;
    public static final int SIDTUNE_CLOCK_ANY = 3;
    public static final int SIDTUNE_SIDMODEL_UNKNOWN = 0;
    public static final int SIDTUNE_SIDMODEL_6581 = 1;
    public static final int SIDTUNE_SIDMODEL_8580 = 2;
    public static final int SIDTUNE_SIDMODEL_ANY = 3;
    public static final int SIDTUNE_COMPATIBILITY_C64 = 0;
    public static final int SIDTUNE_COMPATIBILITY_PSID = 1;
    public static final int SIDTUNE_COMPATIBILITY_R64 = 2;
    public static final int SIDTUNE_COMPATIBILITY_BASIC = 3;
    protected SidTuneInfo info = new SidTuneInfo();
    protected boolean status;
    protected short[] songSpeed = new short[256];
    protected short[] clockSpeed = new short[256];
    protected short[] songLength = new short[256];
    protected String[] infoString = new String[10];
    protected int fileOffset;
    protected int musDataLen;
    protected Buffer_sidtt cache = new Buffer_sidtt();
    private static final String[] defaultFileNameExt = new String[]{".sid", ".dat", ".inf", "", ".DAT", ".SID", ".INF", ".c64", ".prg", ".p00", ".C64", ".PRG", ".P00", ".info", ".INFO", ".data", ".DATA", ".str", ".STR", ".mus", ".MUS"};
    protected static String[] fileNameExtensions = defaultFileNameExt;
    private PSid psid = new PSid(this);
    Mus mus = new Mus(this);
    InfoFile inf = new InfoFile(this);
    Prg prg = new Prg(this);
    P00 p00 = new P00(this);
    protected static final String txt_songNumberExceed = "SIDTUNE WARNING: Selected song number was too high";
    protected static final String txt_empty = "SIDTUNE ERROR: No data to load";
    protected static final String txt_unrecognizedFormat = "SIDTUNE ERROR: Could not determine file format";
    protected static final String txt_noDataFile = "SIDTUNE ERROR: Did not find the corresponding data file";
    protected static final String txt_notEnoughMemory = "SIDTUNE ERROR: Not enough free memory";
    protected static final String txt_cantLoadFile = "SIDTUNE ERROR: Could not load input file";
    protected static final String txt_cantOpenFile = "SIDTUNE ERROR: Could not open file for binary input";
    protected static final String txt_fileTooLong = "SIDTUNE ERROR: Input data too long";
    protected static final String txt_dataTooLong = "SIDTUNE ERROR: Size of music data exceeds C64 memory";
    protected static final String txt_cantCreateFile = "SIDTUNE ERROR: Could not create output file";
    protected static final String txt_fileIoError = "SIDTUNE ERROR: File I/O error";
    protected static final String txt_VBI = "VBI";
    protected static final String txt_CIA = "CIA 1 Timer A";
    protected static final String txt_noErrors = "No errors";
    protected static final String txt_na = "N/A";
    protected static final String txt_badAddr = "SIDTUNE ERROR: Bad address data";
    protected static final String txt_badReloc = "SIDTUNE ERROR: Bad reloc data";
    protected static final String txt_corrupt = "SIDTUNE ERROR: File is incomplete or corrupt";
    private static final short[] _sidtune_CHRtab = new short[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 33, 1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 36, 93, 32, 32, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35};

    public SidTune(String fileName, String[] fileNameExt) {
        this.init();
        SidTune.setFileNameExtensions(fileNameExt);
        if (fileName != null && fileName.equals("-")) {
            this.getFromStdIn();
        } else if (fileName != null) {
            this.getFromFiles(fileName);
        }
    }

    public SidTune(short[] oneFileFormatSidtune, int sidtuneLength) {
        this.init();
        this.getFromBuffer(oneFileFormatSidtune, sidtuneLength);
    }

    public static void setFileNameExtensions(String[] fileNameExt) {
        fileNameExtensions = fileNameExt != null ? fileNameExt : defaultFileNameExt;
    }

    public boolean load(String fileName) {
        this.cleanup();
        this.init();
        if (fileName != null && fileName.equals("-")) {
            this.getFromStdIn();
        } else if (fileName != null) {
            this.getFromFiles(fileName);
        }
        return this.status;
    }

    public boolean read(short[] sourceBuffer, int bufferLen) {
        this.cleanup();
        this.init();
        this.getFromBuffer(sourceBuffer, bufferLen);
        return this.status;
    }

    public final SidTuneInfo opGet(int songNum) {
        this.selectSong(songNum);
        return this.info;
    }

    public int selectSong(int selectedSong) {
        if (!this.status) {
            return 0;
        }
        this.info.statusString = txt_noErrors;
        int song = selectedSong;
        if (selectedSong == 0) {
            song = this.info.startSong;
        }
        if (selectedSong > this.info.songs || selectedSong > 256) {
            song = this.info.startSong;
            this.info.statusString = txt_songNumberExceed;
        }
        this.info.currentSong = song;
        this.info.songSpeed = this.info.compatibility == 2 ? (short)60 : this.songSpeed[song - 1];
        this.info.clockSpeed = this.clockSpeed[song - 1];
        this.info.speedString = this.info.songSpeed == 0 ? txt_VBI : txt_CIA;
        return this.info.currentSong;
    }

    public final SidTuneInfo getInfo() {
        return this.info;
    }

    public boolean bool() {
        return this.status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean isStereo() {
        return this.info.sidChipBase1 != 0 && this.info.sidChipBase2 != 0;
    }

    public boolean placeSidTuneInC64mem(short[] c64buf) {
        if (this.status && c64buf != null) {
            int endPos = this.info.loadAddr + this.info.c64dataLen;
            if (endPos <= 65536) {
                System.arraycopy(this.cache.get(), this.fileOffset, c64buf, this.info.loadAddr, this.info.c64dataLen);
                this.info.statusString = txt_noErrors;
                for (int i = 0; i < this.info.c64dataLen; i += 16) {
                    for (int j = 0; j < 16 && i + j < this.info.c64dataLen; ++j) {
                        TUNE.fine(String.format("0x%02x ", c64buf[this.info.loadAddr + i + j]));
                    }
                    TUNE.fine("\n");
                }
            } else {
                System.arraycopy(this.cache.get(), this.fileOffset, c64buf, this.info.loadAddr, this.info.c64dataLen - (endPos - 65536));
                this.info.statusString = txt_dataTooLong;
            }
            if (this.info.musPlayer) {
                this.MUS_installPlayer(c64buf);
            }
        }
        return this.status && c64buf != null;
    }

    public boolean saveC64dataFile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.info.musPlayer) {
                    short[] saveAddr = new short[]{(short)(this.info.loadAddr & 0xFF), (short)(this.info.loadAddr >> 8)};
                    fMyOut.write(saveAddr[0]);
                    fMyOut.write(saveAddr[1]);
                }
                if (!this.saveToOpenFile(fMyOut, this.cache.get(), this.fileOffset, this.info.dataFileLen - this.fileOffset)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public boolean saveSIDfile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.SID_fileSupportSave(fMyOut)) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public boolean savePSIDfile(String destFileName, boolean overWriteFlag) {
        boolean success = false;
        if (this.status) {
            try {
                FileOutputStream fMyOut = new FileOutputStream(destFileName, !overWriteFlag);
                if (!this.PSID_fileSupportSave(fMyOut, this.cache.get())) {
                    this.info.statusString = txt_fileIoError;
                } else {
                    this.info.statusString = txt_noErrors;
                    success = true;
                }
                fMyOut.close();
            }
            catch (IOException e) {
                this.info.statusString = txt_cantCreateFile;
            }
        }
        return success;
    }

    public void fixLoadAddress(boolean force, int init, int play) {
        if (this.info.fixLoad || force) {
            this.info.fixLoad = false;
            this.info.loadAddr += 2;
            this.fileOffset += 2;
            if (force) {
                this.info.initAddr = init;
                this.info.playAddr = play;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFile(String fileName, Buffer_sidtt bufferRef) {
        FileInputStream myIn = null;
        Buffer_sidtt fileBuf = new Buffer_sidtt();
        int fileLen = 0;
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) {
            this.info.statusString = txt_cantOpenFile;
            return false;
        }
        try {
            myIn = new FileInputStream(file);
            fileLen = (int)file.length();
            if (!fileBuf.assign(new short[fileLen], fileLen)) {
                this.info.statusString = txt_notEnoughMemory;
                boolean bl = false;
                return bl;
            }
            int restFileLen = fileLen;
            if (restFileLen > 0) {
                for (int i = 0; i < fileLen; ++i) {
                    fileBuf.get()[i] = (short)myIn.read();
                }
            }
            this.info.statusString = txt_noErrors;
            myIn.close();
        }
        catch (IOException e) {
            this.info.statusString = txt_cantLoadFile;
            boolean bl = false;
            return bl;
        }
        finally {
            if (myIn != null) {
                try {
                    myIn.close();
                }
                catch (IOException ex) {
                    this.info.statusString = ex.getMessage();
                }
            }
        }
        if (fileLen == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        if (this.decompressPP20(fileBuf) < 0) {
            return false;
        }
        bufferRef.assign(fileBuf.xferPtr(), fileBuf.xferLen());
        return true;
    }

    public boolean saveToOpenFile(OutputStream toFile, short[] buffer, int bufferOffset, int bufLen) {
        int lenToWrite = bufLen;
        try {
            if (lenToWrite > 0) {
                for (int i = bufLen - lenToWrite; i < lenToWrite; ++i) {
                    toFile.write(buffer[bufferOffset + i]);
                }
            }
        }
        catch (IOException e) {
            this.info.statusString = txt_fileIoError;
            return false;
        }
        this.info.statusString = txt_noErrors;
        return true;
    }

    protected void convertOldStyleSpeedToTables(long speed, short clock) {
        int toDo = this.info.songs <= 256 ? this.info.songs : 256;
        for (int s = 0; s < toDo; ++s) {
            this.clockSpeed[s] = clock;
            this.songSpeed[s] = (speed >> (s & 0x1F) & 1L) == 0L ? 0 : 60;
        }
    }

    protected int convertPetsciiToAscii(SmartPtr_sidtt spPet, StringBuffer dest) {
        int count = 0;
        if (dest != null) {
            short c;
            do {
                if ((c = _sidtune_CHRtab[spPet.operatorMal()]) >= 32 && count <= 31) {
                    dest.setLength(count + 1);
                    dest.setCharAt(count++, (char)c);
                }
                if (spPet.operatorMal() == 157 && count >= 0) {
                    --count;
                }
                spPet.operatorPlusPlus();
            } while (c != 13 && c != 0 && !spPet.fail());
        } else {
            short c;
            do {
                c = _sidtune_CHRtab[spPet.operatorMal()];
                spPet.operatorPlusPlus();
            } while (c != 13 && c != 0 && !spPet.fail());
        }
        return count;
    }

    protected boolean checkCompatibility() {
        switch (this.info.compatibility) {
            case 2: {
                switch (this.info.initAddr >> 12) {
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.info.statusString = txt_badAddr;
                        return false;
                    }
                }
                if (this.info.initAddr < this.info.loadAddr || this.info.initAddr > this.info.loadAddr + this.info.c64dataLen - 1) {
                    this.info.statusString = txt_badAddr;
                    return false;
                }
            }
            case 3: {
                if (this.info.loadAddr >= 2024) break;
                this.info.statusString = txt_badAddr;
                return false;
            }
        }
        return true;
    }

    protected boolean checkRelocInfo() {
        short startlp;
        if (this.info.relocStartPage == 255) {
            this.info.relocPages = 0;
            return true;
        }
        if (this.info.relocPages == 0) {
            this.info.relocStartPage = 0;
            return true;
        }
        short startp = this.info.relocStartPage;
        short endp = (short)(startp + this.info.relocPages - 1 & 0xFF);
        if (endp < startp) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        short endlp = startlp = (short)(this.info.loadAddr >> 8);
        endlp = (short)(endlp + (short)(this.info.c64dataLen - 1 >> 8));
        if (startp <= startlp && endp >= startlp || startp <= endlp && endp >= endlp) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        if (startp < 4 || 160 <= startp && startp <= 191 || startp >= 208 || 160 <= endp && endp <= 191 || endp >= 208) {
            this.info.statusString = txt_badReloc;
            return false;
        }
        return true;
    }

    protected boolean resolveAddrs(short[] c64data, int fileOffset2) {
        if (this.info.playAddr == 65535) {
            this.info.playAddr = 0;
        }
        if (this.info.loadAddr == 0) {
            if (this.info.c64dataLen < 2) {
                this.info.statusString = txt_corrupt;
                return false;
            }
            this.info.loadAddr = SIDEndian.endian_16(c64data[this.fileOffset + 1], c64data[this.fileOffset + 0]);
            this.fileOffset += 2;
            this.info.c64dataLen -= 2;
        }
        if (this.info.compatibility == 3) {
            if (this.info.initAddr != 0) {
                this.info.statusString = txt_badAddr;
                return false;
            }
        } else if (this.info.initAddr == 0) {
            this.info.initAddr = this.info.loadAddr;
        }
        return true;
    }

    protected LoadStatus PSID_fileSupport(Buffer_sidtt dataBuf) {
        return this.psid.PSID_fileSupport(dataBuf);
    }

    protected boolean PSID_fileSupportSave(OutputStream toFile, short[] dataBuffer) {
        return this.psid.PSID_fileSupportSave(toFile, dataBuffer);
    }

    protected LoadStatus SID_fileSupport(Buffer_sidtt dataBuf, Buffer_sidtt sidBuf) {
        return LoadStatus.LOAD_NOT_MINE;
    }

    protected boolean SID_fileSupportSave(OutputStream toFile) {
        return true;
    }

    protected LoadStatus MUS_fileSupport(Buffer_sidtt musBuf, Buffer_sidtt strBuf) {
        return this.mus.MUS_fileSupport(musBuf, strBuf);
    }

    protected LoadStatus MUS_load(Buffer_sidtt musBuf, boolean init) {
        return this.mus.MUS_load(musBuf, init);
    }

    protected LoadStatus MUS_load(Buffer_sidtt musBuf, Buffer_sidtt strBuf, boolean init) {
        return this.mus.MUS_load(musBuf, strBuf, init);
    }

    protected boolean MUS_detect(short[] buffer, int bufLen, Mus.Voice3Index voice3Index) {
        return this.mus.MUS_detect(buffer, bufLen, voice3Index);
    }

    protected boolean MUS_mergeParts(Buffer_sidtt musBuf, Buffer_sidtt strBuf) {
        return this.mus.MUS_mergeParts(musBuf, strBuf);
    }

    protected void MUS_setPlayerAddress() {
        this.mus.MUS_setPlayerAddress();
    }

    protected void MUS_installPlayer(short[] c64buf) {
        this.mus.MUS_installPlayer(c64buf);
    }

    protected LoadStatus INFO_fileSupport(Buffer_sidtt dataBuf, Buffer_sidtt infoBuf) {
        return this.inf.INFO_fileSupport(dataBuf, infoBuf);
    }

    protected LoadStatus PRG_fileSupport(String fileName, Buffer_sidtt dataBuf) {
        return this.prg.PRG_fileSupport(fileName, dataBuf);
    }

    protected LoadStatus X00_fileSupport(String fileName, Buffer_sidtt dataBuf) {
        return this.p00.X00_fileSupport(fileName, dataBuf);
    }

    private void init() {
        this.status = false;
        this.info.statusString = txt_na;
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
        this.info.c64dataLen = 0;
        this.info.dataFileLen = 0;
        this.info.formatString = txt_na;
        this.info.speedString = txt_na;
        this.info.playAddr = 0;
        this.info.initAddr = 0;
        this.info.loadAddr = 0;
        this.info.currentSong = 0;
        this.info.startSong = 0;
        this.info.songs = 0;
        this.info.sidChipBase1 = 54272;
        this.info.sidChipBase2 = 0;
        this.info.musPlayer = false;
        this.info.fixLoad = false;
        this.info.songSpeed = 0;
        this.info.clockSpeed = 0;
        this.info.sidModel = 0;
        this.info.compatibility = 0;
        this.info.relocStartPage = 0;
        this.info.relocPages = 0;
        for (int si = 0; si < 256; ++si) {
            this.songSpeed[si] = this.info.songSpeed;
            this.clockSpeed[si] = this.info.clockSpeed;
            this.songLength[si] = 0;
        }
        this.fileOffset = 0;
        this.musDataLen = 0;
        for (int sNum = 0; sNum < 10; ++sNum) {
            this.infoString[sNum] = null;
        }
        this.info.numberOfInfoStrings = 0;
        this.info.numberOfCommentStrings = 1;
        this.info.commentString = new String[this.info.numberOfCommentStrings];
        this.info.commentString[0] = this.info.commentString != null ? "--- SAVED WITH SIDPLAY ---" : null;
    }

    private void cleanup() {
        this.info.commentString = null;
        this.deleteFileNameCopies();
        this.status = false;
    }

    private void getFromStdIn() {
        this.status = false;
        this.info.statusString = txt_notEnoughMemory;
        short[] fileBuf = new short[65662];
        int i = 0;
        try {
            int datb;
            while ((datb = System.in.read()) != -1 && i < 65662) {
                fileBuf[i++] = (short)datb;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.info.dataFileLen = i;
        this.getFromBuffer(fileBuf, this.info.dataFileLen);
    }

    private void getFromFiles(String fileName) {
        this.status = false;
        Buffer_sidtt fileBuf1 = new Buffer_sidtt();
        Buffer_sidtt fileBuf2 = new Buffer_sidtt();
        StringBuffer fileName2 = new StringBuffer();
        if (this.loadFile(fileName, fileBuf1)) {
            LoadStatus ret = this.PSID_fileSupport(fileBuf1);
            if (ret != LoadStatus.LOAD_NOT_MINE) {
                if (ret == LoadStatus.LOAD_OK) {
                    this.status = this.acceptSidTune(fileName, null, fileBuf1);
                }
                return;
            }
            ret = this.orStatus(this.SID_fileSupport(fileBuf2, fileBuf1), this.INFO_fileSupport(fileBuf2, fileBuf1));
            if (ret == LoadStatus.LOAD_NOT_MINE) {
                int n;
                for (n = 0; n < fileNameExtensions.length; ++n) {
                    if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                        return;
                    }
                    if (fileName.equalsIgnoreCase(fileName2.toString()) || !this.loadFile(fileName2.toString(), fileBuf2) || this.SID_fileSupport(fileBuf1, fileBuf2) != LoadStatus.LOAD_OK && this.INFO_fileSupport(fileBuf1, fileBuf2) != LoadStatus.LOAD_OK) continue;
                    this.status = this.acceptSidTune(fileName, fileName2.toString(), fileBuf1);
                    return;
                }
                ret = this.MUS_fileSupport(fileBuf1, fileBuf2);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_ERROR) {
                        return;
                    }
                    for (n = 0; n < fileNameExtensions.length; ++n) {
                        if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                            return;
                        }
                        if (fileName.equalsIgnoreCase(fileName2.toString()) || !this.loadFile(fileName2.toString(), fileBuf2)) continue;
                        if (fileNameExtensions[n].equalsIgnoreCase(".mus")) {
                            if (this.MUS_fileSupport(fileBuf2, fileBuf1) != LoadStatus.LOAD_OK) continue;
                            if (this.MUS_mergeParts(fileBuf2, fileBuf1)) {
                                this.status = this.acceptSidTune(fileName2.toString(), fileName, fileBuf2);
                            }
                            return;
                        }
                        if (this.MUS_fileSupport(fileBuf1, fileBuf2) != LoadStatus.LOAD_OK) continue;
                        if (this.MUS_mergeParts(fileBuf1, fileBuf2)) {
                            this.status = this.acceptSidTune(fileName, fileName2.toString(), fileBuf1);
                        }
                        return;
                    }
                    fileBuf2.erase();
                    this.MUS_fileSupport(fileBuf1, fileBuf2);
                    this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    return;
                }
                ret = this.X00_fileSupport(fileName, fileBuf1);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    }
                    return;
                }
                ret = this.PRG_fileSupport(fileName, fileBuf1);
                if (ret != LoadStatus.LOAD_NOT_MINE) {
                    if (ret == LoadStatus.LOAD_OK) {
                        this.status = this.acceptSidTune(fileName, null, fileBuf1);
                    }
                    return;
                }
                this.info.statusString = txt_unrecognizedFormat;
                return;
            }
            if (ret == LoadStatus.LOAD_OK) {
                for (int n = 0; n < fileNameExtensions.length; ++n) {
                    if (!this.createNewFileName(fileName2, fileName, fileNameExtensions[n])) {
                        return;
                    }
                    if (fileName.equalsIgnoreCase(fileName2.toString()) || !this.loadFile(fileName2.toString(), fileBuf2) || this.SID_fileSupport(fileBuf2, fileBuf1) != LoadStatus.LOAD_OK && this.INFO_fileSupport(fileBuf2, fileBuf1) != LoadStatus.LOAD_OK) continue;
                    this.status = this.acceptSidTune(fileName2.toString(), fileName, fileBuf2);
                    return;
                }
                this.info.statusString = txt_noDataFile;
                return;
            }
        } else {
            return;
        }
    }

    private LoadStatus orStatus(LoadStatus support, LoadStatus support2) {
        int val1;
        int n = support == LoadStatus.LOAD_NOT_MINE ? 0 : (val1 = support == LoadStatus.LOAD_OK ? 1 : 2);
        int val2 = support2 == LoadStatus.LOAD_NOT_MINE ? 0 : (support2 == LoadStatus.LOAD_OK ? 1 : 2);
        int erg = val1 | val2;
        return erg == 0 ? LoadStatus.LOAD_NOT_MINE : (erg == 1 ? LoadStatus.LOAD_OK : LoadStatus.LOAD_ERROR);
    }

    private void deleteFileNameCopies() {
        if (this.info.dataFileName != null) {
            this.info.dataFileName = null;
        }
        if (this.info.infoFileName != null) {
            this.info.infoFileName = null;
        }
        if (this.info.path != null) {
            this.info.path = null;
        }
        this.info.dataFileName = null;
        this.info.infoFileName = null;
        this.info.path = null;
    }

    private void getFromBuffer(short[] buffer, int bufferLen) {
        this.status = false;
        if (buffer == null || bufferLen == 0) {
            this.info.statusString = txt_empty;
            return;
        }
        if (bufferLen > 65662) {
            this.info.statusString = txt_fileTooLong;
            return;
        }
        short[] tmpBuf = new short[bufferLen];
        System.arraycopy(buffer, 0, tmpBuf, 0, bufferLen);
        Buffer_sidtt buf1 = new Buffer_sidtt(tmpBuf, bufferLen);
        Buffer_sidtt buf2 = new Buffer_sidtt();
        if (this.decompressPP20(buf1) < 0) {
            return;
        }
        boolean foundFormat = false;
        LoadStatus ret = this.PSID_fileSupport(buf1);
        if (ret != LoadStatus.LOAD_NOT_MINE) {
            if (ret == LoadStatus.LOAD_ERROR) {
                return;
            }
            foundFormat = true;
        } else {
            ret = this.MUS_fileSupport(buf1, buf2);
            if (ret != LoadStatus.LOAD_NOT_MINE) {
                if (ret == LoadStatus.LOAD_ERROR) {
                    return;
                }
                foundFormat = this.MUS_mergeParts(buf1, buf2);
            } else {
                this.info.statusString = txt_unrecognizedFormat;
            }
        }
        if (foundFormat) {
            this.status = this.acceptSidTune("-", "-", buf1);
        }
    }

    private boolean acceptSidTune(String dataFileName, String infoFileName, Buffer_sidtt buf) {
        if (this.info.numberOfInfoStrings == 3) {
            for (int i = 0; i < 3; ++i) {
                if (this.infoString[i].length() != 0) continue;
                this.infoString[i] = "<?>";
                this.info.infoString[i] = this.infoString[i];
            }
        }
        this.deleteFileNameCopies();
        if (dataFileName != null) {
            this.info.path = dataFileName;
            File file = new File(this.info.path);
            this.info.dataFileName = file.getName();
            String string = this.info.path = file.getParentFile() != null ? file.getParentFile().getPath() : "";
            if (this.info.path == null || this.info.dataFileName == null) {
                this.info.statusString = txt_notEnoughMemory;
                return false;
            }
        } else {
            this.info.path = "";
            this.info.dataFileName = "";
        }
        this.info.infoFileName = infoFileName != null ? new File(infoFileName).getName() : "";
        if (this.info.songs > 256) {
            this.info.songs = 256;
        } else if (this.info.songs == 0) {
            ++this.info.songs;
        }
        if (this.info.startSong > this.info.songs) {
            this.info.startSong = 1;
        } else if (this.info.startSong == 0) {
            ++this.info.startSong;
        }
        if (this.info.musPlayer) {
            this.MUS_setPlayerAddress();
        }
        this.info.dataFileLen = buf.len();
        this.info.c64dataLen = buf.len() - this.fileOffset;
        if (!this.resolveAddrs(buf.get(), this.fileOffset)) {
            return false;
        }
        if (!this.checkRelocInfo()) {
            return false;
        }
        if (!this.checkCompatibility()) {
            return false;
        }
        if (this.info.dataFileLen >= 2) {
            boolean bl = this.info.fixLoad = SIDEndian.endian_little16(buf.get(), this.fileOffset) == this.info.loadAddr + 2;
        }
        if (this.info.c64dataLen > 65536) {
            this.info.statusString = txt_dataTooLong;
            return false;
        }
        if (this.info.c64dataLen == 0) {
            this.info.statusString = txt_empty;
            return false;
        }
        this.cache.assign(buf.xferPtr(), buf.xferLen());
        this.info.statusString = txt_noErrors;
        return true;
    }

    private boolean createNewFileName(StringBuffer destString, String sourceName, String sourceExt) {
        int extPos;
        if (destString.length() > 0) {
            destString.delete(0, destString.length() - 1);
        }
        if ((extPos = sourceName.lastIndexOf(".")) != -1) {
            destString.append(sourceName.substring(0, extPos)).append(sourceExt);
        } else {
            destString.append(sourceName);
            destString.append(sourceExt);
        }
        return true;
    }

    private int decompressPP20(Buffer_sidtt buf) {
        PP20 myPP = new PP20();
        if (myPP.isCompressed(buf.get(), buf.len())) {
            Decompressed decomp = new Decompressed();
            int fileLen = myPP.decompress(buf.get(), buf.len(), decomp);
            if (0 == fileLen) {
                this.info.statusString = myPP.getStatusString();
                return -1;
            }
            this.info.statusString = myPP.getStatusString();
            buf.assign(decomp.destBufRef, fileLen);
            return 1;
        }
        return 0;
    }

    public static class Decompressed {
        short[] destBufRef;
    }

    public static enum LoadStatus {
        LOAD_NOT_MINE,
        LOAD_OK,
        LOAD_ERROR;

    }
}

