/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder;

import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.SID;
import de.quippy.sidplay.resid_builder.sid_filter_t;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReSID
extends SIDEmu {
    private static final Logger RESID = Logger.getLogger(ReSID.class.getName());
    private static final String VERSION = "0.0.2";
    private IEventContext m_context = null;
    private Event.event_phase_t m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
    private SID m_sid = new SID();
    private long m_accessClk;
    private long m_gain = 100L;
    private static String m_credit = "ReSID V0.0.2 Engine:\t(C) 1999-2002 Simon White <sidplay2@yahoo.com>MOS6581 (SID) Emulation (ReSID V0.15):\t(C) 1999-2002 Dag Lem <resid@nimrod.no>";
    private final String m_error;
    private boolean m_status = true;
    private boolean m_locked = false;
    private byte m_optimisation = 0;

    public ReSID(SIDBuilder builder) {
        super(builder);
        if (this.m_sid == null) {
            this.m_error = "RESID ERROR: Unable to create sid object";
            this.m_status = false;
            return;
        }
        this.m_error = "N/A";
        this.reset((short)0);
    }

    @Override
    public final String credits() {
        return m_credit;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(short volume) {
        this.m_accessClk = 0L;
        this.m_sid.reset();
        this.m_sid.write(24, volume);
    }

    @Override
    public short read(short addr) {
        long cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += cycles;
        if (this.m_optimisation != 0) {
            if (cycles != 0L) {
                this.m_sid.clock((int)cycles);
            }
        } else {
            while (cycles-- != 0L) {
                this.m_sid.clock();
            }
        }
        return (short)this.m_sid.read(addr);
    }

    @Override
    public void write(short addr, short data) {
        if (RESID.isLoggable(Level.FINE)) {
            RESID.fine(String.format("write 0x%02x=0x%02x", addr, data));
            RESID.fine("\n");
        }
        long cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += cycles;
        if (this.m_optimisation != 0) {
            if (cycles != 0L) {
                this.m_sid.clock((int)cycles);
            }
        } else {
            while (cycles-- != 0L) {
                this.m_sid.clock();
            }
        }
        this.m_sid.write(addr, data);
    }

    @Override
    public final String error() {
        return this.m_error;
    }

    @Override
    public long output(short bits) {
        long cycles = this.m_context.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += cycles;
        if (this.m_optimisation != 0) {
            if (cycles != 0L) {
                this.m_sid.clock((int)cycles);
            }
        } else {
            while (cycles-- != 0L) {
                this.m_sid.clock();
            }
        }
        return (long)this.m_sid.output(bits) * this.m_gain / 100L;
    }

    public void filter(boolean enable) {
        this.m_sid.enable_filter(enable);
    }

    @Override
    public void voice(short num, short volume, boolean mute) {
        this.m_sid.mute(num, mute);
    }

    @Override
    public void gain(short percent) {
        this.m_gain = percent;
        this.m_gain += 100L;
        if (this.m_gain > 200L) {
            this.m_gain = 200L;
        }
    }

    @Override
    public void optimisation(byte level) {
        this.m_optimisation = level;
    }

    public boolean bool() {
        return this.m_status;
    }

    public void sampling(long freq) {
        this.m_sid.set_sampling_parameters(1000000.0, ISIDDefs.sampling_method.SAMPLE_FAST, freq, -1.0, 0.79);
    }

    public boolean filter(sid_filter_t filter) {
        int[][] fc;
        int[][] f0 = fc = new int[2050][2];
        int points = 0;
        if (filter == null) {
            SID.FCPoints fcp = new SID.FCPoints();
            this.m_sid.fc_default(fcp);
            fc = fcp.points;
            points = fcp.count;
        } else {
            int[] fstart;
            points = filter.points;
            if (points < 2 || points > 2048) {
                return false;
            }
            int[] fprev = fstart = new int[]{-1, 0};
            int fin = 0;
            int fout = 0;
            while (points-- > 0) {
                if (fprev[0] >= filter.cutoff[fin][0]) {
                    return false;
                }
                fc[++fout][0] = filter.cutoff[fin][0];
                fc[fout][1] = filter.cutoff[fin][1];
                fprev = filter.cutoff[fin++];
            }
            fc[fout + 1][0] = fc[fout][0];
            fc[fout + 1][1] = fc[fout][1];
            fc[0][0] = fc[1][0];
            fc[0][1] = fc[1][1];
            points = filter.points + 2;
        }
        this.m_sid.filter.interpolate(f0, 0, --points, this.m_sid.fc_plotter(), 1.0);
        if (filter != null && filter.Lthreshold != 0) {
            this.m_sid.set_distortion_properties(filter.Lthreshold, filter.Lsteepness, filter.Llp, filter.Lbp, filter.Lhp, filter.Hthreshold, filter.Hsteepness, filter.Hlp, filter.Hbp, filter.Hhp);
        }
        return true;
    }

    public void model(ISID2Types.sid2_model_t model) {
        if (model == ISID2Types.sid2_model_t.SID2_MOS8580) {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS8580);
        } else {
            this.m_sid.set_chip_model(ISIDDefs.chip_model.MOS6581);
        }
    }

    public boolean lock(C64Env env) {
        if (env == null) {
            if (!this.m_locked) {
                return false;
            }
            this.m_locked = false;
            this.m_context = null;
        } else {
            if (this.m_locked) {
                return false;
            }
            this.m_locked = true;
            this.m_context = env.context();
        }
        return true;
    }
}

