/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder.resid;

import de.quippy.sidplay.resid_builder.resid.EnvelopeGenerator;
import de.quippy.sidplay.resid_builder.resid.ExternalFilter;
import de.quippy.sidplay.resid_builder.resid.Filter;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.PointPlotter;
import de.quippy.sidplay.resid_builder.resid.Potentiometer;
import de.quippy.sidplay.resid_builder.resid.Voice;
import de.quippy.sidplay.resid_builder.resid.WaveformGenerator;

public class SID {
    public static boolean ANTTI_LANKILA_PATCH = true;
    protected Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    public Filter filter = new Filter();
    protected ExternalFilter extfilt = new ExternalFilter();
    protected Potentiometer potx = new Potentiometer();
    protected Potentiometer poty = new Potentiometer();
    protected int bus_value;
    protected int bus_value_ttl;
    protected double clock_frequency;
    protected int ext_in;
    protected static final int FIR_N = 125;
    protected static final int FIR_RES_INTERPOLATE = 285;
    protected static final int FIR_RES_FAST = 51473;
    protected static final int FIR_SHIFT = 15;
    protected static final int RINGSIZE = 16384;
    protected static final int FIXP_SHIFT = 16;
    protected static final int FIXP_MASK = 65535;
    protected ISIDDefs.sampling_method sampling;
    protected int cycles_per_sample;
    protected int sample_offset;
    protected int sample_index;
    protected short sample_prev;
    protected int fir_N;
    protected int fir_RES;
    protected short[] sample = null;
    protected short[] fir = null;

    public SID() {
        this.voice[0].set_sync_source(this.voice[2]);
        this.voice[1].set_sync_source(this.voice[0]);
        this.voice[2].set_sync_source(this.voice[1]);
        this.set_sampling_parameters(985248.0, ISIDDefs.sampling_method.SAMPLE_FAST, 44100.0, -1.0, 0.97);
        this.bus_value = 0;
        this.bus_value_ttl = 0;
        this.ext_in = 0;
    }

    public void set_chip_model(ISIDDefs.chip_model model) {
        for (int i = 0; i < 3; ++i) {
            this.voice[i].set_chip_model(model);
        }
        this.filter.set_chip_model(model);
        this.extfilt.set_chip_model(model);
    }

    public void set_distortion_properties(int Lt, int Ls, int Ll, int Lb, int Lh, int Ht, int Hs, int Hl, int Hb, int Hh) {
        this.filter.set_distortion_properties(Lt, Ls, Ll, Lb, Lh, Ht, Hs, Hl, Hb, Hh);
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.voice[i].reset();
        }
        this.filter.reset();
        this.extfilt.reset();
        this.bus_value = 0;
        this.bus_value_ttl = 0;
    }

    public void input(int sample) {
        this.ext_in = (sample << 4) * 3;
    }

    public int output() {
        int range = 65536;
        int half = 32768;
        int sample = this.extfilt.output() / 11;
        if (sample >= 32768) {
            return Short.MAX_VALUE;
        }
        if (sample < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return sample;
    }

    public int output(int bits) {
        int range = 1 << bits;
        int half = range >> 1;
        int sample = this.extfilt.output() / (734220 / range);
        if (sample >= half) {
            return half - 1;
        }
        if (sample < -half) {
            return -half;
        }
        return sample;
    }

    public int read(int offset) {
        switch (offset) {
            case 25: {
                return this.potx.readPOT();
            }
            case 26: {
                return this.poty.readPOT();
            }
            case 27: {
                return this.voice[2].wave.readOSC();
            }
            case 28: {
                return this.voice[2].envelope.readENV();
            }
        }
        return this.bus_value;
    }

    public void write(int offset, int value) {
        this.bus_value = value;
        this.bus_value_ttl = 8192;
        switch (offset) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(value);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(value);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(value);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(value);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(value);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(value);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(value);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(value);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(value);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(value);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(value);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(value);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(value);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(value);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(value);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 21: {
                this.filter.writeFC_LO(value);
                break;
            }
            case 22: {
                this.filter.writeFC_HI(value);
                break;
            }
            case 23: {
                this.filter.writeRES_FILT(value);
                break;
            }
            case 24: {
                this.filter.writeMODE_VOL(value);
                break;
            }
        }
    }

    public void mute(int channel, boolean enable) {
        if (channel >= 3) {
            return;
        }
        this.voice[channel].mute(enable);
    }

    public State read_state() {
        State state = new State();
        int i = 0;
        int j = 0;
        while (i < 3) {
            WaveformGenerator wave = this.voice[i].wave;
            EnvelopeGenerator envelope = this.voice[i].envelope;
            state.sid_register[j + 0] = (char)(wave.freq & 0xFF);
            state.sid_register[j + 1] = (char)(wave.freq >> 8);
            state.sid_register[j + 2] = (char)(wave.pw & 0xFF);
            state.sid_register[j + 3] = (char)(wave.pw >> 8);
            state.sid_register[j + 4] = (char)(wave.waveform << 4 | (wave.test != 0 ? 8 : 0) | (wave.ring_mod != 0 ? 4 : 0) | (wave.sync != 0 ? 2 : 0) | (envelope.gate != 0 ? 1 : 0));
            state.sid_register[j + 5] = (char)(envelope.attack << 4 | envelope.decay);
            state.sid_register[j + 6] = (char)(envelope.sustain << 4 | envelope.release);
            ++i;
            j += 7;
        }
        state.sid_register[j++] = (char)(this.filter.fc & 7);
        state.sid_register[j++] = (char)(this.filter.fc >> 3);
        state.sid_register[j++] = (char)(this.filter.res << 4 | this.filter.filt);
        state.sid_register[j++] = (char)((this.filter.voice3off != 0 ? 128 : 0) | this.filter.hp_bp_lp << 4 | this.filter.vol);
        while (j < 29) {
            state.sid_register[j] = (char)this.read(j);
            ++j;
        }
        while (j < 32) {
            state.sid_register[j] = '\u0000';
            ++j;
        }
        state.bus_value = this.bus_value;
        state.bus_value_ttl = this.bus_value_ttl;
        for (i = 0; i < 3; ++i) {
            state.accumulator[i] = this.voice[i].wave.accumulator;
            state.shift_register[i] = this.voice[i].wave.shift_register;
            state.rate_counter[i] = this.voice[i].envelope.rate_counter;
            state.rate_counter_period[i] = this.voice[i].envelope.rate_period;
            state.exponential_counter[i] = this.voice[i].envelope.exponential_counter;
            state.exponential_counter_period[i] = this.voice[i].envelope.exponential_counter_period;
            state.envelope_counter[i] = this.voice[i].envelope.envelope_counter;
            state.envelope_state[i] = this.voice[i].envelope.state;
            state.hold_zero[i] = this.voice[i].envelope.hold_zero;
        }
        return state;
    }

    public void write_state(State state) {
        int i;
        for (i = 0; i <= 24; ++i) {
            this.write(i, state.sid_register[i]);
        }
        this.bus_value = state.bus_value;
        this.bus_value_ttl = state.bus_value_ttl;
        for (i = 0; i < 3; ++i) {
            this.voice[i].wave.accumulator = state.accumulator[i];
            this.voice[i].wave.shift_register = state.shift_register[i];
            this.voice[i].envelope.rate_counter = state.rate_counter[i];
            this.voice[i].envelope.rate_period = state.rate_counter_period[i];
            this.voice[i].envelope.exponential_counter = state.exponential_counter[i];
            this.voice[i].envelope.exponential_counter_period = state.exponential_counter_period[i];
            this.voice[i].envelope.envelope_counter = state.envelope_counter[i];
            this.voice[i].envelope.state = state.envelope_state[i];
            this.voice[i].envelope.hold_zero = state.hold_zero[i];
        }
    }

    public void enable_filter(boolean enable) {
        this.filter.enable_filter(enable);
    }

    public void enable_external_filter(boolean enable) {
        this.extfilt.enable_filter(enable);
    }

    protected double I0(double x) {
        double temp;
        double u;
        double I0e = 1.0E-6;
        int n = 1;
        double sum = u = (double)1;
        double halfx = x / 2.0;
        while ((u *= (temp = halfx / (double)n++) * temp) >= 1.0E-6 * (sum += u)) {
        }
        return sum;
    }

    public boolean set_sampling_parameters(double clock_freq, ISIDDefs.sampling_method method, double sample_freq, double pass_freq, double filter_scale) {
        if ((method == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE || method == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_FAST) && 125.0 * clock_freq / sample_freq >= 16384.0) {
            return false;
        }
        if (pass_freq < 0.0) {
            pass_freq = 20000.0;
            if (2.0 * pass_freq / sample_freq >= 0.9) {
                pass_freq = 0.9 * sample_freq / 2.0;
            }
        } else if (pass_freq > 0.9 * sample_freq / 2.0) {
            return false;
        }
        if (filter_scale < 0.9 || filter_scale > 1.0) {
            return false;
        }
        this.extfilt.set_sampling_parameter(pass_freq);
        this.clock_frequency = clock_freq;
        this.sampling = method;
        this.cycles_per_sample = (int)(clock_freq / sample_freq * 65536.0 + 0.5);
        this.sample_offset = 0;
        this.sample_prev = 0;
        if (method != ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE && method != ISIDDefs.sampling_method.SAMPLE_RESAMPLE_FAST) {
            this.sample = null;
            this.fir = null;
            return true;
        }
        double pi = Math.PI;
        double A = -20.0 * Math.log10(1.52587890625E-5);
        double dw = (1.0 - 2.0 * pass_freq / sample_freq) * Math.PI;
        double wc = (2.0 * pass_freq / sample_freq + 1.0) * Math.PI / 2.0;
        double beta = 0.1102 * (A - 8.7);
        double I0beta = this.I0(beta);
        int N = (int)((A - 7.95) / (2.285 * dw) + 0.5);
        N += N & 1;
        double f_samples_per_cycle = sample_freq / clock_freq;
        double f_cycles_per_sample = clock_freq / sample_freq;
        this.fir_N = (int)((double)N * f_cycles_per_sample) + 1;
        this.fir_N |= 1;
        int res = method == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE ? 285 : 51473;
        int n = (int)Math.ceil(Math.log((double)res / f_cycles_per_sample) / Math.log(2.0));
        this.fir_RES = 1 << n;
        this.fir = null;
        this.fir = new short[this.fir_N * this.fir_RES];
        for (int i = 0; i < this.fir_RES; ++i) {
            int fir_offset = i * this.fir_N + this.fir_N / 2;
            double j_offset = (double)i / (double)this.fir_RES;
            for (int j = -this.fir_N / 2; j <= this.fir_N / 2; ++j) {
                double jx = (double)j - j_offset;
                double wt = wc * jx / f_cycles_per_sample;
                double temp = jx / ((double)this.fir_N / 2.0);
                double Kaiser = Math.abs(temp) <= 1.0 ? this.I0(beta * Math.sqrt(1.0 - temp * temp)) / I0beta : 0.0;
                double sincwt = Math.abs(wt) >= 1.0E-6 ? Math.sin(wt) / wt : 1.0;
                double val = 32768.0 * filter_scale * f_samples_per_cycle * wc / Math.PI * sincwt * Kaiser;
                this.fir[fir_offset + j] = (short)(val + 0.5);
            }
        }
        if (this.sample == null) {
            this.sample = new short[32768];
        }
        for (int j = 0; j < 32768; ++j) {
            this.sample[j] = 0;
        }
        this.sample_index = 0;
        return true;
    }

    public void adjust_sampling_frequency(double sample_freq) {
        this.cycles_per_sample = (int)(this.clock_frequency / sample_freq * 65536.0 + 0.5);
    }

    public void fc_default(FCPoints fcp) {
        this.filter.fc_default(fcp);
    }

    public PointPlotter fc_plotter() {
        return this.filter.fc_plotter();
    }

    public void clock() {
        int i;
        if (--this.bus_value_ttl <= 0) {
            this.bus_value = 0;
            this.bus_value_ttl = 0;
        }
        for (i = 0; i < 3; ++i) {
            this.voice[i].envelope.clock();
        }
        for (i = 0; i < 3; ++i) {
            this.voice[i].wave.clock();
        }
        for (i = 0; i < 3; ++i) {
            this.voice[i].wave.synchronize();
        }
        this.filter.clock(this.voice[0].output(), this.voice[1].output(), this.voice[2].output(), this.ext_in);
        this.extfilt.clock(this.filter.output());
    }

    public void clock(int delta_t) {
        int delta_t_min;
        int i;
        if (delta_t <= 0) {
            return;
        }
        this.bus_value_ttl -= delta_t;
        if (this.bus_value_ttl <= 0) {
            this.bus_value = 0;
            this.bus_value_ttl = 0;
        }
        for (i = 0; i < 3; ++i) {
            this.voice[i].envelope.clock(delta_t);
        }
        for (int delta_t_osc = delta_t; delta_t_osc != 0; delta_t_osc -= delta_t_min) {
            delta_t_min = delta_t_osc;
            for (i = 0; i < 3; ++i) {
                WaveformGenerator wave = this.voice[i].wave;
                if (wave.sync_dest.sync == 0 || wave.freq == 0) continue;
                int freq = wave.freq;
                int accumulator = wave.accumulator;
                int delta_accumulator = ((accumulator & 0x800000) != 0 ? 0x1000000 : 0x800000) - accumulator;
                int delta_t_next = delta_accumulator / freq;
                if (delta_accumulator % freq != 0) {
                    ++delta_t_next;
                }
                if (delta_t_next >= delta_t_min) continue;
                delta_t_min = delta_t_next;
            }
            for (i = 0; i < 3; ++i) {
                this.voice[i].wave.clock(delta_t_min);
            }
            for (i = 0; i < 3; ++i) {
                this.voice[i].wave.synchronize();
            }
        }
        this.filter.clock(delta_t, this.voice[0].output(), this.voice[1].output(), this.voice[2].output(), this.ext_in);
        this.extfilt.clock(delta_t, this.filter.output());
    }

    public int clock(CycleCount delta_t, short[] buf, int n, int interleave) {
        switch (this.sampling) {
            default: {
                return this.clock_fast(delta_t, buf, n, interleave);
            }
            case SAMPLE_INTERPOLATE: {
                return this.clock_interpolate(delta_t, buf, n, interleave);
            }
            case SAMPLE_RESAMPLE_INTERPOLATE: {
                return this.clock_resample_interpolate(delta_t, buf, n, interleave);
            }
            case SAMPLE_RESAMPLE_FAST: 
        }
        return this.clock_resample_fast(delta_t, buf, n, interleave);
    }

    protected int clock_fast(CycleCount delta_t, short[] buf, int n, int interleave) {
        int next_sample_offset;
        int delta_t_sample;
        int s = 0;
        while ((delta_t_sample = (next_sample_offset = this.sample_offset + this.cycles_per_sample + 32768) >> 16) <= delta_t.delta_t) {
            if (s >= n) {
                return s;
            }
            this.clock(delta_t_sample);
            delta_t.delta_t -= delta_t_sample;
            this.sample_offset = (next_sample_offset & 0xFFFF) - 32768;
            buf[s++ * interleave] = (short)this.output();
        }
        this.clock(delta_t.delta_t);
        this.sample_offset -= delta_t.delta_t << 16;
        delta_t.delta_t = 0;
        return s;
    }

    protected int clock_interpolate(CycleCount delta_t, short[] buf, int n, int interleave) {
        int i;
        int next_sample_offset;
        int delta_t_sample;
        int s = 0;
        while ((delta_t_sample = (next_sample_offset = this.sample_offset + this.cycles_per_sample) >> 16) <= delta_t.delta_t) {
            if (s >= n) {
                return s;
            }
            for (i = 0; i < delta_t_sample - 1; ++i) {
                this.clock();
            }
            if (i < delta_t_sample) {
                this.sample_prev = (short)this.output();
                this.clock();
            }
            delta_t.delta_t -= delta_t_sample;
            this.sample_offset = next_sample_offset & 0xFFFF;
            short sample_now = (short)this.output();
            buf[s++ * interleave] = (short)(this.sample_prev + (this.sample_offset * (sample_now - this.sample_prev) >> 16));
            this.sample_prev = sample_now;
        }
        for (i = 0; i < delta_t.delta_t - 1; ++i) {
            this.clock();
        }
        if (i < delta_t.delta_t) {
            this.sample_prev = (short)this.output();
            this.clock();
        }
        this.sample_offset -= delta_t.delta_t << 16;
        delta_t.delta_t = 0;
        return s;
    }

    protected int clock_resample_interpolate(CycleCount delta_t, short[] buf, int n, int interleave) {
        int next_sample_offset;
        int delta_t_sample;
        int s = 0;
        while ((delta_t_sample = (next_sample_offset = this.sample_offset + this.cycles_per_sample) >> 16) <= delta_t.delta_t) {
            if (s >= n) {
                return s;
            }
            for (int i = 0; i < delta_t_sample; ++i) {
                this.clock();
                short s2 = (short)this.output();
                this.sample[this.sample_index + 16384] = s2;
                this.sample[this.sample_index] = s2;
                ++this.sample_index;
                this.sample_index &= 0x3FFF;
            }
            delta_t.delta_t -= delta_t_sample;
            this.sample_offset = next_sample_offset & 0xFFFF;
            int fir_offset = this.sample_offset * this.fir_RES >> 16;
            int fir_offset_rmd = this.sample_offset * this.fir_RES & 0xFFFF;
            int fir_start = fir_offset * this.fir_N;
            int sample_start = this.sample_index - this.fir_N + 16384;
            int v1 = 0;
            for (int j = 0; j < this.fir_N; ++j) {
                v1 += this.sample[sample_start + j] * this.fir[fir_start + j];
            }
            if (++fir_offset == this.fir_RES) {
                fir_offset = 0;
                --sample_start;
            }
            fir_start = fir_offset * this.fir_N;
            int v2 = 0;
            for (int j = 0; j < this.fir_N; ++j) {
                v2 += this.sample[sample_start + j] * this.fir[fir_start + j];
            }
            int v = v1 + (fir_offset_rmd * (v2 - v1) >> 16);
            int half = 32768;
            if ((v >>= 15) >= 32768) {
                v = Short.MAX_VALUE;
            } else if (v < Short.MIN_VALUE) {
                v = Short.MIN_VALUE;
            }
            buf[s++ * interleave] = (short)v;
        }
        for (int i = 0; i < delta_t.delta_t; ++i) {
            this.clock();
            short s3 = (short)this.output();
            this.sample[this.sample_index + 16384] = s3;
            this.sample[this.sample_index] = s3;
            ++this.sample_index;
            this.sample_index &= 0x3FFF;
        }
        this.sample_offset -= delta_t.delta_t << 16;
        delta_t.delta_t = 0;
        return s;
    }

    protected int clock_resample_fast(CycleCount delta_t, short[] buf, int n, int interleave) {
        int next_sample_offset;
        int delta_t_sample;
        int s = 0;
        while ((delta_t_sample = (next_sample_offset = this.sample_offset + this.cycles_per_sample) >> 16) <= delta_t.delta_t) {
            if (s >= n) {
                return s;
            }
            for (int i = 0; i < delta_t_sample; ++i) {
                this.clock();
                short s2 = (short)this.output();
                this.sample[this.sample_index + 16384] = s2;
                this.sample[this.sample_index] = s2;
                ++this.sample_index;
                this.sample_index &= 0x3FFF;
            }
            delta_t.delta_t -= delta_t_sample;
            this.sample_offset = next_sample_offset & 0xFFFF;
            int fir_offset = this.sample_offset * this.fir_RES >> 16;
            int fir_start = fir_offset * this.fir_N;
            int sample_start = this.sample_index - this.fir_N + 16384;
            int v = 0;
            for (int j = 0; j < this.fir_N; ++j) {
                v += this.sample[sample_start + j] * this.fir[fir_start + j];
            }
            int half = 32768;
            if ((v >>= 15) >= 32768) {
                v = Short.MAX_VALUE;
            } else if (v < Short.MIN_VALUE) {
                v = Short.MIN_VALUE;
            }
            buf[s++ * interleave] = (short)v;
        }
        for (int i = 0; i < delta_t.delta_t; ++i) {
            this.clock();
            short s3 = (short)this.output();
            this.sample[this.sample_index + 16384] = s3;
            this.sample[this.sample_index] = s3;
            ++this.sample_index;
            this.sample_index &= 0x3FFF;
        }
        this.sample_offset -= delta_t.delta_t << 16;
        delta_t.delta_t = 0;
        return s;
    }

    public static class CycleCount {
        public int delta_t;

        public CycleCount(int delta_t2) {
            this.delta_t = delta_t2;
        }
    }

    public static class FCPoints {
        public int[][] points;
        public int count;
    }

    public static class State {
        public char[] sid_register = new char[32];
        public int bus_value;
        public int bus_value_ttl;
        public int[] accumulator = new int[3];
        public int[] shift_register = new int[3];
        public int[] rate_counter = new int[3];
        public int[] rate_counter_period = new int[3];
        public int[] exponential_counter = new int[3];
        public int[] exponential_counter_period = new int[3];
        int[] envelope_counter = new int[3];
        public EnvelopeGenerator.State[] envelope_state = new EnvelopeGenerator.State[3];
        public boolean[] hold_zero = new boolean[3];

        public State() {
            int i;
            for (i = 0; i < 32; ++i) {
                this.sid_register[i] = '\u0000';
            }
            this.bus_value = 0;
            this.bus_value_ttl = 0;
            for (i = 0; i < 3; ++i) {
                this.accumulator[i] = 0;
                this.shift_register[i] = 0x7FFFF8;
                this.rate_counter[i] = 0;
                this.rate_counter_period[i] = 9;
                this.exponential_counter[i] = 0;
                this.exponential_counter_period[i] = 1;
                this.envelope_counter[i] = 0;
                this.envelope_state[i] = EnvelopeGenerator.State.RELEASE;
                this.hold_zero[i] = true;
            }
        }
    }
}

