/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.process;

import com.spacekiller.util.process.ProcessInfo;
import com.spacekiller.util.process.ProcessListener;
import com.spacekiller.util.process.ProcessManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProcessManager
implements ProcessManager {
    private List processInfoList = new ArrayList();
    private transient List processListeners;
    private static final Logger logger = Logger.getLogger(DefaultProcessManager.class.getName());

    @Override
    public synchronized void addProcessInfo(ProcessInfo process) {
        if (process == null) {
            return;
        }
        this.processInfoList.add(process);
        this.fireProcessAdded(process);
        this.fireProcessStarted(process);
        ProcessWrapper wrapper = new ProcessWrapper(process);
        new Thread(wrapper).start();
    }

    @Override
    public ProcessInfo getProcessInfoAt(int i) {
        return (ProcessInfo)this.processInfoList.get(i);
    }

    @Override
    public int getProcessInfoCount() {
        return this.processInfoList.size();
    }

    @Override
    public ProcessInfo[] getProcessInfos() {
        return this.processInfoList.toArray(new ProcessInfo[this.processInfoList.size()]);
    }

    @Override
    public synchronized void removeProcessInfo(ProcessInfo process) {
        this.processInfoList.remove(process);
        this.fireProcessRemoved(process);
    }

    protected void fireProcessAdded(ProcessInfo p) {
        if (this.processListeners == null) {
            return;
        }
        int currentSize = this.processListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ProcessListener ls = (ProcessListener)this.processListeners.get(index);
            if (ls == null) continue;
            ls.processAdded(p);
        }
    }

    protected void fireProcessStarted(ProcessInfo p) {
        if (this.processListeners == null) {
            return;
        }
        int currentSize = this.processListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ProcessListener ls = (ProcessListener)this.processListeners.get(index);
            if (ls == null) continue;
            ls.processStarted(p);
        }
    }

    protected void fireProcessStopped(ProcessInfo p) {
        if (this.processListeners == null) {
            return;
        }
        int currentSize = this.processListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ProcessListener ls = (ProcessListener)this.processListeners.get(index);
            if (ls == null) continue;
            ls.processStopped(p);
        }
    }

    protected void fireProcessRemoved(ProcessInfo p) {
        if (this.processListeners == null) {
            return;
        }
        int currentSize = this.processListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            ProcessListener ls = (ProcessListener)this.processListeners.get(index);
            if (ls == null) continue;
            ls.processRemoved(p);
        }
    }

    @Override
    public void addProcessListener(ProcessListener listener) {
        if (this.processListeners == null) {
            this.processListeners = new LinkedList();
        }
        this.processListeners.add(listener);
    }

    @Override
    public void removeProcessListener(ProcessListener listener) {
        if (this.processListeners != null) {
            this.processListeners.remove(listener);
        }
    }

    @Override
    public void terminateProcess(ProcessInfo processInfo) {
        if (!processInfo.isRunning()) {
            return;
        }
        Process proc = processInfo.getProcess();
        proc.destroy();
    }

    protected class ProcessWrapper
    implements Runnable {
        private ProcessInfo processInfo;
        private boolean running = false;

        public ProcessWrapper(ProcessInfo processInfo) {
            this.processInfo = processInfo;
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int exitValue = -1;
            try {
                this.running = true;
                this.processInfo.setStatus(1);
                Process proc = this.processInfo.getProcess();
                try {
                    exitValue = proc.waitFor();
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            finally {
                this.running = false;
                this.processInfo.setExitValue(exitValue);
                this.processInfo.setStatus(0);
                DefaultProcessManager.this.fireProcessStopped(this.processInfo);
            }
        }

        protected boolean isRunning() {
            return this.running;
        }
    }
}

