/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.process;

import com.spacekiller.util.process.ProcessInfo;
import com.spacekiller.util.process.ProcessListener;
import com.spacekiller.util.process.ProcessManager;
import com.spacekiller.util.process.ProcessTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class ProcessTableViewer
extends JPanel {
    private static final long serialVersionUID = -6401128376629232774L;
    private ProcessTableModel model;
    private ProcessManager processManager;
    private ProcessHandler processHandler = new ProcessHandler();
    private ProcessPublisher publisher = new ProcessPublisher();
    private ProcessRemover remover = new ProcessRemover();
    private JScrollPane jScrollPane = null;
    private JTable jTableExec = null;
    private boolean autoScroll = true;
    private boolean autoRemove = true;
    private List toRemove = new ArrayList();
    private JToolBar jToolBar = null;
    private JButton jButtonStop = null;
    private JToggleButton jToggleButtonHold = null;
    private JPanel jPanel = null;
    private JToggleButton jToggleButtonLock = null;

    public ProcessTableViewer() {
        this.initialize();
        this.initExecutionTableViewer();
    }

    protected void initExecutionTableViewer() {
        FontMetrics fm;
        this.model = new ProcessTableModel();
        this.getJTableExec().setAutoResizeMode(0);
        this.getJTableExec().setColumnSelectionAllowed(false);
        this.getJTableExec().setRowSelectionAllowed(true);
        this.getJTableExec().setModel(this.model);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        ProcessCellRenderer renderer = new ProcessCellRenderer();
        TableColumn col = new TableColumn(0, 250, renderer, null);
        col.setHeaderValue("Process");
        columnModel.addColumn(col);
        col = new TableColumn(1, 100, renderer, null);
        col.setHeaderValue("Status");
        columnModel.addColumn(col);
        col = new TableColumn(2, 90, renderer, null);
        col.setHeaderValue("Exit code");
        columnModel.addColumn(col);
        this.getJTableExec().setColumnModel(columnModel);
        this.getJTableExec().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProcessTableViewer.this.checkEnable();
            }
        });
        this.getJButtonStop().setEnabled(false);
        Font font = renderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTableExec().getRowMargin();
            this.getJTableExec().setRowHeight(rowHeight);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(382, 262));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJToolBar(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableExec());
        }
        return this.jScrollPane;
    }

    private JTable getJTableExec() {
        if (this.jTableExec == null) {
            this.jTableExec = new JTable();
        }
        return this.jTableExec;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButtonStop());
            this.jToolBar.add(this.getJPanel());
            this.jToolBar.add(this.getJToggleButtonHold());
            this.jToolBar.add(this.getJToggleButtonLock());
        }
        return this.jToolBar;
    }

    private JButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new JButton();
            this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/process/icons/stop_task.gif")));
            this.jButtonStop.setToolTipText("Terminate process");
            this.jButtonStop.setText("");
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProcessTableViewer.this.stop();
                }
            });
        }
        return this.jButtonStop;
    }

    protected void stop() {
        int c;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        ProcessInfo[] exec = new ProcessInfo[num];
        for (c = 0; c < num; ++c) {
            int row = rows[c];
            exec[c] = this.model.getProcessInfoAt(row);
        }
        for (c = 0; c < num; ++c) {
            this.getProcessManager().terminateProcess(exec[c]);
        }
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public synchronized void setProcessManager(ProcessManager newManager) {
        if (this.processManager != null) {
            this.processManager.removeProcessListener(this.processHandler);
        }
        this.processManager = newManager;
        this.model.clear();
        if (this.processManager != null) {
            ProcessInfo[] infos = this.processManager.getProcessInfos();
            if (infos != null) {
                for (int c = 0; c < infos.length; ++c) {
                    this.model.addProcessInfo(infos[c]);
                }
            }
            this.processManager.addProcessListener(this.processHandler);
        }
    }

    public synchronized void dispose() {
        if (this.processManager != null) {
            this.processManager.removeProcessListener(this.processHandler);
        }
        this.processManager = null;
        this.model.clear();
    }

    protected void refresh() {
        this.getJTableExec().repaint();
    }

    private JToggleButton getJToggleButtonHold() {
        if (this.jToggleButtonHold == null) {
            this.jToggleButtonHold = new JToggleButton();
            this.jToggleButtonHold.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/process/icons/clear_log.gif")));
            this.jToggleButtonHold.setToolTipText("Hold completed processes");
            this.jToggleButtonHold.setSelected(false);
            this.jToggleButtonHold.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProcessTableViewer.this.setAutoRemove(!ProcessTableViewer.this.getJToggleButtonHold().isSelected());
                    if (ProcessTableViewer.this.autoRemove) {
                        ProcessTableViewer.this.removeCompletedTasks();
                    }
                }
            });
        }
        return this.jToggleButtonHold;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setSize(new Dimension(10, 10));
            this.jPanel.setOpaque(false);
            this.jPanel.setMaximumSize(new Dimension(10, 10));
        }
        return this.jPanel;
    }

    private JToggleButton getJToggleButtonLock() {
        if (this.jToggleButtonLock == null) {
            this.jToggleButtonLock = new JToggleButton();
            this.jToggleButtonLock.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/process/icons/lock.gif")));
            this.jToggleButtonLock.setToolTipText("Lock scroll position");
            this.jToggleButtonLock.setSelected(false);
            this.jToggleButtonLock.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProcessTableViewer.this.setAutoScroll(!ProcessTableViewer.this.getJToggleButtonLock().isSelected());
                }
            });
        }
        return this.jToggleButtonLock;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    protected void removeCompletedTasks() {
        Object[] tasks = this.toRemove.toArray();
        this.toRemove.clear();
        int num = tasks.length;
        for (int c = 0; c < num; ++c) {
            ProcessInfo exec = (ProcessInfo)tasks[c];
            this.model.removeProcessInfo(exec);
        }
    }

    protected void checkEnable() {
        boolean enableStop = false;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        if (num > 0) {
            enableStop = true;
            for (int c = 0; c < num; ++c) {
                int row = rows[c];
                ProcessInfo exec = this.model.getProcessInfoAt(row);
                if (exec == null || exec.isRunning()) continue;
                enableStop = false;
            }
        }
        this.getJButtonStop().setEnabled(enableStop);
    }

    protected class ProcessCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2927552725730321970L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int v;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = null;
            TableColumn col = table.getColumnModel().getColumn(column);
            int colIndex = col.getModelIndex();
            if (colIndex == 1 && value instanceof Integer) {
                v = (Integer)value;
                switch (v) {
                    case 1: {
                        this.setText("running");
                        break;
                    }
                    case 0: {
                        this.setText("");
                    }
                }
            }
            if (colIndex == 2 && value != null && value instanceof Integer) {
                v = (Integer)value;
                this.setText("" + v);
            }
            this.setIcon(icon);
            return this;
        }
    }

    protected class ProcessRemover
    implements Runnable {
        private LinkedList listAdd = new LinkedList();
        private LinkedList listAdd2 = new LinkedList();
        private boolean todo = false;

        protected ProcessRemover() {
        }

        public synchronized void add(ProcessInfo x) {
            this.listAdd.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList l = this.listAdd;
            ProcessRemover processRemover = this;
            synchronized (processRemover) {
                this.listAdd = this.listAdd2;
                this.listAdd2 = l;
                this.todo = false;
            }
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ProcessInfo rec = (ProcessInfo)i.next();
                i.remove();
                ProcessTableViewer.this.model.removeProcessInfo(rec);
            }
            ProcessTableViewer.this.checkEnable();
        }
    }

    protected class ProcessPublisher
    implements Runnable {
        private LinkedList listAdd = new LinkedList();
        private LinkedList listAdd2 = new LinkedList();
        private boolean todo = false;

        protected ProcessPublisher() {
        }

        public synchronized void add(ProcessInfo x) {
            this.listAdd.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList l = this.listAdd;
            ProcessPublisher processPublisher = this;
            synchronized (processPublisher) {
                this.listAdd = this.listAdd2;
                this.listAdd2 = l;
                this.todo = false;
            }
            int row = -1;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ProcessInfo rec = (ProcessInfo)i.next();
                i.remove();
                row = ProcessTableViewer.this.model.getRowCount();
                ProcessTableViewer.this.model.addProcessInfo(rec);
            }
            if (row >= 0 && ProcessTableViewer.this.autoScroll) {
                Rectangle rect = ProcessTableViewer.this.getJTableExec().getCellRect(row, 0, true);
                ProcessTableViewer.this.getJTableExec().scrollRectToVisible(rect);
            }
            ProcessTableViewer.this.checkEnable();
        }
    }

    protected class ProcessHandler
    implements ProcessListener {
        protected ProcessHandler() {
        }

        @Override
        public void processAdded(ProcessInfo p) {
        }

        @Override
        public void processStarted(ProcessInfo p) {
            ProcessTableViewer.this.publisher.add(p);
        }

        @Override
        public void processStopped(ProcessInfo p) {
            if (ProcessTableViewer.this.autoRemove) {
                ProcessTableViewer.this.remover.add(p);
            } else {
                ProcessTableViewer.this.toRemove.add(p);
            }
        }

        @Override
        public void processRemoved(ProcessInfo p) {
        }
    }
}

