/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceListener;
import com.spacekiller.util.service.ServiceManager;
import com.spacekiller.util.service.ServiceProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultServiceManager
implements ServiceManager {
    private List providers;
    private List services;
    private ServiceHandler serviceHandler = new ServiceHandler();
    private ListenerList<ServiceListener> serviceListeners;

    public DefaultServiceManager() {
        this.providers = new ArrayList();
        this.services = new ArrayList();
        this.serviceListeners = new ListenerList(ServiceListener.class);
    }

    @Override
    public Service getService(String name) {
        if (name == null) {
            return null;
        }
        for (Service s : this.services) {
            if (!name.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    @Override
    public Service getServiceAt(int i) {
        return (Service)this.services.get(i);
    }

    @Override
    public int getServiceCount() {
        return this.services.size();
    }

    public int getProviderCount() {
        return this.providers.size();
    }

    @Override
    public void addServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.add((Object)l);
    }

    @Override
    public void removeServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.remove((Object)l);
    }

    @Override
    public void registerServiceProvider(ServiceProvider sp) {
        if (sp == null) {
            return;
        }
        if (this.providers.contains(sp)) {
            return;
        }
        this.providers.add(sp);
        Iterator i = sp.getServices();
        if (i != null) {
            while (i.hasNext()) {
                Service s = (Service)i.next();
                this.handleServiceAdded(s);
            }
        }
        sp.addServiceListener(this.serviceHandler);
    }

    @Override
    public void unregisterServiceProvider(ServiceProvider sp) {
        if (this.providers.remove(sp)) {
            sp.removeServiceListener(this.serviceHandler);
            Iterator i = sp.getServices();
            if (i != null) {
                while (i.hasNext()) {
                    Service s = (Service)i.next();
                    this.handleServiceRemoved(s);
                }
            }
        }
    }

    protected void handleServiceAdded(Service s) {
        if (this.services.add(s)) {
            s.addServiceListener(this.serviceHandler);
            this.fireServiceAdded(s);
        }
    }

    protected void handleServiceRemoved(Service s) {
        if (this.services.remove(s)) {
            s.removeServiceListener(this.serviceHandler);
            this.fireServiceRemoved(s);
        }
    }

    protected void handleServiceStarted(Service service) {
        this.fireServiceStarted(service);
    }

    protected void handleServiceStarting(Service service) {
        this.fireServiceStarting(service);
    }

    protected void handleServiceStopped(Service service) {
        this.fireServiceStopped(service);
    }

    protected void handleServiceStopping(Service service) {
        this.fireServiceStopping(service);
    }

    protected synchronized void fireServiceAdded(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceAdded(s);
        }
    }

    protected synchronized void fireServiceRemoved(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceRemoved(s);
        }
    }

    protected synchronized void fireServiceStarted(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStarted(s);
        }
    }

    protected synchronized void fireServiceStopped(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStopped(s);
        }
    }

    protected synchronized void fireServiceStarting(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStarting(s);
        }
    }

    protected synchronized void fireServiceStopping(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStopping(s);
        }
    }

    protected class ServiceHandler
    implements ServiceListener {
        protected ServiceHandler() {
        }

        @Override
        public void serviceAdded(Service service) {
            DefaultServiceManager.this.handleServiceAdded(service);
        }

        @Override
        public void serviceRemoved(Service service) {
            DefaultServiceManager.this.handleServiceRemoved(service);
        }

        @Override
        public void serviceStarted(Service service) {
            DefaultServiceManager.this.handleServiceStarted(service);
        }

        @Override
        public void serviceStarting(Service service) {
            DefaultServiceManager.this.handleServiceStarting(service);
        }

        @Override
        public void serviceStopped(Service service) {
            DefaultServiceManager.this.handleServiceStopped(service);
        }

        @Override
        public void serviceStopping(Service service) {
            DefaultServiceManager.this.handleServiceStopping(service);
        }

        @Override
        public void serviceUpdated(Service service) {
        }
    }
}

