/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Preferences;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPreferences
implements Preferences {
    protected Map<String, Object> map;

    protected AbstractPreferences() {
        this(new HashMap<String, Object>());
    }

    protected AbstractPreferences(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public synchronized String[] propertyNames() {
        Set<String> set = this.map.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public synchronized boolean contains(String key) {
        return this.map.containsKey(key);
    }

    protected abstract IllegalArgumentException getFailed(String var1, Object var2, Class var3);

    @Override
    public synchronized boolean getBoolean(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                return Boolean.parseBoolean((String)o);
            }
        }
        throw this.getFailed(key, o, Boolean.TYPE);
    }

    @Override
    public synchronized void setBoolean(String key, boolean value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized byte getByte(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Byte) {
                return (Byte)o;
            }
            if (o instanceof String) {
                return Byte.parseByte(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Byte.TYPE);
    }

    @Override
    public synchronized void setByte(String key, byte value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized char getChar(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            String s;
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            if (o instanceof String && (s = (String)o).length() > 0) {
                return s.charAt(0);
            }
        }
        throw this.getFailed(key, o, Character.TYPE);
    }

    @Override
    public synchronized void setChar(String key, char value) {
        this.setObject(key, Character.valueOf(value));
    }

    @Override
    public synchronized short getShort(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Short) {
                return (Short)o;
            }
            if (o instanceof String) {
                return Short.parseShort(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Short.TYPE);
    }

    @Override
    public synchronized void setShort(String key, short value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized int getInt(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof String) {
                return Integer.parseInt(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Integer.TYPE);
    }

    @Override
    public synchronized void setInt(String key, int value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized long getLong(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Long) {
                return (Long)o;
            }
            if (o instanceof String) {
                return Long.parseLong(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Long.TYPE);
    }

    @Override
    public synchronized void setLong(String key, long value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized float getFloat(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Float) {
                return ((Float)o).floatValue();
            }
            if (o instanceof String) {
                return Float.parseFloat(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Float.TYPE);
    }

    @Override
    public synchronized void setFloat(String key, float value) {
        this.setObject(key, Float.valueOf(value));
    }

    @Override
    public synchronized double getDouble(String key) {
        Object o = this.map.get(key);
        if (o != null) {
            if (o instanceof Double) {
                return (Double)o;
            }
            if (o instanceof String) {
                return Double.parseDouble(((String)o).trim());
            }
        }
        throw this.getFailed(key, o, Double.TYPE);
    }

    @Override
    public synchronized void setDouble(String key, double value) {
        this.setObject(key, value);
    }

    @Override
    public synchronized Object getObject(String key) {
        return this.map.get(key);
    }

    @Override
    public synchronized void setObject(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    protected synchronized void clear() {
        this.map.clear();
    }
}

