/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.Data;
import com.spacekiller.util.Parameter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public abstract class ConfigInjector {
    private ClassLoader classLoader;

    public ConfigInjector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object create(ConfigNode node) throws Exception {
        String type = node.getType();
        if (type != null && type.length() < 1) {
            type = null;
        }
        Class<?> clazz = null;
        String cname = node.getClassName();
        if (cname != null && cname.length() > 0) {
            int dims = 0;
            while (cname.endsWith("[]")) {
                cname = cname.substring(0, cname.length() - 2);
                ++dims;
            }
            clazz = this.classLoader.loadClass(cname);
            if (dims > 0) {
                return this.createArray(node, clazz, dims);
            }
        }
        Object rc = node.getValue();
        String extension = node.getExtension();
        String bean = node.getBean();
        if (extension != null) {
            rc = this.lookupExtension(node, extension);
        } else if (bean != null) {
            rc = this.lookupBean(node, bean);
        } else if (type != null) {
            rc = this.createTypeBean(node, type, rc);
        } else if (clazz != null) {
            rc = this.createClassBean(node, clazz);
        }
        return rc;
    }

    public void inject(ConfigNode node, Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (int c = 0; c < props.length; ++c) {
            map.put(props[c].getName(), props[c]);
        }
        int num = node.getChildCount();
        for (int c = 0; c < num; ++c) {
            String cn;
            ConfigNode child = node.getChildAt(c);
            if (child == null || (cn = child.getName()) == null) continue;
            PropertyDescriptor prop = (PropertyDescriptor)map.get(cn);
            if (prop == null) {
                throw new Exception("Bean property not found: " + clazz + ": " + cn);
            }
            Method writer = prop.getWriteMethod();
            if (writer == null) {
                throw new Exception("Bean property has no setter method: " + clazz + ".set: " + cn);
            }
            Object val = this.create(child);
            if (val != null) {
                this.inject(child, val);
            }
            writer.invoke(bean, val);
        }
    }

    protected Object createClassBean(ConfigNode node, Class clazz) throws Exception {
        int paramCount = node.getParameterCount();
        Class[] paramTypes = new Class[paramCount];
        Object[] paramValues = new Object[paramCount];
        for (int p = 0; p < paramCount; ++p) {
            Parameter param = node.getParameterAt(p);
            paramTypes[p] = param.getType();
            paramValues[p] = param.getValue();
        }
        Constructor constr = clazz.getConstructor(paramTypes);
        Object bean = constr.newInstance(paramValues);
        return bean;
    }

    protected Object createTypeBean(ConfigNode node, String type, Object value) throws Exception {
        if (type.equals("icon")) {
            URL url;
            String resource = String.valueOf(value);
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if ((url = this.classLoader.getResource(resource)) == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        if (type.equals("string") || type.equals("java.lang.String")) {
            return String.valueOf(value);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("byte")) {
            return Byte.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("char")) {
            String s = String.valueOf(value).trim();
            if (s.length() > 0) {
                return Data.toCharacter(s.charAt(0));
            }
            return null;
        }
        if (type.equals("short")) {
            return Short.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("int")) {
            return Integer.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("int")) {
            return Integer.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("long")) {
            return Long.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("float")) {
            return Float.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("double")) {
            return Double.valueOf(String.valueOf(value).trim());
        }
        if (type.equals("class") || type.equals("java.lang.Class")) {
            return this.classLoader.loadClass(String.valueOf(value).trim());
        }
        throw new Exception("Unsupported type: " + type);
    }

    protected Object createArray(ConfigNode node, Class clazz, int dimensions) throws Exception {
        int num = node.getChildCount();
        int[] dim = new int[dimensions];
        dim[0] = num;
        Object array = Array.newInstance(clazz, dim);
        for (int c = 0; c < num; ++c) {
            ConfigNode child = node.getChildAt(c);
            if (child == null) continue;
            Object val = this.create(child);
            if (val != null) {
                this.inject(child, val);
            }
            Array.set(array, c, val);
        }
        return array;
    }

    protected abstract Object lookupExtension(ConfigNode var1, String var2) throws Exception;

    protected abstract Object lookupBean(ConfigNode var1, String var2) throws Exception;
}

