/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.ConfigNode;
import com.spacekiller.util.Parameter;
import java.util.ArrayList;
import java.util.List;

public class DefaultConfigNode
implements ConfigNode {
    private String name;
    private String type;
    private String className;
    private Object value;
    private String extension;
    private String bean;
    private List parameters;
    private List children;

    public DefaultConfigNode() {
    }

    public DefaultConfigNode(String name, String type, String className, Object value, String extension, String bean) {
        this.setName(name);
        this.setType(type);
        this.setClassName(className);
        this.setValue(value);
        this.setExtension(extension);
        this.setBean(bean);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassName(Class clazz) {
        if (clazz.isArray()) {
            this.setClassName(clazz.getComponentType().getName() + "[]");
        } else {
            this.setClassName(clazz.getName());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public ConfigNode getChildAt(int index) {
        return (ConfigNode)this.children.get(index);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    protected List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public void addChild(ConfigNode def) {
        this.getChildren().add(def);
    }

    public void addChild(String name, String value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(value);
        this.addChild(def);
    }

    public void addChild(String name, boolean value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(String.valueOf(value));
        def.setType("boolean");
        this.addChild(def);
    }

    public void addChild(String name, int value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(String.valueOf(value));
        def.setType("int");
        this.addChild(def);
    }

    public void addChild(String name, long value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(String.valueOf(value));
        def.setType("long");
        this.addChild(def);
    }

    public void addChild(String name, float value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(String.valueOf(value));
        def.setType("float");
        this.addChild(def);
    }

    public void addChild(String name, double value) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(String.valueOf(value));
        def.setType("double");
        this.addChild(def);
    }

    public void addChild(String name, String value, String type) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setName(name);
        def.setValue(value);
        def.setType(type);
        this.addChild(def);
    }

    public void addExtension(String extension) {
        DefaultConfigNode def = new DefaultConfigNode();
        def.setExtension(extension);
        this.addChild(def);
    }

    public void insertChildAt(ConfigNode def, int i) {
        this.getChildren().add(i, def);
    }

    public void removeChild(ConfigNode def) {
        if (this.children != null) {
            this.children.remove(def);
        }
    }

    protected void toString(StringBuffer buf) {
        buf.append("name=" + this.name);
        if (this.type != null) {
            buf.append(", type=" + this.type);
        }
        if (this.className != null) {
            buf.append(", class=" + this.className);
        }
        int num = this.getChildCount();
        if (this.value != null || num < 1) {
            buf.append(", value=" + this.value);
        }
        if (num > 0) {
            buf.append(", children=[{");
            for (int c = 0; c < num; ++c) {
                if (c > 0) {
                    buf.append("}, {");
                }
                ConfigNode ch = this.getChildAt(c);
                buf.append(String.valueOf(ch));
            }
            buf.append("}]");
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        this.toString(sbuf);
        return sbuf.toString();
    }

    @Override
    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    @Override
    public Parameter getParameterAt(int i) {
        return (Parameter)this.parameters.get(i);
    }

    public void addParameter(Parameter param) {
        if (param != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList();
            }
            this.parameters.add(param);
        }
    }

    public void removeParameter(Parameter param) {
        if (this.parameters != null) {
            this.parameters.remove(param);
        }
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }
}

