/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.FileLink;
import com.spacekiller.util.Tools;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class DefaultFileLink
implements FileLink,
Serializable {
    private static final long serialVersionUID = -3074037306548854267L;
    private String path;

    public DefaultFileLink(String path) {
        this.path = path;
    }

    public DefaultFileLink(File file) {
        this.path = file.getPath();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.getFile().getName();
    }

    @Override
    public File getFile() {
        return new File(this.path);
    }

    @Override
    public URI getURI() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return Tools.getFileURI(file);
    }

    @Override
    public URL getURL() throws MalformedURLException {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return Tools.getFileURL(file);
    }

    public String toString() {
        return super.toString() + "[" + this.path + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultFileLink) {
            DefaultFileLink link = (DefaultFileLink)obj;
            return this.path.equals(link.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

