/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public final class FileResource
implements Resource {
    private final File file;

    public FileResource(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return this.file.toString();
    }

    public int hashCode() {
        File f = this.file;
        return f == null ? 0 : f.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != FileResource.class) {
            return false;
        }
        FileResource r = (FileResource)obj;
        return this.file.equals(r.getFile());
    }
}

