/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util;

import com.spacekiller.util.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public final class URLResource
implements Resource {
    private final URL url;

    public URLResource(URL url) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public URI getURI() throws IOException, URISyntaxException {
        return new URI(this.url.toString());
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    public String toString() {
        return this.url.toString();
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != URLResource.class) {
            return false;
        }
        URLResource r = (URLResource)obj;
        return this.url.equals(r.getURL());
    }
}

