/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class MicrosecondsPerUnit
extends AbstractTimeUnit {
    protected static final double SECONDS = 1.0E-6;
    protected static final double MILLIS = 0.001;
    protected static final long MICROS = 1L;
    protected static final long NANOS = 1000L;

    public MicrosecondsPerUnit(double perUnit) {
        super(1.0 / perUnit / 1.0E-6, 1.0 / perUnit / 0.001, 1.0 / perUnit, 1.0 / perUnit / 1000.0, perUnit * 1.0E-6, perUnit * 0.001, perUnit, perUnit * 1000.0);
    }

    public String toString() {
        return Double.toString(this.microsecondsPerUnit) + " microseconds/unit";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.microsecondsPerUnit);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof MicrosecondsPerUnit && Double.doubleToLongBits(((MicrosecondsPerUnit)obj).microsecondsPerUnit) == Double.doubleToLongBits(this.microsecondsPerUnit);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.microsecondsPerUnit, u.microsecondsPerUnit);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.microsecondsPerUnit, u.microsecondsPerUnit());
    }

    public double secondsForUnits(double units) {
        return units * this.microsecondsPerUnit * 1.0E-6;
    }

    public double secondsForUnits(long units) {
        return (double)units * this.microsecondsPerUnit * 1.0E-6;
    }

    public double millisecondsForUnits(double units) {
        return units * this.microsecondsPerUnit * 0.001;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * this.microsecondsPerUnit * 0.001;
    }

    public double microsecondsForUnits(double units) {
        return units * this.microsecondsPerUnit;
    }

    public double microsecondsForUnits(long units) {
        return (double)units * this.microsecondsPerUnit;
    }

    public double nanosecondsForUnits(double units) {
        return units * this.microsecondsPerUnit * 1000.0;
    }

    public double nanosecondsForUnits(long units) {
        return (double)units * this.microsecondsPerUnit * 1000.0;
    }

    public double unitsForSeconds(double seconds) {
        return seconds / 1.0E-6 / this.microsecondsPerUnit;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds / 1.0E-6 / this.microsecondsPerUnit;
    }

    public double unitsForMilliseconds(double millis) {
        return millis / 0.001 / this.microsecondsPerUnit;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis / 0.001 / this.microsecondsPerUnit;
    }

    public double unitsForMicroseconds(double micros) {
        return micros / this.microsecondsPerUnit;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros / this.microsecondsPerUnit;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos / this.microsecondsPerUnit / 1000.0;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos / this.microsecondsPerUnit / 1000.0;
    }
}

