/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class MillisecondsPerUnit
extends AbstractTimeUnit {
    protected static final double SECONDS = 0.001;
    protected static final long MILLIS = 1L;
    protected static final long MICROS = 1000L;
    protected static final long NANOS = 1000000L;

    public MillisecondsPerUnit(double perUnit) {
        super(1.0 / perUnit / 0.001, 1.0 / perUnit, 1.0 / perUnit / 1000.0, 1.0 / perUnit / 1000000.0, perUnit * 0.001, perUnit, perUnit * 1000.0, perUnit * 1000000.0);
    }

    public String toString() {
        return Double.toString(this.millisecondsPerUnit) + " milliseconds/unit";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.millisecondsPerUnit);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof MillisecondsPerUnit && Double.doubleToLongBits(((MillisecondsPerUnit)obj).millisecondsPerUnit) == Double.doubleToLongBits(this.millisecondsPerUnit);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.millisecondsPerUnit, u.millisecondsPerUnit);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.millisecondsPerUnit, u.millisecondsPerUnit());
    }

    public double secondsForUnits(double units) {
        return units * this.millisecondsPerUnit * 0.001;
    }

    public double secondsForUnits(long units) {
        return (double)units * this.millisecondsPerUnit * 0.001;
    }

    public double millisecondsForUnits(double units) {
        return units * this.millisecondsPerUnit;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * this.millisecondsPerUnit;
    }

    public double microsecondsForUnits(double units) {
        return units * this.millisecondsPerUnit * 1000.0;
    }

    public double microsecondsForUnits(long units) {
        return (double)units * this.millisecondsPerUnit * 1000.0;
    }

    public double nanosecondsForUnits(double units) {
        return units * this.millisecondsPerUnit * 1000000.0;
    }

    public double nanosecondsForUnits(long units) {
        return (double)units * this.millisecondsPerUnit * 1000000.0;
    }

    public double unitsForSeconds(double seconds) {
        return seconds / 0.001 / this.millisecondsPerUnit;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds / 0.001 / this.millisecondsPerUnit;
    }

    public double unitsForMilliseconds(double millis) {
        return millis / this.millisecondsPerUnit;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis / this.millisecondsPerUnit;
    }

    public double unitsForMicroseconds(double micros) {
        return micros / this.millisecondsPerUnit / 1000.0;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros / this.millisecondsPerUnit / 1000.0;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos / this.millisecondsPerUnit / 1000000.0;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos / this.millisecondsPerUnit / 1000000.0;
    }
}

