/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class NanosecondsPerUnit
extends AbstractTimeUnit {
    protected static final double SECONDS = 1.0E-9;
    protected static final double MILLIS = 1.0E-6;
    protected static final double MICROS = 0.001;
    protected static final long NANOS = 1L;

    public NanosecondsPerUnit(double perUnit) {
        super(1.0 / perUnit / 1.0E-9, 1.0 / perUnit / 1.0E-6, 1.0 / perUnit / 0.001, 1.0 / perUnit, perUnit * 1.0E-9, perUnit * 1.0E-6, perUnit * 0.001, perUnit);
    }

    public String toString() {
        return Double.toString(this.nanosecondsPerUnit) + " nanoseconds/unit";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.nanosecondsPerUnit);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof NanosecondsPerUnit && Double.doubleToLongBits(((NanosecondsPerUnit)obj).nanosecondsPerUnit) == Double.doubleToLongBits(this.nanosecondsPerUnit);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.nanosecondsPerUnit, u.nanosecondsPerUnit);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.nanosecondsPerUnit, u.nanosecondsPerUnit());
    }

    public double secondsForUnits(double units) {
        return units * this.nanosecondsPerUnit * 1.0E-9;
    }

    public double secondsForUnits(long units) {
        return (double)units * this.nanosecondsPerUnit * 1.0E-9;
    }

    public double millisecondsForUnits(double units) {
        return units * this.nanosecondsPerUnit * 1.0E-6;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * this.nanosecondsPerUnit * 1.0E-6;
    }

    public double microsecondsForUnits(double units) {
        return units * this.nanosecondsPerUnit * 0.001;
    }

    public double microsecondsForUnits(long units) {
        return (double)units * this.nanosecondsPerUnit * 0.001;
    }

    public double nanosecondsForUnits(double units) {
        return units * this.nanosecondsPerUnit;
    }

    public double nanosecondsForUnits(long units) {
        return (double)units * this.nanosecondsPerUnit;
    }

    public double unitsForSeconds(double seconds) {
        return seconds / 1.0E-9 / this.nanosecondsPerUnit;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds / 1.0E-9 / this.nanosecondsPerUnit;
    }

    public double unitsForMilliseconds(double millis) {
        return millis / 1.0E-6 / this.nanosecondsPerUnit;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis / 1.0E-6 / this.nanosecondsPerUnit;
    }

    public double unitsForMicroseconds(double micros) {
        return micros / 0.001 / this.nanosecondsPerUnit;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros / 0.001 / this.nanosecondsPerUnit;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos / this.nanosecondsPerUnit;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos / this.nanosecondsPerUnit;
    }
}

