/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class SecondsPerUnit
extends AbstractTimeUnit {
    protected static final long SECONDS = 1L;
    protected static final long MILLIS = 1000L;
    protected static final long MICROS = 1000000L;
    protected static final long NANOS = 1000000000L;

    public SecondsPerUnit(double perUnit) {
        super(1.0 / perUnit, 1.0 / perUnit / 1000.0, 1.0 / perUnit / 1000000.0, 1.0 / perUnit / 1.0E9, perUnit, perUnit * 1000.0, perUnit * 1000000.0, perUnit * 1.0E9);
    }

    public String toString() {
        return Double.toString(this.secondsPerUnit) + " seconds/unit";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.secondsPerUnit);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof SecondsPerUnit && Double.doubleToLongBits(((SecondsPerUnit)obj).secondsPerUnit) == Double.doubleToLongBits(this.secondsPerUnit);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.secondsPerUnit, u.secondsPerUnit);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.secondsPerUnit, u.secondsPerUnit());
    }

    public double secondsForUnits(double units) {
        return units * this.secondsPerUnit;
    }

    public double secondsForUnits(long units) {
        return (double)units * this.secondsPerUnit;
    }

    public double millisecondsForUnits(double units) {
        return units * this.secondsPerUnit * 1000.0;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * this.secondsPerUnit * 1000.0;
    }

    public double microsecondsForUnits(double units) {
        return units * this.secondsPerUnit * 1000000.0;
    }

    public double microsecondsForUnits(long units) {
        return (double)units * this.secondsPerUnit * 1000000.0;
    }

    public double nanosecondsForUnits(double units) {
        return units * this.secondsPerUnit * 1.0E9;
    }

    public double nanosecondsForUnits(long units) {
        return (double)units * this.secondsPerUnit * 1.0E9;
    }

    public double unitsForSeconds(double seconds) {
        return seconds / this.secondsPerUnit;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds / this.secondsPerUnit;
    }

    public double unitsForMilliseconds(double millis) {
        return millis / this.secondsPerUnit / 1000.0;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis / this.secondsPerUnit / 1000.0;
    }

    public double unitsForMicroseconds(double micros) {
        return micros / this.secondsPerUnit / 1000000.0;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros / this.secondsPerUnit / 1000000.0;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos / this.secondsPerUnit / 1.0E9;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos / this.secondsPerUnit / 1.0E9;
    }
}

