/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class UnitsPerMicrosecond
extends AbstractTimeUnit {
    protected static final double SECONDS = 1.0E-6;
    protected static final double MILLIS = 0.001;
    protected static final long MICROS = 1L;
    protected static final long NANOS = 1000L;

    public UnitsPerMicrosecond(double unitsPer) {
        super(unitsPer / 1.0E-6, unitsPer / 0.001, unitsPer, unitsPer / 1000.0, 1.0E-6 / unitsPer, 0.001 / unitsPer, 1.0 / unitsPer, 1000.0 / unitsPer);
    }

    public String toString() {
        return Double.toString(this.unitsPerMicrosecond) + " units/microsecond";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.unitsPerMicrosecond);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof UnitsPerMicrosecond && Double.doubleToLongBits(((UnitsPerMicrosecond)obj).unitsPerMicrosecond) == Double.doubleToLongBits(this.unitsPerMicrosecond);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.unitsPerMicrosecond, u.unitsPerMicrosecond);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.unitsPerMicrosecond, u.unitsPerMicrosecond());
    }

    public double unitsForSeconds(double seconds) {
        return seconds * this.unitsPerMicrosecond / 1.0E-6;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds * this.unitsPerMicrosecond / 1.0E-6;
    }

    public double unitsForMilliseconds(double millis) {
        return millis * this.unitsPerMicrosecond / 0.001;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis * this.unitsPerMicrosecond / 0.001;
    }

    public double unitsForMicroseconds(double micros) {
        return micros * this.unitsPerMicrosecond;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros * this.unitsPerMicrosecond;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos * this.unitsPerMicrosecond / 1000.0;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos * this.unitsPerMicrosecond / 1000.0;
    }

    public double secondsForUnits(double units) {
        return units * 1.0E-6 / this.unitsPerMicrosecond;
    }

    public double secondsForUnits(long units) {
        return (double)units * 1.0E-6 / this.unitsPerMicrosecond;
    }

    public double millisecondsForUnits(double units) {
        return units * 0.001 / this.unitsPerMicrosecond;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * 0.001 / this.unitsPerMicrosecond;
    }

    public double microsecondsForUnits(double units) {
        return units / this.unitsPerMicrosecond;
    }

    public double microsecondsForUnits(long units) {
        return (double)units / this.unitsPerMicrosecond;
    }

    public double nanosecondsForUnits(double units) {
        return units * 1000.0 / this.unitsPerMicrosecond;
    }

    public double nanosecondsForUnits(long units) {
        return (double)(units * 1000L) / this.unitsPerMicrosecond;
    }
}

