/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class UnitsPerMillisecond
extends AbstractTimeUnit {
    protected static final double SECONDS = 0.001;
    protected static final long MILLIS = 1L;
    protected static final long MICROS = 1000L;
    protected static final long NANOS = 1000000L;

    public UnitsPerMillisecond(double unitsPer) {
        super(unitsPer / 0.001, unitsPer, unitsPer / 1000.0, unitsPer / 1000000.0, 0.001 / unitsPer, 1.0 / unitsPer, 1000.0 / unitsPer, 1000000.0 / unitsPer);
    }

    public String toString() {
        return Double.toString(this.unitsPerMillisecond) + " units/millisecond";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.unitsPerMillisecond);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof UnitsPerMillisecond && Double.doubleToLongBits(((UnitsPerMillisecond)obj).unitsPerMillisecond) == Double.doubleToLongBits(this.unitsPerMillisecond);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.unitsPerMillisecond, u.unitsPerMillisecond);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.unitsPerMillisecond, u.unitsPerMillisecond());
    }

    public double unitsForSeconds(double seconds) {
        return seconds * this.unitsPerMillisecond / 0.001;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds * this.unitsPerMillisecond / 0.001;
    }

    public double unitsForMilliseconds(double millis) {
        return millis * this.unitsPerMillisecond;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis * this.unitsPerMillisecond;
    }

    public double unitsForMicroseconds(double micros) {
        return micros * this.unitsPerMillisecond / 1000.0;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros * this.unitsPerMillisecond / 1000.0;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos * this.unitsPerMillisecond / 1000000.0;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos * this.unitsPerMillisecond / 1000000.0;
    }

    public double secondsForUnits(double units) {
        return units * 0.001 / this.unitsPerMillisecond;
    }

    public double secondsForUnits(long units) {
        return (double)units * 0.001 / this.unitsPerMillisecond;
    }

    public double millisecondsForUnits(double units) {
        return units / this.unitsPerMillisecond;
    }

    public double millisecondsForUnits(long units) {
        return (double)units / this.unitsPerMillisecond;
    }

    public double microsecondsForUnits(double units) {
        return units * 1000.0 / this.unitsPerMillisecond;
    }

    public double microsecondsForUnits(long units) {
        return (double)(units * 1000L) / this.unitsPerMillisecond;
    }

    public double nanosecondsForUnits(double units) {
        return units * 1000000.0 / this.unitsPerMillisecond;
    }

    public double nanosecondsForUnits(long units) {
        return (double)(units * 1000000L) / this.unitsPerMillisecond;
    }
}

