/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class UnitsPerNanosecond
extends AbstractTimeUnit {
    protected static final double SECONDS = 1.0E-9;
    protected static final double MILLIS = 1.0E-6;
    protected static final double MICROS = 0.001;
    protected static final long NANOS = 1L;

    public UnitsPerNanosecond(double unitsPer) {
        super(unitsPer / 1.0E-9, unitsPer / 1.0E-6, unitsPer / 0.001, unitsPer, 1.0E-9 / unitsPer, 1.0E-6 / unitsPer, 0.001 / unitsPer, 1.0 / unitsPer);
    }

    public String toString() {
        return Double.toString(this.unitsPerNanosecond) + " units/nanosecond";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.unitsPerNanosecond);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof UnitsPerNanosecond && Double.doubleToLongBits(((UnitsPerNanosecond)obj).unitsPerNanosecond) == Double.doubleToLongBits(this.unitsPerNanosecond);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.unitsPerNanosecond, u.unitsPerNanosecond);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.unitsPerNanosecond, u.unitsPerNanosecond());
    }

    public double unitsForSeconds(double seconds) {
        return seconds * this.unitsPerNanosecond / 1.0E-9;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds * this.unitsPerNanosecond / 1.0E-9;
    }

    public double unitsForMilliseconds(double millis) {
        return millis * this.unitsPerNanosecond / 1.0E-6;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis * this.unitsPerNanosecond / 1.0E-6;
    }

    public double unitsForMicroseconds(double micros) {
        return micros * this.unitsPerNanosecond / 0.001;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros * this.unitsPerNanosecond / 0.001;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos * this.unitsPerNanosecond;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos * this.unitsPerNanosecond;
    }

    public double secondsForUnits(double units) {
        return units * 1.0E-9 / this.unitsPerNanosecond;
    }

    public double secondsForUnits(long units) {
        return (double)units * 1.0E-9 / this.unitsPerNanosecond;
    }

    public double millisecondsForUnits(double units) {
        return units * 1.0E-6 / this.unitsPerNanosecond;
    }

    public double millisecondsForUnits(long units) {
        return (double)units * 1.0E-6 / this.unitsPerNanosecond;
    }

    public double microsecondsForUnits(double units) {
        return units * 0.001 / this.unitsPerNanosecond;
    }

    public double microsecondsForUnits(long units) {
        return (double)units * 0.001 / this.unitsPerNanosecond;
    }

    public double nanosecondsForUnits(double units) {
        return units / this.unitsPerNanosecond;
    }

    public double nanosecondsForUnits(long units) {
        return (double)units / this.unitsPerNanosecond;
    }
}

