/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.time;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.time.AbstractTimeUnit;

public class UnitsPerSecond
extends AbstractTimeUnit {
    protected static final long SECONDS = 1L;
    protected static final long MILLIS = 1000L;
    protected static final long MICROS = 1000000L;
    protected static final long NANOS = 1000000000L;

    public UnitsPerSecond(double unitsPer) {
        super(unitsPer, unitsPer / 1000.0, unitsPer / 1000000.0, unitsPer / 1.0E9, 1.0 / unitsPer, 1000.0 / unitsPer, 1000000.0 / unitsPer, 1.0E9 / unitsPer);
    }

    public String toString() {
        return Double.toString(this.unitsPerSecond) + " units/second";
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.unitsPerSecond);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractTimeUnit && Double.doubleToLongBits(((AbstractTimeUnit)obj).unitsPerSecond) == Double.doubleToLongBits(this.unitsPerSecond);
    }

    @Override
    public int compareTo(AbstractTimeUnit u) {
        return Double.compare(this.unitsPerSecond, u.unitsPerSecond);
    }

    public int compareTo(TimeUnit u) {
        return Double.compare(this.unitsPerSecond, u.unitsPerSecond());
    }

    public double unitsForSeconds(double seconds) {
        return seconds * this.unitsPerSecond;
    }

    public double unitsForSeconds(long seconds) {
        return (double)seconds * this.unitsPerSecond;
    }

    public double unitsForMilliseconds(double millis) {
        return millis * this.unitsPerSecond / 1000.0;
    }

    public double unitsForMilliseconds(long millis) {
        return (double)millis * this.unitsPerSecond / 1000.0;
    }

    public double unitsForMicroseconds(double micros) {
        return micros * this.unitsPerSecond / 1000000.0;
    }

    public double unitsForMicroseconds(long micros) {
        return (double)micros * this.unitsPerSecond / 1000000.0;
    }

    public double unitsForNanoseconds(double nanos) {
        return nanos * this.unitsPerSecond / 1.0E9;
    }

    public double unitsForNanoseconds(long nanos) {
        return (double)nanos * this.unitsPerSecond / 1.0E9;
    }

    public double secondsForUnits(double units) {
        return units / this.unitsPerSecond;
    }

    public double secondsForUnits(long units) {
        return (double)units / this.unitsPerSecond;
    }

    public double millisecondsForUnits(double units) {
        return units * 1000.0 / this.unitsPerSecond;
    }

    public double millisecondsForUnits(long units) {
        return (double)(units * 1000L) / this.unitsPerSecond;
    }

    public double microsecondsForUnits(double units) {
        return units * 1000000.0 / this.unitsPerSecond;
    }

    public double microsecondsForUnits(long units) {
        return (double)(units * 1000000L) / this.unitsPerSecond;
    }

    public double nanosecondsForUnits(double units) {
        return units * 1.0E9 / this.unitsPerSecond;
    }

    public double nanosecondsForUnits(long units) {
        return (double)(units * 1000000000L) / this.unitsPerSecond;
    }
}

