/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.IntIter;
import com.spacekiller.util.collect.IntList;

public class ArrayIntList
implements IntList {
    private int len;
    private int[] arr;
    private int size;

    public ArrayIntList() {
        this(10);
    }

    public ArrayIntList(int initCapacity) {
        this.len = initCapacity;
        this.arr = new int[this.len];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public int get(int i) {
        return this.arr[i];
    }

    @Override
    public void add(int v) {
        this.ensureCapacity(this.size + 1);
        this.arr[this.size++] = v;
    }

    public void insert(int i, int v) {
        if (i > this.size || i < 0) {
            throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.arr, i, this.arr, i + 1, this.size - i);
        this.arr[i] = v;
        ++this.size;
    }

    @Override
    public int remove(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.size);
        }
        int v = this.arr[i];
        int numMoved = this.size - i - 1;
        if (numMoved > 0) {
            System.arraycopy(this.arr, i + 1, this.arr, i, numMoved);
        }
        --this.size;
        return v;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.len) {
            int[] oldData = this.arr;
            int newCapacity = this.len * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.arr = new int[newCapacity];
            System.arraycopy(oldData, 0, this.arr, 0, this.size);
        }
    }

    @Override
    public IntIter iterator() {
        return new Iter();
    }

    @Override
    public int indexOf(int v) {
        for (int i = 0; i < this.size; ++i) {
            if (this.arr[i] != v) continue;
            return i;
        }
        return -1;
    }

    protected class Iter
    implements IntIter {
        private int i = 0;

        @Override
        public boolean hasNext() {
            return this.i < ArrayIntList.this.size;
        }

        @Override
        public int next() {
            return ArrayIntList.this.arr[this.i++];
        }

        @Override
        public int next(int[] dst, int ofs, int len) {
            int n = Math.min(ArrayIntList.this.size - this.i, len);
            System.arraycopy(ArrayIntList.this.arr, this.i, dst, ofs, n);
            this.i += n;
            return n;
        }
    }
}

