/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class EntryMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1403595257237563105L;
    private static final int DEFAULT_CAPACITY = 256;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table = new Object[0];
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public EntryMap() {
        this(256);
    }

    public EntryMap(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 3 * expectedMaxSize / 2;
        if (minCapacity > 0x20000000 || minCapacity < 0) {
            result = 0x20000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    private void closeDeletion(int d) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.nextKeyIndex(d, len);
        while ((item = tab[i]) != null) {
            int r = EntryMap.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[d + 1] = tab[i + 1];
                tab[i] = null;
                tab[i + 1] = null;
                d = i;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
        return true;
    }

    private boolean containsMapping(Object key, Object value) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
        return tab[i + 1] == value;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value) continue;
            return true;
        }
        return false;
    }

    protected ReferenceQueue createQueue() {
        ReferenceQueue rc = new ReferenceQueue();
        return rc;
    }

    public Set entrySet() {
        Set es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    public Object get(Object key) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return item;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
        return tab[i + 1];
    }

    public void getEntry(Object key, Object[] keyAndValue) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                keyAndValue[0] = item;
                keyAndValue[1] = tab[i + 1];
                return;
            }
            if (item == null) {
                keyAndValue[0] = null;
                keyAndValue[1] = null;
                return;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
    }

    private static int hash(Object x, int length) {
        int h = x.hashCode();
        return (h << 1) - (h << 8) & length - 1;
    }

    @Override
    public int hashCode() {
        int result = 0;
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            Object k = EntryMap.unmaskNull(key);
            result += System.identityHashCode(k) ^ System.identityHashCode(tab[i + 1]);
        }
        return result;
    }

    private void init(int initCapacity) {
        this.threshold = initCapacity * 2 / 3;
        this.table = new Object[2 * initCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    public Object put(Object key, Object value) {
        Object item;
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        while ((item = tab[i]) != null) {
            if (item == k) {
                Object oldValue = tab[i + 1];
                tab[i + 1] = value;
                return oldValue;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
        ++this.modCount;
        tab[i] = k;
        tab[i + 1] = value;
        if (++this.size >= this.threshold) {
            this.resize(len);
        }
        return null;
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(this.capacity(size * 4 / 3));
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    public Object remove(Object key) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                ++this.modCount;
                --this.size;
                Object oldValue = tab[i + 1];
                tab[i + 1] = null;
                tab[i] = null;
                this.closeDeletion(i);
                return oldValue;
            }
            if (item == null) {
                return null;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
    }

    private boolean removeMapping(Object key, Object value) {
        Object k = EntryMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = EntryMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                tab[i] = null;
                tab[i + 1] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = EntryMap.nextKeyIndex(i, len);
        }
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity * 2;
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        Object[] newTable = new Object[newLength];
        this.threshold = newLength / 3;
        for (int j = 0; j < oldLength; j += 2) {
            Object key = oldTable[j];
            if (key == null) continue;
            Object value = oldTable[j + 1];
            oldTable[j] = null;
            oldTable[j + 1] = null;
            int i = EntryMap.hash(key, newLength);
            while (newTable[i] != null) {
                i = EntryMap.nextKeyIndex(i, newLength);
            }
            newTable[i] = key;
            newTable[i + 1] = value;
        }
        this.table = newTable;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Object[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            Object key = tab[i];
            if (key == null) continue;
            s.writeObject(EntryMap.unmaskNull(key));
            s.writeObject(tab[i + 1]);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EntryMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EntryMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EntryMap.this.size;
        }

        @Override
        public void clear() {
            EntryMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }
    }

    private class EntryIterator
    extends IdentityHashMapIterator
    implements Map.Entry {
        private EntryIterator() {
        }

        public Object next() {
            this.nextIndex();
            return this;
        }

        public Object getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return EntryMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        public Object getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        public Object setValue(Object value) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object oldValue = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = value;
            if (this.traversalTable != EntryMap.this.table) {
                EntryMap.this.put(this.traversalTable[this.lastReturnedIndex], value);
            }
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return e.getKey() == this.getKey() && e.getValue() == this.getValue();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private abstract class IdentityHashMapIterator
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        private IdentityHashMapIterator() {
            this.index = EntryMap.this.size != 0 ? 0 : EntryMap.this.table.length;
            this.expectedModCount = EntryMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = EntryMap.this.table;
        }

        @Override
        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            for (int i = this.index; i < tab.length; i += 2) {
                Object key = tab[i];
                if (key == null) continue;
                this.index = i;
                this.indexValid = true;
                return true;
            }
            this.index = tab.length;
            return false;
        }

        protected int nextIndex() {
            if (EntryMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        @Override
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (EntryMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++EntryMap.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            EntryMap.this.size--;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != EntryMap.this.table) {
                EntryMap.this.remove(key);
                this.expectedModCount = EntryMap.this.modCount;
                return;
            }
            int i = EntryMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                int r = EntryMap.hash(item, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == EntryMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = item;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = EntryMap.nextKeyIndex(i, len);
            }
        }
    }
}

