/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class HashCollection
implements Collection,
Set {
    private Object[] tab;
    private int len;
    private int threshold;
    private int size;

    public HashCollection() {
        this(256);
    }

    public HashCollection(int initCapacity) {
        this.tab = new Object[initCapacity];
        this.len = this.tab.length;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
    }

    @Override
    public boolean add(Object o) {
        Object v;
        if (o == null) {
            throw new NullPointerException();
        }
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        while ((v = this.tab[i]) != null) {
            if (this.compare(v, o)) {
                return false;
            }
            i = this.next(i);
        }
        this.tab[i] = o;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        boolean rc = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            rc |= this.add(i.next());
        }
        return rc;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.tab, null);
    }

    private void closeDeletion(int d) {
        Object item;
        int i = this.next(d);
        while ((item = this.tab[i]) != null) {
            int r = (this.hash(item) & Integer.MAX_VALUE) % this.len;
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.tab[d] = item;
                this.tab[i] = null;
                d = i;
            }
            i = this.next(i);
        }
    }

    protected boolean compare(Object a, Object b) {
        return a.equals(b);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        Object v;
        while ((v = this.tab[i]) != null) {
            if (this.compare(v, o)) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    protected int hash(Object o) {
        return o.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public Iterator iterator() {
        return new HashIterator();
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        Object v;
        while ((v = this.tab[i]) != null) {
            if (this.compare(v, o)) {
                this.tab[i] = null;
                --this.size;
                this.closeDeletion(i);
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean rc = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.remove(i.next())) continue;
            rc = true;
        }
        return rc;
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        Object[] old = this.tab;
        int oldLen = this.len;
        this.tab = new Object[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            Object o = old[j];
            if (o == null) continue;
            int i = this.hash(o) % this.len;
            while (this.tab[i] != null) {
                i = this.next(i);
            }
            this.tab[i] = o;
        }
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean rc = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            rc = true;
        }
        return rc;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        int c = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            a[c] = i.next();
            ++c;
        }
        return a;
    }

    protected class HashIterator
    implements Iterator {
        private int i = 0;

        public HashIterator() {
            this.scan();
        }

        private void scan() {
            while (this.i < HashCollection.this.len) {
                if (HashCollection.this.tab[this.i] != null) {
                    return;
                }
                ++this.i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < HashCollection.this.len ? HashCollection.this.tab[this.i] != null : false;
        }

        public Object next() {
            Object rc = HashCollection.this.tab[this.i++];
            this.scan();
            return rc;
        }

        @Override
        public void remove() {
            ((HashCollection)HashCollection.this).tab[this.i] = null;
            HashCollection.this.size--;
            HashCollection.this.closeDeletion(this.i);
            this.scan();
        }
    }
}

