/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.IntIter;
import com.spacekiller.util.collect.IntSet;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class HashIntSet
implements IntSet {
    private static final EmptyIter EMPTY_ITER = new EmptyIter();
    private int[] t;
    private int len;
    private int size = 0;
    private int threshold;
    private boolean hasZero;

    public HashIntSet(int initCapacity) {
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.t = new int[this.len];
    }

    public HashIntSet(int[] values) {
        this(values.length * 3 / 2);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            this.add(values[i]);
        }
    }

    public int capacity() {
        return this.len;
    }

    @Override
    public void clear() {
        if (this.hasZero) {
            this.hasZero = false;
            --this.size;
        }
        if (this.size > 0) {
            Arrays.fill(this.t, 0);
            this.size = 0;
        }
    }

    private void closeDeletion(int d) {
        int key;
        int i = this.next(d);
        while ((key = this.t[i]) != 0) {
            int r = (key & Integer.MAX_VALUE) % this.len;
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.t[d] = key;
                this.t[i] = 0;
                d = i;
            }
            i = this.next(i);
        }
    }

    public void getAll(IntSet dst) {
        for (int i = 0; i < this.len; ++i) {
            int v = this.t[i];
            if (v == 0) continue;
            dst.add(v);
        }
        if (this.hasZero) {
            dst.add(0);
        }
    }

    public int getUsedMemory() {
        int rc = this.capacity() * 4;
        return rc += 12;
    }

    @Override
    public boolean contains(int id) {
        int v;
        if (id == 0) {
            return this.hasZero;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0) {
            if (v == id) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public IntIter iterator() {
        if (this.size > 0) {
            return new Iter();
        }
        return EMPTY_ITER;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    @Override
    public boolean add(int id) {
        int v;
        if (id == 0) {
            if (!this.hasZero) {
                this.hasZero = true;
                ++this.size;
                return true;
            }
            return false;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0) {
            if (v == id) {
                return false;
            }
            i = this.next(i);
        }
        this.t[i] = id;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return true;
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        int[] old = this.t;
        int oldLen = this.len;
        this.t = new int[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            int id = old[j];
            if (id == 0) continue;
            int i = (id & Integer.MAX_VALUE) % this.len;
            while (this.t[i] != 0) {
                i = this.next(i);
            }
            this.t[i] = id;
        }
    }

    @Override
    public boolean remove(int id) {
        int v;
        if (id == 0) {
            if (this.hasZero) {
                this.hasZero = false;
                --this.size;
                return true;
            }
            return false;
        }
        int i = (id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0) {
            if (v == id) {
                this.t[i] = 0;
                --this.size;
                this.closeDeletion(i);
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected static class EmptyIter
    implements IntIter {
        protected EmptyIter() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            throw new NoSuchElementException();
        }

        @Override
        public int next(int[] dst, int ofs, int len) {
            return 0;
        }
    }

    protected class Iter
    implements IntIter {
        private int i = 0;
        private boolean zero;

        public Iter() {
            this.zero = HashIntSet.this.hasZero;
        }

        @Override
        public int next(int[] dst, int ofs, int num) {
            int x = ofs;
            int y = ofs + num;
            while (this.i < HashIntSet.this.len) {
                int v = HashIntSet.this.t[this.i];
                if (v != 0) {
                    dst[x++] = v;
                    if (x >= y) break;
                }
                ++this.i;
            }
            if (this.zero && x < y) {
                this.zero = false;
                dst[x++] = 0;
            }
            return x - ofs;
        }

        @Override
        public boolean hasNext() {
            while (this.i < HashIntSet.this.len) {
                if (HashIntSet.this.t[this.i] != 0) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        @Override
        public int next() {
            while (this.i < HashIntSet.this.len) {
                int v = HashIntSet.this.t[this.i];
                if (v != 0) {
                    ++this.i;
                    return v;
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                return 0;
            }
            throw new NoSuchElementException();
        }
    }
}

