/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.LongIter;
import com.spacekiller.util.collect.LongSet;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class HashLongSet
implements LongSet {
    private static final EmptyIter EMPTY_ITER = new EmptyIter();
    private long[] t;
    private int len;
    private int size = 0;
    private int threshold;
    private boolean hasZero;

    public HashLongSet(int initCapacity) {
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.t = new long[this.len];
    }

    public HashLongSet(long[] values) {
        this(values.length * 3 / 2);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            this.add(values[i]);
        }
    }

    public int capacity() {
        return this.len;
    }

    @Override
    public void clear() {
        if (this.hasZero) {
            this.hasZero = false;
            --this.size;
        }
        if (this.size > 0) {
            Arrays.fill(this.t, 0L);
            this.size = 0;
        }
    }

    private void closeDeletion(int d) {
        long key;
        int i = this.next(d);
        while ((key = this.t[i]) != 0L) {
            int r = ((int)key & Integer.MAX_VALUE) % this.len;
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.t[d] = key;
                this.t[i] = 0L;
                d = i;
            }
            i = this.next(i);
        }
    }

    public void getAll(LongSet dst) {
        for (int i = 0; i < this.len; ++i) {
            long v = this.t[i];
            if (v == 0L) continue;
            dst.add(v);
        }
        if (this.hasZero) {
            dst.add(0L);
        }
    }

    public int getUsedMemory() {
        int rc = this.capacity() * 8;
        return rc += 12;
    }

    @Override
    public boolean contains(long id) {
        long v;
        if (id == 0L) {
            return this.hasZero;
        }
        int i = ((int)id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0L) {
            if (v == id) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public LongIter iterator() {
        if (this.size > 0) {
            return new Iter();
        }
        return EMPTY_ITER;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    @Override
    public boolean add(long id) {
        long v;
        if (id == 0L) {
            if (!this.hasZero) {
                this.hasZero = true;
                ++this.size;
                return true;
            }
            return false;
        }
        int i = ((int)id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0L) {
            if (v == id) {
                return false;
            }
            i = this.next(i);
        }
        this.t[i] = id;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return true;
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        long[] old = this.t;
        int oldLen = this.len;
        this.t = new long[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            long id = old[j];
            if (id == 0L) continue;
            int i = ((int)id & Integer.MAX_VALUE) % this.len;
            while (this.t[i] != 0L) {
                i = this.next(i);
            }
            this.t[i] = id;
        }
    }

    @Override
    public boolean remove(long id) {
        long v;
        if (id == 0L) {
            if (this.hasZero) {
                this.hasZero = false;
                --this.size;
                return true;
            }
            return false;
        }
        int i = ((int)id & Integer.MAX_VALUE) % this.len;
        while ((v = this.t[i]) != 0L) {
            if (v == id) {
                this.t[i] = 0L;
                --this.size;
                this.closeDeletion(i);
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected static class EmptyIter
    implements LongIter {
        protected EmptyIter() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long next() {
            throw new NoSuchElementException();
        }

        @Override
        public int next(long[] dst, int ofs, int len) {
            return 0;
        }
    }

    protected class Iter
    implements LongIter {
        private int i = 0;
        private boolean zero;

        public Iter() {
            this.zero = HashLongSet.this.hasZero;
        }

        @Override
        public int next(long[] dst, int ofs, int num) {
            int x = ofs;
            int y = ofs + num;
            while (this.i < HashLongSet.this.len) {
                long v = HashLongSet.this.t[this.i];
                if (v != 0L) {
                    dst[x++] = v;
                    if (x >= y) break;
                }
                ++this.i;
            }
            if (this.zero && x < y) {
                this.zero = false;
                dst[x++] = 0L;
            }
            return x - ofs;
        }

        @Override
        public boolean hasNext() {
            while (this.i < HashLongSet.this.len) {
                if (HashLongSet.this.t[this.i] != 0L) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        @Override
        public long next() {
            while (this.i < HashLongSet.this.len) {
                long v = HashLongSet.this.t[this.i];
                if (v != 0L) {
                    ++this.i;
                    return v;
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                return 0L;
            }
            throw new NoSuchElementException();
        }
    }
}

