/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.Iterators;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Iterator;

public class IdentityHashReferenceSet {
    private Reference[] tab;
    private int len;
    private int size;
    private int threshold;
    private int recycled = 0;
    private int resized = 0;

    public IdentityHashReferenceSet(int initCapacity) {
        this.tab = new Reference[initCapacity];
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
    }

    public void put(Object o, Reference ref) {
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        while (true) {
            Reference r;
            if ((r = this.tab[i]) == null) {
                this.tab[i] = ref;
                if (++this.size >= this.threshold) {
                    this.resize();
                }
                return;
            }
            Object v = r.get();
            if (v == o) {
                return;
            }
            if (v == null) {
                this.tab[i] = ref;
                ++this.recycled;
                return;
            }
            i = this.next(i);
        }
    }

    public Reference get(Object o) {
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        Reference v;
        while ((v = this.tab[i]) != null) {
            if (v.get() == o) {
                return v;
            }
            i = this.next(i);
        }
        return null;
    }

    public Iterator iterator() {
        return this.size > 0 ? new Iter() : Iterators.EMPTY_ITERATOR;
    }

    public int size() {
        return this.size;
    }

    public int getTableLength() {
        return this.len;
    }

    public int getRecycleCount() {
        return this.recycled;
    }

    public int getResizeCount() {
        return this.resized;
    }

    protected int hash(Object o) {
        return System.identityHashCode(o);
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    private void resize() {
        Reference ref;
        for (int j = 0; j < this.len; ++j) {
            ref = this.tab[j];
            if (ref == null || ref.get() != null) continue;
            this.tab[j] = null;
            --this.size;
            ++this.recycled;
        }
        ++this.resized;
        int oldLen = this.len;
        int newLen = (this.size + 1) * 2;
        Reference[] oldTab = this.tab;
        this.tab = new Reference[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
        for (int j = 0; j < oldLen; ++j) {
            Object o;
            ref = oldTab[j];
            if (ref == null || (o = ref.get()) == null) continue;
            int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
            while (this.tab[i] != null) {
                i = this.next(i);
            }
            this.tab[i] = ref;
            ++this.size;
        }
    }

    public void remove(Object o) {
        Reference r;
        int i = (this.hash(o) & Integer.MAX_VALUE) % this.len;
        while ((r = this.tab[i]) != null) {
            Object v = r.get();
            if (v == null) {
                this.tab[i] = null;
                --this.size;
                this.closeDeletion(i);
                --i;
            } else if (v == o) {
                this.tab[i] = null;
                --this.size;
                this.closeDeletion(i);
                return;
            }
            i = this.next(i);
        }
    }

    private void closeDeletion(int d) {
        Reference ref;
        int i = this.next(d);
        while ((ref = this.tab[i]) != null) {
            int r;
            Object o = ref.get();
            if (o != null && (i < (r = (this.hash(o) & Integer.MAX_VALUE) % this.len) && (r <= d || d <= i) || r <= d && d <= i)) {
                this.tab[d] = ref;
                this.tab[i] = null;
                d = i;
            }
            i = this.next(i);
        }
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.tab, null);
    }

    public class Iter
    implements Iterator {
        private int i = -1;
        private int next;

        public Iter() {
            this.scan();
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0;
        }

        public Object next() {
            Reference rc = IdentityHashReferenceSet.this.tab[this.next];
            this.i = this.next;
            this.scan();
            return rc;
        }

        private void scan() {
            this.next = this.i + 1;
            while (this.next < IdentityHashReferenceSet.this.len) {
                if (IdentityHashReferenceSet.this.tab[this.next] != null) {
                    return;
                }
                ++this.next;
            }
            this.next = -1;
        }

        @Override
        public void remove() {
            if (this.i >= 0 && IdentityHashReferenceSet.this.tab[this.i] != null) {
                ((IdentityHashReferenceSet)IdentityHashReferenceSet.this).tab[this.i] = null;
                IdentityHashReferenceSet.this.closeDeletion(this.i);
                --this.i;
                this.scan();
                this.i = -1;
            }
        }
    }
}

