/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.Int2ObjectIter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class Int2ObjectMap<V> {
    private int[] ids;
    private V[] obj;
    private int len;
    private int size;
    private int threshold;
    private boolean zeroSet;
    private V zeroValue;

    public Int2ObjectMap(int initCapacity) {
        this.ids = new int[initCapacity];
        this.obj = new Object[initCapacity];
        this.len = initCapacity;
        this.threshold = this.len * 2 / 3;
        this.size = 0;
    }

    public int capacity() {
        return this.len;
    }

    private void closeDeletion(int d) {
        int key;
        int i = this.next(d);
        while ((key = this.ids[i]) != 0) {
            int r = this.pos(key);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                this.ids[d] = key;
                this.obj[d] = this.obj[i];
                this.ids[i] = 0;
                this.obj[i] = null;
                d = i;
            }
            i = this.next(i);
        }
    }

    public V get(int id) {
        if (id == 0) {
            return this.zeroValue;
        }
        int i = this.pos(id);
        int v;
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                return this.obj[i];
            }
            i = this.next(i);
        }
        return null;
    }

    public boolean containsKey(int id) {
        if (id == 0) {
            return this.zeroSet;
        }
        int i = this.pos(id);
        int v;
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                return true;
            }
            i = this.next(i);
        }
        return false;
    }

    public int getUsedMemory() {
        int rc = this.capacity() * 8;
        return rc += 24;
    }

    protected int pos(int key) {
        return (key << 2 & Integer.MAX_VALUE) % this.len;
    }

    private int next(int i) {
        return ++i < this.len ? i : 0;
    }

    public void delete(int id) {
        int key;
        if (id == 0) {
            if (this.zeroSet) {
                this.zeroSet = false;
                this.zeroValue = null;
                --this.size;
            }
            return;
        }
        int i = this.pos(id);
        while ((key = this.ids[i]) != 0) {
            if (key == id) {
                this.ids[i] = 0;
                this.obj[i] = null;
                --this.size;
                this.closeDeletion(i);
                return;
            }
            i = this.next(i);
        }
    }

    public V remove(int id) {
        int key;
        if (id == 0) {
            if (this.zeroSet) {
                V o = this.zeroValue;
                this.zeroSet = false;
                this.zeroValue = null;
                --this.size;
                return o;
            }
            return null;
        }
        int i = this.pos(id);
        while ((key = this.ids[i]) != 0) {
            if (key == id) {
                V o = this.obj[i];
                this.ids[i] = 0;
                this.obj[i] = null;
                --this.size;
                this.closeDeletion(i);
                return o;
            }
            i = this.next(i);
        }
        return null;
    }

    private void resize(int newLen) {
        if (newLen < this.len) {
            return;
        }
        int[] oldIds = this.ids;
        V[] oldObj = this.obj;
        int oldLen = this.len;
        this.ids = new int[newLen];
        this.obj = new Object[newLen];
        this.len = newLen;
        this.threshold = this.len * 2 / 3;
        for (int j = 0; j < oldLen; ++j) {
            int id = oldIds[j];
            if (id == 0) continue;
            int i = this.pos(id);
            while (this.ids[i] != 0) {
                i = this.next(i);
            }
            this.ids[i] = id;
            this.obj[i] = oldObj[j];
        }
    }

    public void set(int id, V value) {
        int v;
        if (id == 0) {
            if (this.zeroSet) {
                this.zeroValue = value;
            } else {
                this.zeroSet = true;
                this.zeroValue = value;
                ++this.size;
            }
            return;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                this.obj[i] = value;
                return;
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
    }

    public V put(int id, V value) {
        int v;
        if (id == 0) {
            if (this.zeroSet) {
                V old = this.zeroValue;
                this.zeroValue = value;
                return old;
            }
            this.zeroSet = true;
            this.zeroValue = value;
            ++this.size;
            return null;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                V old = this.obj[i];
                this.obj[i] = value;
                return old;
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return null;
    }

    public Object add(int id, V value) {
        int v;
        if (id == 0) {
            if (this.zeroSet) {
                return this.zeroValue;
            }
            this.zeroSet = true;
            this.zeroValue = value;
            ++this.size;
            return null;
        }
        int i = this.pos(id);
        while ((v = this.ids[i]) != 0) {
            if (v == id) {
                return this.obj[i];
            }
            i = this.next(i);
        }
        this.ids[i] = id;
        this.obj[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.len * 2);
        }
        return null;
    }

    public void clear() {
        if (this.zeroSet) {
            this.zeroSet = false;
            this.zeroValue = null;
            --this.size;
        }
        if (this.size != 0) {
            for (int i = 0; i < this.len; ++i) {
                this.ids[i] = 0;
                this.obj[i] = null;
            }
            this.size = 0;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public Collection values() {
        return new Values();
    }

    public Iterator valueIter() {
        return new ValueIter();
    }

    public Int2ObjectIter iterator() {
        return new Iter();
    }

    public void dispose() {
        this.zeroValue = null;
        this.ids = null;
        this.obj = null;
    }

    protected class Values
    extends AbstractCollection {
        protected Values() {
        }

        @Override
        public boolean isEmpty() {
            return Int2ObjectMap.this.size < 1;
        }

        @Override
        public int size() {
            return Int2ObjectMap.this.size;
        }

        @Override
        public Iterator iterator() {
            return new ValueIter();
        }
    }

    protected class Iter
    implements Int2ObjectIter {
        private int i = 0;
        private boolean zero;
        private int key;

        public Iter() {
            this.zero = Int2ObjectMap.this.zeroSet;
        }

        @Override
        public boolean hasNext() {
            while (this.i < Int2ObjectMap.this.len) {
                if (Int2ObjectMap.this.ids[this.i] != 0) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        public V next() {
            while (this.i < Int2ObjectMap.this.len) {
                if (Int2ObjectMap.this.ids[this.i] != 0) {
                    this.key = Int2ObjectMap.this.ids[this.i];
                    return Int2ObjectMap.this.obj[this.i++];
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                this.key = 0;
                return Int2ObjectMap.this.zeroValue;
            }
            return null;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("currently not supported!");
        }
    }

    protected class ValueIter
    implements Iterator {
        private int i = 0;
        private boolean zero;
        private int r;

        public ValueIter() {
            this.zero = Int2ObjectMap.this.zeroSet;
            this.r = -1;
        }

        @Override
        public boolean hasNext() {
            while (this.i < Int2ObjectMap.this.len) {
                if (Int2ObjectMap.this.ids[this.i] != 0) {
                    return true;
                }
                ++this.i;
            }
            return this.zero;
        }

        public V next() {
            while (this.i < Int2ObjectMap.this.len) {
                if (Int2ObjectMap.this.ids[this.i] != 0) {
                    return Int2ObjectMap.this.obj[this.i++];
                }
                ++this.i;
            }
            if (this.zero) {
                this.zero = false;
                this.r = Integer.MAX_VALUE;
                return Int2ObjectMap.this.zeroValue;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.i == this.r) {
                throw new IllegalStateException("Current entry already removed: " + this.i);
            }
            if (this.r == Integer.MAX_VALUE) {
                if (Int2ObjectMap.this.zeroSet) {
                    Int2ObjectMap.this.zeroSet = false;
                    Int2ObjectMap.this.zeroValue = null;
                    Int2ObjectMap.this.size--;
                }
                this.i = this.r;
                return;
            }
            this.r = --this.i;
            ((Int2ObjectMap)Int2ObjectMap.this).ids[this.r] = 0;
            ((Int2ObjectMap)Int2ObjectMap.this).obj[this.r] = null;
            Int2ObjectMap.this.size--;
            Int2ObjectMap.this.closeDeletion(this.r);
        }
    }
}

