/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.collect.IntIter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IntArrayBuilder {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private int partCapacity;
    private int[] carr;
    private int cofs;
    private int clen;
    private List parts;

    public IntArrayBuilder(int partCapacity) {
        this.partCapacity = partCapacity;
        this.parts = new LinkedList();
        this.clear();
    }

    public void add(int i) {
        if (this.cofs >= this.clen) {
            this.resize();
        }
        this.carr[this.cofs++] = i;
    }

    public void add(int a, int b) {
        if (this.cofs + 1 < this.clen) {
            this.carr[this.cofs++] = a;
            this.carr[this.cofs++] = b;
        } else if (this.cofs < this.clen) {
            this.carr[this.cofs++] = a;
            this.resize();
            this.carr[this.cofs++] = b;
        } else {
            this.resize();
            this.carr[this.cofs++] = a;
            this.carr[this.cofs++] = b;
        }
    }

    public void add(int[] a, int off, int len) {
        int end = off + len;
        while (off < end) {
            if (this.cofs >= this.clen) {
                this.resize();
            }
            int n = Math.min(end - off, this.clen - this.cofs);
            System.arraycopy(a, off, this.carr, this.cofs, n);
            this.cofs += n;
            off += n;
        }
    }

    private void resize() {
        if (this.clen > 0) {
            this.parts.add(this.carr);
        }
        this.carr = new int[this.partCapacity];
        this.cofs = 0;
        this.clen = this.partCapacity;
    }

    public boolean isEmpty() {
        return this.cofs == 0;
    }

    public int size() {
        return this.cofs + this.parts.size() * this.partCapacity;
    }

    public void clear() {
        this.parts.clear();
        this.carr = null;
        this.cofs = 0;
        this.clen = 0;
    }

    public int[] toIntArray() {
        if (this.cofs == 0) {
            return EMPTY_INT_ARRAY;
        }
        int size = this.cofs + this.parts.size() * this.partCapacity;
        int[] r = new int[size];
        int o = 0;
        for (int[] a : this.parts) {
            int n = a.length;
            System.arraycopy(a, 0, r, o, n);
            o += n;
        }
        System.arraycopy(this.carr, 0, r, o, this.cofs);
        return r;
    }

    public IntIter intIter() {
        return new Iter();
    }

    protected class Iter
    implements IntIter {
        private int[] iarr;
        private int iofs;
        private int ilen;
        private Iterator p;

        public Iter() {
            this.p = IntArrayBuilder.this.parts.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.iofs < this.ilen) {
                return true;
            }
            if (this.p.hasNext()) {
                this.iarr = (int[])this.p.next();
                this.iofs = 0;
                this.ilen = this.iarr.length;
                return true;
            }
            if (this.iarr != IntArrayBuilder.this.carr) {
                this.iarr = IntArrayBuilder.this.carr;
                this.iofs = 0;
                this.ilen = IntArrayBuilder.this.cofs;
                return this.iofs < this.ilen;
            }
            return false;
        }

        @Override
        public int next() {
            return this.iarr[this.iofs++];
        }

        @Override
        public int next(int[] dst, int ofs, int len) {
            if (this.iofs < this.ilen) {
                int n = Math.min(len, this.ilen - this.iofs);
                System.arraycopy(this.iarr, this.iofs, dst, ofs, n);
                this.iofs += n;
                return n;
            }
            if (this.p.hasNext()) {
                this.iarr = (int[])this.p.next();
                this.iofs = 0;
                this.ilen = this.iarr.length;
                int n = Math.min(len, this.ilen - this.iofs);
                System.arraycopy(this.iarr, this.iofs, dst, ofs, n);
                this.iofs += n;
                return n;
            }
            if (this.iarr != IntArrayBuilder.this.carr) {
                this.iarr = IntArrayBuilder.this.carr;
                this.iofs = 0;
                this.ilen = IntArrayBuilder.this.cofs;
                int n = Math.min(len, this.ilen - this.iofs);
                System.arraycopy(this.iarr, this.iofs, dst, ofs, n);
                this.iofs += n;
                return n;
            }
            return 0;
        }
    }
}

