/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;

public class Object2LongQueue {
    private int partLen;
    private int size;
    private LinkedList parts;
    private Part firstPart;
    private Part lastPart;
    private long id;
    private LinkedList recycle = null;

    public Object2LongQueue(int incrementCapacity) {
        Part p;
        this.partLen = incrementCapacity;
        this.parts = new LinkedList();
        this.firstPart = p = new Part(this.partLen);
        this.lastPart = p;
        this.parts.add(p);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public void put(Object o, long i) {
        if (this.lastPart.put(o, i)) {
            ++this.size;
        } else {
            Part p;
            if (this.recycle == null) {
                p = new Part(this.partLen);
            } else {
                p = null;
                while (!this.recycle.isEmpty() && (p = (Part)((Reference)this.recycle.removeFirst()).get()) == null) {
                }
                if (p == null) {
                    this.recycle = null;
                    p = new Part(this.partLen);
                }
                this.lastPart = p;
            }
            this.parts.add(p);
            this.lastPart = p;
            p.put(o, i);
            ++this.size;
        }
    }

    public Object remove() {
        if (this.size < 1) {
            return null;
        }
        if (this.firstPart.size > 0) {
            --this.size;
            Object o = this.firstPart.remove();
            this.id = this.firstPart.id;
            return o;
        }
        if (this.recycle == null) {
            this.recycle = new LinkedList();
        }
        this.recycle.add(new SoftReference<Part>(this.firstPart));
        this.parts.remove(0);
        this.firstPart = (Part)this.parts.getFirst();
        --this.size;
        Object o = this.firstPart.remove();
        this.id = this.firstPart.id;
        return o;
    }

    public long id() {
        return this.id;
    }

    public void clear() {
        if (this.size != 0) {
            Iterator i = this.parts.iterator();
            while (i.hasNext()) {
                ((Part)i.next()).clear();
            }
            this.size = 0;
        }
        if (this.firstPart != this.lastPart) {
            if (this.recycle == null) {
                this.recycle = new LinkedList();
            }
            this.parts.removeFirst();
            for (Part p : this.parts) {
                this.recycle.add(new SoftReference<Part>(p));
            }
            this.lastPart = this.firstPart;
            this.parts.clear();
            this.parts.add(this.firstPart);
        }
    }

    public void release() {
        this.recycle = null;
    }

    public int computeCapacity() {
        int cap = 0;
        Iterator i = this.parts.iterator();
        while (i.hasNext()) {
            cap += ((Part)i.next()).len;
        }
        if (this.recycle != null) {
            Iterator i2 = this.recycle.iterator();
            while (i2.hasNext()) {
                Part p = (Part)((Reference)i2.next()).get();
                if (p == null) continue;
                cap += p.len;
            }
        }
        return cap;
    }

    protected static class Part {
        private Object[] array;
        private long[] ids;
        private int len;
        private int size;
        private int head;
        private int tail;
        private long id;

        public Part(int partLen) {
            this.len = partLen;
            this.array = new Object[this.len];
            this.ids = new long[this.len];
            this.head = 0;
            this.tail = 0;
            this.size = 0;
        }

        protected Object remove() {
            Object o = this.array[this.head];
            this.id = this.ids[this.head];
            this.array[this.head] = null;
            ++this.head;
            this.head %= this.len;
            --this.size;
            return o;
        }

        protected boolean put(Object o, long i) {
            if (this.size < this.len) {
                this.array[this.tail] = o;
                this.ids[this.tail] = i;
                ++this.tail;
                this.tail %= this.len;
                ++this.size;
                return true;
            }
            return false;
        }

        protected void clear() {
            if (this.size != 0) {
                if (this.head < this.tail) {
                    for (int i = this.head; i < this.tail; ++i) {
                        this.array[i] = null;
                    }
                } else {
                    int i;
                    for (i = this.head; i < this.len; ++i) {
                        this.array[i] = null;
                    }
                    for (i = 0; i < this.tail; ++i) {
                        this.array[i] = null;
                    }
                }
                this.size = 0;
            }
            this.head = 0;
            this.tail = 0;
        }
    }
}

