/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.collect;

import com.spacekiller.util.buffer.LongInput;
import com.spacekiller.util.buffer.LongOutput;
import com.spacekiller.util.collect.HashLongSet;
import com.spacekiller.util.collect.LongSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class UniqueLongQueue
implements LongInput,
LongOutput {
    private int initCapacity = 64;
    private int incrementCapacity = 64;
    private boolean nullDone = false;
    private LongSet done;
    private List queue;
    private int rBufIndex;
    private long[] rBuf;
    private int rLen = 0;
    private int rPos = 0;
    private int wBufIndex;
    private long[] wBuf;
    private int wLen = 0;
    private int wPos = 0;

    public UniqueLongQueue(int initCapacity, int incrementCapacity) {
        this.initCapacity = initCapacity;
        this.incrementCapacity = incrementCapacity;
        this.clear();
    }

    public LongSet getDone() {
        return this.done;
    }

    public long size() {
        if (this.rBufIndex == this.wBufIndex) {
            return this.wPos - this.rPos;
        }
        long rc = this.rLen - this.rPos;
        for (int c = this.rBufIndex + 1; c < this.wBufIndex; ++c) {
            rc += (long)((long[])this.queue.get(c)).length;
        }
        return rc += (long)this.wPos;
    }

    public void clear() {
        this.nullDone = false;
        this.done = new HashLongSet(this.initCapacity);
        if (this.queue == null) {
            this.queue = new LinkedList();
        }
        if (this.queue.isEmpty()) {
            this.queue.add(new long[this.initCapacity]);
        }
        this.rBufIndex = 0;
        this.rBuf = (long[])this.queue.get(this.rBufIndex);
        this.rLen = this.rBuf.length;
        this.rPos = 0;
        this.wBufIndex = 0;
        this.wBuf = (long[])this.queue.get(this.wBufIndex);
        this.wLen = this.wBuf.length;
        this.wPos = 0;
    }

    public boolean available() {
        return this.rPos != this.wPos || this.rBufIndex != this.wBufIndex;
    }

    public long read() throws IOException {
        long rc = this.rBuf[this.rPos++];
        if (this.rPos >= this.rLen) {
            this.queue.remove(this.rBufIndex);
            this.queue.add(this.rBuf);
            --this.wBufIndex;
            this.rBuf = (long[])this.queue.get(this.rBufIndex);
            this.rPos = 0;
            this.rLen = this.rBuf.length;
        }
        return rc;
    }

    public void read(DataOutputStream out, int len) throws IOException {
        for (int c = 0; c < len; ++c) {
            out.writeLong(this.read());
        }
    }

    public void read(long[] dst, int ofs, int len) throws IOException {
        int end = ofs + len;
        while (ofs < end) {
            dst[ofs++] = this.read();
        }
    }

    public void write(DataInputStream in, int len) throws IOException {
        for (int c = 0; c < len; ++c) {
            this.write(in.readLong());
        }
    }

    protected long[] allocate() {
        return new long[this.incrementCapacity];
    }

    public void write(long i) throws IOException {
        if (i == 0L) {
            if (this.nullDone) {
                return;
            }
            this.nullDone = true;
        } else {
            if (this.done.contains(i)) {
                return;
            }
            this.done.add(i);
        }
        this.wBuf[this.wPos++] = i;
        if (this.wPos >= this.wLen) {
            ++this.wBufIndex;
            if (this.wBufIndex < this.queue.size()) {
                this.wBuf = (long[])this.queue.get(this.wBufIndex);
                this.wPos = 0;
                this.wLen = this.wBuf.length;
            } else {
                this.wBuf = this.allocate();
                this.wPos = 0;
                this.wLen = this.wBuf.length;
                this.queue.add(this.wBuf);
            }
        }
    }

    public void write(long[] src, int ofs, int len) throws IOException {
        int end = ofs + len;
        while (ofs < end) {
            this.write(src[ofs++]);
        }
    }
}

