/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.status.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class ErrorMonitorPanel
extends JPanel {
    private static final long serialVersionUID = 7427623691049062988L;
    private LogHandler logHandler = new LogHandler();
    private Icon iconClean;
    private Icon iconError;
    private Icon icon;
    private LogRecord record;
    private long recordTime;
    private int minimumErrorDelay = 1000;
    private boolean showMessage = false;
    private Timer blinkerTimer;
    private int blinkCount = 15;
    private int blinkDelay = 200;
    private Beeper beeper = new Beeper();
    private JLabel jLabelMessage = null;
    private JMenuItem jMenuItemClear = null;
    private JPanel jPanelStatus = null;
    private JLabel jLabelStatus = null;

    public ErrorMonitorPanel() {
        this.initialize();
        this.initErrorMonitor();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 2);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 0;
        this.jLabelMessage = new JLabel();
        this.jLabelMessage.setText("JLabel");
        this.jLabelMessage.setFont(new Font("Dialog", 0, 12));
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(248, 53));
        this.add((Component)this.jLabelMessage, gridBagConstraints1);
        this.add((Component)this.getJPanelStatus(), gridBagConstraints2);
    }

    protected void initErrorMonitor() {
        Class<SwingUtilities> swingUtilsClass;
        Level levelFine = Level.FINE;
        if (levelFine == null) {
            // empty if block
        }
        if ((swingUtilsClass = SwingUtilities.class) == null) {
            // empty if block
        }
        this.iconClean = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/green-ball.gif"));
        this.iconError = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/picError.gif"));
        ToolTipManager.sharedInstance().registerComponent(this);
        JPanel panelStatus = this.getJPanelStatus();
        this.jLabelStatus.setIcon(this.iconClean);
        this.jLabelStatus.setText("");
        Dimension dim = new Dimension(16, 16);
        panelStatus.setPreferredSize(dim);
        panelStatus.setMinimumSize(dim);
        panelStatus.setMaximumSize(dim);
        this.jLabelMessage.setText("");
        this.blinkerTimer = new Timer(this.blinkDelay, new Blinker());
        this.blinkerTimer.setRepeats(true);
        this.getJMenuItemClear().setEnabled(false);
    }

    public Icon getIconClean() {
        return this.iconClean;
    }

    public void setIconClean(Icon iconClean) {
        this.iconClean = iconClean;
    }

    public Icon getIconError() {
        return this.iconError;
    }

    public void setIconError(Icon iconError) {
        this.iconError = iconError;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    protected void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    protected void publishRecord(LogRecord rec) {
        long ms = System.currentTimeMillis();
        if (this.recordTime > 0L && ms - this.recordTime < (long)this.minimumErrorDelay) {
            return;
        }
        boolean wasError = this.record != null;
        this.record = rec;
        this.recordTime = ms;
        boolean hasError = this.record != null;
        this.refresh();
        if (hasError || wasError != hasError) {
            this.validateStatusBar();
        }
        if (hasError) {
            this.blinkerTimer.start();
            if (!wasError) {
                this.beep();
            }
        }
    }

    public void refresh() {
        LogRecord rec = this.record;
        String msg = null;
        Icon icon = null;
        if (rec != null) {
            Throwable e;
            icon = this.iconError;
            if (!(!this.showMessage || (msg = rec.getMessage()) != null && msg.length() >= 1 || (e = rec.getThrown()) == null || (msg = e.getMessage()) != null && msg.length() >= 1)) {
                msg = "" + e;
            }
        }
        if (icon == null) {
            icon = this.iconClean;
        }
        this.jLabelStatus.setIcon(icon);
        this.icon = icon;
        if (msg == null) {
            msg = "";
        }
        this.jLabelMessage.setText(msg);
        this.getJMenuItemClear().setEnabled(this.record != null);
    }

    protected void validateStatusBar() {
        for (Container comp = this.getParent(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof StatusBar)) continue;
            ((Component)comp).validate();
            comp.repaint();
            return;
        }
    }

    protected void beep() {
        Window win = SwingUtilities.windowForComponent(this);
        if (win == null) {
            return;
        }
        if (!win.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(this.beeper);
    }

    protected void blink() {
        Icon old = this.jLabelStatus.getIcon();
        if (old == this.icon) {
            this.jLabelStatus.setIcon(null);
        } else {
            this.jLabelStatus.setIcon(this.icon);
        }
    }

    @Override
    public String getToolTipText() {
        LogRecord rec = this.record;
        if (rec == null) {
            return "No errors";
        }
        String msg = null;
        Throwable e = rec.getThrown();
        if (e != null) {
            msg = e.toString();
        } else {
            msg = rec.getMessage();
            if (!(msg != null && msg.length() >= 1 || e == null || (msg = e.getMessage()) != null && msg.length() >= 1)) {
                msg = "" + e;
            }
        }
        if (msg == null) {
            msg = "" + rec;
        }
        return msg;
    }

    public int getBlinkCount() {
        return this.blinkCount;
    }

    public void setBlinkCount(int blinkCount) {
        this.blinkCount = blinkCount;
    }

    public int getBlinkDelay() {
        return this.blinkDelay;
    }

    public void setBlinkDelay(int blinkDelay) {
        this.blinkDelay = blinkDelay;
        if (this.blinkerTimer != null) {
            this.blinkerTimer.setDelay(blinkDelay);
        }
    }

    public void clearErrors() {
        this.record = null;
        this.recordTime = 0L;
        this.blinkerTimer.stop();
        this.refresh();
        this.validateStatusBar();
    }

    private JMenuItem getJMenuItemClear() {
        if (this.jMenuItemClear == null) {
            this.jMenuItemClear = new JMenuItem();
            this.jMenuItemClear.setText("Clear");
            this.jMenuItemClear.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/close_window.gif")));
            this.jMenuItemClear.setToolTipText("Clear errors");
            this.jMenuItemClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorMonitorPanel.this.clearErrors();
                }
            });
        }
        return this.jMenuItemClear;
    }

    private JPanel getJPanelStatus() {
        if (this.jPanelStatus == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jLabelStatus = new JLabel();
            this.jLabelStatus.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/genericvariable_obj.gif")));
            this.jLabelStatus.setText("");
            this.jPanelStatus = new JPanel();
            this.jPanelStatus.setLayout(new GridBagLayout());
            this.jPanelStatus.setOpaque(false);
            this.jPanelStatus.add((Component)this.jLabelStatus, gridBagConstraints);
        }
        return this.jPanelStatus;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public LogRecord getCurrentLogRecord() {
        return this.record;
    }

    protected static class Beeper
    implements Runnable {
        protected Beeper() {
        }

        @Override
        public void run() {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected class Blinker
    implements ActionListener {
        private int counter = 0;

        protected Blinker() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (++this.counter >= ErrorMonitorPanel.this.blinkCount) {
                this.counter = 0;
                ErrorMonitorPanel.this.blinkerTimer.stop();
                ErrorMonitorPanel.this.jLabelStatus.setIcon(ErrorMonitorPanel.this.icon);
                return;
            }
            ErrorMonitorPanel.this.blink();
        }
    }

    protected static class LogFilter
    implements Filter {
        protected LogFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            Level level = record.getLevel();
            if (level == Level.SEVERE) {
                return true;
            }
            return level == Level.WARNING;
        }
    }

    protected class LogHandler
    extends Handler {
        public LogHandler() {
            this.setFilter(new LogFilter());
        }

        @Override
        public void publish(LogRecord record) {
            Filter filter = this.getFilter();
            if (filter != null && !filter.isLoggable(record)) {
                return;
            }
            ErrorMonitorPanel.this.publishRecord(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

