/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionListener;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.render.RotatingIconLabel;
import com.spacekiller.util.status.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class ExecutionProgressPanel
extends JPanel {
    private static final long serialVersionUID = -8164314369930526128L;
    private ExecutionManager manager;
    private ExecHandler execHandler = new ExecHandler();
    private Icon iconActive;
    private Icon iconPassive;
    private Timer timer;
    private int refreshDelay = 100;
    private List executions;
    private boolean wasActive = false;
    private JProgressBar progressBar;
    private RotatingIconLabel rotatingIconLabelProgress = null;
    private Insets progressBarInsets = new Insets(2, 2, 1, 1);

    public ExecutionProgressPanel() {
        this.initExecutionProgressPanel();
    }

    public ExecutionManager getManager() {
        return this.manager;
    }

    public synchronized void setManager(ExecutionManager newmanager) {
        if (this.manager == newmanager) {
            return;
        }
        if (this.manager != null) {
            this.manager.removeExecutionListener((ExecutionListener)this.execHandler);
        }
        this.manager = newmanager;
        if (this.manager != null) {
            Execution[] exec = this.manager.getExecutions();
            if (exec != null) {
                for (int i = 0; i < exec.length; ++i) {
                    Execution ex = exec[i];
                    if (ex == null || !ex.isRunning()) continue;
                    this.addExecution(ex);
                }
            }
            this.manager.addExecutionListener((ExecutionListener)this.execHandler);
        }
    }

    protected void initExecutionProgressPanel() {
        this.executions = new ArrayList();
        this.timer = new Timer(this.refreshDelay, new RefreshTimer());
        this.timer.setRepeats(true);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(1000);
        this.progressBar.setValue(0);
        this.progressBar.setPreferredSize(new Dimension(80, 8));
        this.progressBar.setMinimumSize(new Dimension(50, 8));
        this.iconActive = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/exec_progress.gif"));
        this.iconPassive = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/server_stopped.gif"));
        this.rotatingIconLabelProgress = new RotatingIconLabel();
        this.rotatingIconLabelProgress.setIcon(this.iconPassive);
        this.rotatingIconLabelProgress.setDelay(80);
        this.rotatingIconLabelProgress.setThetaIncrement(0.7853981633974483);
        this.rotatingIconLabelProgress.setPreferredSize(new Dimension(22, 16));
        this.rotatingIconLabelProgress.setMinimumSize(this.rotatingIconLabelProgress.getPreferredSize());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.rotatingIconLabelProgress, gbc);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.refresh();
    }

    protected synchronized void addExecution(Execution x) {
        if (x == null) {
            return;
        }
        if (!this.executions.contains(x)) {
            this.executions.add(x);
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    protected synchronized void removeExecution(Execution x) {
        if (this.executions.remove(x) && this.executions.isEmpty()) {
            this.timer.stop();
            this.refresh();
        }
    }

    protected synchronized void refresh() {
        long elapsed = 0L;
        long estimate = 0L;
        int num = this.executions.size();
        boolean active = num > 0;
        for (int i = 0; i < num; ++i) {
            Execution exec = (Execution)this.executions.get(i);
            long ela = exec.getElapsedMillis();
            long est = exec.getEstimatedMillis();
            if (est <= ela) continue;
            elapsed += ela;
            estimate += est;
        }
        double progress = 0.0;
        if (estimate > 0L) {
            progress = (double)elapsed / (double)estimate;
        }
        int val = (int)(progress * 1000.0);
        this.progressBar.setValue(val);
        if (active) {
            if (!this.wasActive) {
                this.wasActive = true;
                this.rotatingIconLabelProgress.start();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                gbc.anchor = 10;
                gbc.insets = this.progressBarInsets;
                this.add((Component)this.progressBar, gbc);
                this.rotatingIconLabelProgress.setIcon(this.iconActive);
                this.validateStatusBar();
            }
        } else if (this.wasActive) {
            this.wasActive = false;
            this.rotatingIconLabelProgress.stop();
            this.remove(this.progressBar);
            this.rotatingIconLabelProgress.setIcon(this.iconPassive);
            this.validateStatusBar();
        }
    }

    protected void validateStatusBar() {
        for (Container comp = this.getParent(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof StatusBar)) continue;
            ((Component)comp).validate();
            comp.repaint();
            return;
        }
    }

    @Override
    public String getToolTipText() {
        Execution exec;
        int num = this.executions.size();
        if (num < 1) {
            return "No tasks";
        }
        if (num == 1 && (exec = (Execution)this.executions.get(0)) != null) {
            String s = exec.getDescription();
            if (s == null || s.length() < 1) {
                s = exec.getName();
            }
            double percent = exec.getProgress() * 100.0;
            percent = (double)Math.round(percent * 10.0) / 10.0;
            s = s + " (" + percent + " %)";
            return s;
        }
        return "" + num + " tasks";
    }

    protected class RefreshTimer
    implements ActionListener {
        protected RefreshTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecutionProgressPanel.this.refresh();
        }
    }

    protected class ExecHandler
    implements ExecutionListener {
        protected ExecHandler() {
        }

        public void executionStarted(Execution x) {
            ExecutionProgressPanel.this.addExecution(x);
        }

        public void executionPaused(Execution x) {
            ExecutionProgressPanel.this.removeExecution(x);
        }

        public void executionResumed(Execution x) {
            ExecutionProgressPanel.this.addExecution(x);
        }

        public void executionStopped(Execution x) {
            ExecutionProgressPanel.this.removeExecution(x);
        }
    }
}

