/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionListener;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.status.ExecutionTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class ExecutionTableViewer
extends JPanel {
    private static final long serialVersionUID = 154429125226985560L;
    private ExecutionTableModel model;
    private ExecutionManager executionManager;
    private ExecHandler execHandler = new ExecHandler();
    private ExecPublisher publisher = new ExecPublisher();
    private Refresher refresher = new Refresher();
    private Timer timer;
    private int refreshDelay = 500;
    private int runningTasks = 0;
    private JScrollPane jScrollPane = null;
    private JTable jTableExec = null;
    private boolean autoScroll = true;
    private boolean autoRemove = true;
    private List toRemove = new ArrayList();
    private JToolBar jToolBar = null;
    private JButton jButtonStop = null;
    private JButton jButtonPause = null;
    private JToggleButton jToggleButtonHold = null;
    private JPanel jPanel = null;
    private JToggleButton jToggleButtonLock = null;
    private JButton jButtonStart = null;
    private static final Logger logger = Logger.getLogger(ExecutionTableViewer.class.getName());

    public ExecutionTableViewer() {
        this.initialize();
        this.initExecutionTableViewer();
    }

    protected void initExecutionTableViewer() {
        FontMetrics fm;
        this.model = new ExecutionTableModel();
        this.getJTableExec().setAutoResizeMode(0);
        this.getJTableExec().setColumnSelectionAllowed(false);
        this.getJTableExec().setRowSelectionAllowed(true);
        this.getJTableExec().setModel(this.model);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        ExecCellRenderer renderer = new ExecCellRenderer();
        TableColumn col = new TableColumn(0, 250, renderer, null);
        col.setHeaderValue("Action");
        columnModel.addColumn(col);
        col = new TableColumn(1, 100, renderer, null);
        col.setHeaderValue("Progress");
        columnModel.addColumn(col);
        col = new TableColumn(2, 90, renderer, null);
        col.setHeaderValue("Elapsed");
        columnModel.addColumn(col);
        col = new TableColumn(3, 90, renderer, null);
        col.setHeaderValue("Remaining");
        columnModel.addColumn(col);
        this.getJTableExec().setColumnModel(columnModel);
        this.getJTableExec().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExecutionTableViewer.this.checkEnable();
            }
        });
        Font font = renderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTableExec().getRowMargin();
            this.getJTableExec().setRowHeight(rowHeight);
        }
        this.getJButtonStart().setEnabled(false);
        this.getJButtonPause().setEnabled(false);
        this.getJButtonStop().setEnabled(false);
        int refreshDelay = 1000;
        this.timer = new Timer(refreshDelay, this.refresher);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(382, 262));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJToolBar(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableExec());
        }
        return this.jScrollPane;
    }

    private JTable getJTableExec() {
        if (this.jTableExec == null) {
            this.jTableExec = new JTable();
        }
        return this.jTableExec;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJButtonStart());
            this.jToolBar.add(this.getJButtonPause());
            this.jToolBar.add(this.getJButtonStop());
            this.jToolBar.add(this.getJPanel());
            this.jToolBar.add(this.getJToggleButtonHold());
            this.jToolBar.add(this.getJToggleButtonLock());
        }
        return this.jToolBar;
    }

    private JButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new JButton();
            this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/stop_task.gif")));
            this.jButtonStop.setToolTipText("Stop task");
            this.jButtonStop.setText("");
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecutionTableViewer.this.stop();
                }
            });
        }
        return this.jButtonStop;
    }

    protected void stop() {
        int c;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        Execution[] exec = new Execution[num];
        for (c = 0; c < num; ++c) {
            int row = rows[c];
            exec[c] = this.model.getExecutionAt(row);
        }
        for (c = 0; c < num; ++c) {
            exec[c].stop();
        }
    }

    protected void pause() {
        int c;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        Execution[] exec = new Execution[num];
        for (c = 0; c < num; ++c) {
            int row = rows[c];
            exec[c] = this.model.getExecutionAt(row);
        }
        for (c = 0; c < num; ++c) {
            exec[c].pause();
        }
    }

    protected void startOrResume() {
        int c;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        Execution[] exec = new Execution[num];
        for (c = 0; c < num; ++c) {
            int row = rows[c];
            exec[c] = this.model.getExecutionAt(row);
        }
        for (c = 0; c < num; ++c) {
            if (exec[c].isPaused()) {
                exec[c].resume();
                continue;
            }
            exec[c].start();
        }
    }

    private JButton getJButtonPause() {
        if (this.jButtonPause == null) {
            this.jButtonPause = new JButton();
            this.jButtonPause.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/pause.gif")));
            this.jButtonPause.setToolTipText("Pause/Resume");
            this.jButtonPause.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecutionTableViewer.this.pause();
                }
            });
        }
        return this.jButtonPause;
    }

    protected ExecHandler getExecHandler() {
        return this.execHandler;
    }

    protected void setExecHandler(ExecHandler execHandler) {
        this.execHandler = execHandler;
    }

    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public synchronized void setExecutionManager(ExecutionManager newExecutionManager) {
        if (this.executionManager != null) {
            this.executionManager.removeExecutionListener((ExecutionListener)this.execHandler);
            if (this.timer != null) {
                this.timer.stop();
            }
        }
        this.executionManager = newExecutionManager;
        this.model.clear();
        this.runningTasks = 0;
        if (this.executionManager != null) {
            Execution[] exec = this.executionManager.getExecutions();
            if (exec != null) {
                int running = 0;
                for (int c = 0; c < exec.length; ++c) {
                    if (exec[c].isRunning()) {
                        ++running;
                    }
                    this.model.addExecution(exec[c]);
                }
                if (running > 0) {
                    this.runningTasks += running;
                    this.startRefreshTimer();
                }
            }
            this.executionManager.addExecutionListener((ExecutionListener)this.execHandler);
        }
    }

    public synchronized void dispose() {
        if (this.executionManager != null) {
            this.executionManager.removeExecutionListener((ExecutionListener)this.execHandler);
        }
        this.executionManager = null;
        this.runningTasks = 0;
        this.model.clear();
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    protected void refresh() {
        this.getJTableExec().repaint();
        if (this.runningTasks < 1 && this.timer != null) {
            this.timer.stop();
        }
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
        if (this.timer != null) {
            this.timer.setDelay(refreshDelay);
        }
    }

    protected void startRefreshTimer() {
        if (!this.timer.isRunning()) {
            this.timer.setDelay(this.refreshDelay);
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    protected String formatTimeMillis(double ms) {
        if (ms < 0.0) {
            return "-";
        }
        StringBuffer sb = new StringBuffer();
        long millis = Math.round(ms);
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            sb.append(Long.toString(hours));
            sb.append(':');
        }
        sb.append(Long.toString(100L + (minutes %= 60L)).substring(1));
        sb.append(':');
        boolean includeMillis = seconds < 2L;
        sb.append(Long.toString(100L + (seconds %= 60L)).substring(1));
        if (includeMillis) {
            sb.append('.');
            sb.append(Long.toString(1000L + (millis %= 1000L)).substring(1));
        }
        return sb.toString();
    }

    private JToggleButton getJToggleButtonHold() {
        if (this.jToggleButtonHold == null) {
            this.jToggleButtonHold = new JToggleButton();
            this.jToggleButtonHold.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/clear_log.gif")));
            this.jToggleButtonHold.setToolTipText("Hold completed tasks");
            this.jToggleButtonHold.setSelected(false);
            this.jToggleButtonHold.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExecutionTableViewer.this.setAutoRemove(!ExecutionTableViewer.this.getJToggleButtonHold().isSelected());
                    if (ExecutionTableViewer.this.autoRemove) {
                        ExecutionTableViewer.this.removeCompletedTasks();
                    }
                }
            });
        }
        return this.jToggleButtonHold;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setSize(new Dimension(10, 10));
            this.jPanel.setOpaque(false);
            this.jPanel.setMaximumSize(new Dimension(10, 10));
        }
        return this.jPanel;
    }

    private JToggleButton getJToggleButtonLock() {
        if (this.jToggleButtonLock == null) {
            this.jToggleButtonLock = new JToggleButton();
            this.jToggleButtonLock.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/lock.gif")));
            this.jToggleButtonLock.setToolTipText("Lock scroll position");
            this.jToggleButtonLock.setSelected(false);
            this.jToggleButtonLock.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExecutionTableViewer.this.setAutoScroll(!ExecutionTableViewer.this.getJToggleButtonLock().isSelected());
                }
            });
        }
        return this.jToggleButtonLock;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    protected void removeCompletedTasks() {
        Object[] tasks = this.toRemove.toArray();
        this.toRemove.clear();
        int num = tasks.length;
        for (int c = 0; c < num; ++c) {
            Execution exec = (Execution)tasks[c];
            this.model.removeExecution(exec);
        }
    }

    private JButton getJButtonStart() {
        if (this.jButtonStart == null) {
            this.jButtonStart = new JButton();
            this.jButtonStart.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/run.gif")));
            this.jButtonStart.setToolTipText("Start task");
            this.jButtonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecutionTableViewer.this.startOrResume();
                }
            });
        }
        return this.jButtonStart;
    }

    protected void checkEnable() {
        boolean enableStart = false;
        boolean enablePause = false;
        boolean enableStop = false;
        int[] rows = this.getJTableExec().getSelectedRows();
        int num = rows.length;
        if (num > 0) {
            enableStart = true;
            enablePause = true;
            enableStop = true;
            for (int c = 0; c < num; ++c) {
                int row = rows[c];
                Execution exec = this.model.getExecutionAt(row);
                if (exec == null) continue;
                if (exec.isRunning()) {
                    enableStart = false;
                    continue;
                }
                if (exec.isPaused()) {
                    enablePause = false;
                    continue;
                }
                enableStop = false;
            }
        }
        this.getJButtonStart().setEnabled(enableStart);
        this.getJButtonPause().setEnabled(enablePause);
        this.getJButtonStop().setEnabled(enableStop);
    }

    protected class TestExecution
    extends AbstractExecution {
        private int num;
        private int delay;
        private int pos;

        public TestExecution() {
            this.setName("Test: " + (Object)((Object)this));
            this.setDescription("Just a test..");
            this.setPauseSupported(true);
            this.setStopSupported(true);
            this.num = 100 + (int)(Math.random() * 2000.0);
            this.delay = 50;
            this.pos = 0;
        }

        protected void execute() throws Exception {
            try {
                while (this.pos < this.num && this.getSignal() == 0) {
                    this.setProgress((double)this.pos / (double)this.num);
                    Thread.sleep(this.delay);
                    ++this.pos;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.addException(e);
            }
        }
    }

    protected class Refresher
    implements ActionListener {
        protected Refresher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecutionTableViewer.this.refresh();
        }
    }

    protected class ExecCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7656374454923955131L;
        private JProgressBar progressBar;
        private int MAX = 1000;
        private int row;

        public ExecCellRenderer() {
            this.initExecCellRenderer();
        }

        protected void initExecCellRenderer() {
            this.progressBar = new JProgressBar();
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.MAX);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            long v;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.row = row;
            Icon icon = null;
            TableColumn col = table.getColumnModel().getColumn(column);
            int colIndex = col.getModelIndex();
            if (colIndex == 1 && value instanceof Double) {
                double v2 = (Double)value;
                this.progressBar.setValue((int)(v2 * (double)this.MAX));
                return this.progressBar;
            }
            if (colIndex == 2 && value instanceof Long) {
                v = (Long)value;
                this.setText(ExecutionTableViewer.this.formatTimeMillis(v));
            }
            if (colIndex == 3 && value instanceof Long) {
                v = (Long)value;
                this.setText(ExecutionTableViewer.this.formatTimeMillis(v));
            }
            this.setIcon(icon);
            return this;
        }

        @Override
        public String getToolTipText() {
            Execution exec;
            int row = this.row;
            if (row >= 0 && row < ExecutionTableViewer.this.model.getRowCount() && (exec = ExecutionTableViewer.this.model.getExecutionAt(row)) != null) {
                String descr = exec.getDescription();
                if (descr != null && descr.length() > 0) {
                    return descr;
                }
                String status = exec.getStatus();
                if (status != null && status.length() > 0) {
                    return status;
                }
            }
            return super.getToolTipText();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.getToolTipText();
        }
    }

    protected class ExecPublisher
    implements Runnable {
        private LinkedList listAdd = new LinkedList();
        private LinkedList listAdd2 = new LinkedList();
        private LinkedList listRemove = new LinkedList();
        private LinkedList listRemove2 = new LinkedList();
        private boolean todo = false;

        protected ExecPublisher() {
        }

        public synchronized void add(Execution x) {
            this.listAdd.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        public synchronized void remove(Execution x) {
            this.listRemove.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object rect;
            Execution rec;
            LinkedList l = this.listAdd;
            ExecPublisher execPublisher = this;
            synchronized (execPublisher) {
                this.listAdd = this.listAdd2;
                this.listAdd2 = l;
                this.todo = false;
            }
            int row = -1;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                rec = (Execution)i.next();
                i.remove();
                row = ExecutionTableViewer.this.model.getRowCount();
                ExecutionTableViewer.this.model.addExecution(rec);
            }
            if (row >= 0 && ExecutionTableViewer.this.autoScroll) {
                rect = ExecutionTableViewer.this.getJTableExec().getCellRect(row, 0, true);
                ExecutionTableViewer.this.getJTableExec().scrollRectToVisible((Rectangle)rect);
            }
            l = this.listRemove;
            rect = this;
            synchronized (rect) {
                this.listRemove = this.listRemove2;
                this.listRemove2 = l;
                this.todo = false;
            }
            i = l.iterator();
            while (i.hasNext()) {
                rec = (Execution)i.next();
                i.remove();
                ExecutionTableViewer.this.model.removeExecution(rec);
            }
            ExecutionTableViewer.this.checkEnable();
        }
    }

    protected class ExecHandler
    implements ExecutionListener {
        protected ExecHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionStarted(Execution x) {
            ExecHandler execHandler = this;
            synchronized (execHandler) {
                ExecutionTableViewer.this.runningTasks++;
            }
            ExecutionTableViewer.this.publisher.add(x);
            ExecutionTableViewer.this.startRefreshTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionStopped(Execution x) {
            ExecHandler execHandler = this;
            synchronized (execHandler) {
                if (ExecutionTableViewer.this.runningTasks > 0) {
                    ExecutionTableViewer.this.runningTasks--;
                }
            }
            if (ExecutionTableViewer.this.autoRemove) {
                ExecutionTableViewer.this.publisher.remove(x);
            } else {
                execHandler = this;
                synchronized (execHandler) {
                    ExecutionTableViewer.this.toRemove.add(x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionPaused(Execution x) {
            ExecHandler execHandler = this;
            synchronized (execHandler) {
                if (ExecutionTableViewer.this.runningTasks > 0) {
                    ExecutionTableViewer.this.runningTasks--;
                }
            }
            ExecutionTableViewer.this.checkEnable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionResumed(Execution x) {
            ExecHandler execHandler = this;
            synchronized (execHandler) {
                ExecutionTableViewer.this.runningTasks++;
            }
            ExecutionTableViewer.this.startRefreshTimer();
            ExecutionTableViewer.this.checkEnable();
        }
    }
}

