/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.Data;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class LogRecordTableModel
implements TableModel {
    public static final int COLUMN_LEVEL = 0;
    public static final int COLUMN_MESSAGE = 1;
    public static final int COLUMN_THREAD = 2;
    public static final int COLUMN_LOGGER = 3;
    public static final int COLUMN_CLASS = 4;
    public static final int COLUMN_METHOD = 5;
    public static final int COLUMN_TIME = 6;
    public static final int COLUMNS = 7;
    private List records = new ArrayList();
    private int columnCount = 7;
    private transient List tableModelListeners;

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return String.class;
            }
            case 0: {
                return Level.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return "Message";
            }
            case 0: {
                return "Level";
            }
            case 2: {
                return "Thread";
            }
            case 3: {
                return "Log";
            }
            case 4: {
                return "Class";
            }
            case 5: {
                return "Method";
            }
            case 6: {
                return "Time";
            }
        }
        return "Column" + columnIndex;
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LogRecord rec = this.getLogRecordAt(rowIndex);
        if (rec == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return rec.getMessage();
            }
            case 0: {
                return rec.getLevel();
            }
            case 2: {
                return Data.toInteger((int)rec.getThreadID());
            }
            case 3: {
                return rec.getLoggerName();
            }
            case 4: {
                return rec.getSourceClassName();
            }
            case 5: {
                return rec.getSourceMethodName();
            }
            case 6: {
                return String.valueOf(new Timestamp(rec.getMillis()));
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    protected LogRecord getLogRecordAt(int i) {
        return (LogRecord)this.records.get(i);
    }

    public synchronized void addRecord(LogRecord rec) {
        int row = this.records.size();
        this.records.add(rec);
        this.fireTableRowsInserted(row, row);
    }

    public synchronized void removeRecordAt(int i) {
        this.records.remove(i);
        this.fireTableRowsDeleted(i, i);
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (this.tableModelListeners == null) {
            return;
        }
        int currentSize = this.tableModelListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            TableModelListener ls = (TableModelListener)this.tableModelListeners.get(index);
            if (ls == null) continue;
            ls.tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new LinkedList();
        }
        this.tableModelListeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    public TableModelListener[] getTableModelListeners() {
        if (this.tableModelListeners == null) {
            return new TableModelListener[0];
        }
        return this.tableModelListeners.toArray(new TableModelListener[this.tableModelListeners.size()]);
    }

    public synchronized void clear() {
        if (this.records.isEmpty()) {
            return;
        }
        int num = this.records.size();
        this.records.clear();
        this.fireTableRowsDeleted(0, num - 1);
    }
}

