/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class MemoryMonitor
extends JComponent {
    private static final long serialVersionUID = 7729343142076156469L;
    private Runtime runtime;
    private Timer timer;
    private ComponentHandler componentHandler = new ComponentHandler();
    private int refreshDelay = 1000;
    private Refresher refresher = new Refresher();
    private MouseHandler mouseHandler = new MouseHandler();
    private Window window;
    private WindowHandler windowHandler = new WindowHandler();
    private Entry[] entries = new Entry[1];
    private int firstIndex = 0;
    private int nextIndex = 0;
    private static final Logger logger = Logger.getLogger(MemoryMonitor.class.getName());

    public MemoryMonitor() {
        this.initMemoryMonitor();
    }

    protected void initMemoryMonitor() {
        this.addMouseListener(this.mouseHandler);
        this.runtime = Runtime.getRuntime();
        this.timer = new Timer(this.refreshDelay, this.refresher);
        this.timer.setRepeats(true);
        this.setPreferredSize(new Dimension(40, 16));
        this.entries = new Entry[this.getPreferredSize().width + 1];
        for (int c = 0; c < this.entries.length; ++c) {
            this.entries[c] = new Entry();
        }
        this.setToolTipText("Memory monitor");
        ToolTipManager.sharedInstance().registerComponent(this);
        this.refresh();
        this.addComponentListener(this.componentHandler);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                MemoryMonitor.this.initParent();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintMemoryGraph(g);
    }

    protected void paintMemoryGraph(Graphics g) {
        g.setColor(Color.yellow);
        this.paintTotalMemoryGraph(g);
        g.setColor(Color.green);
        this.paintUsedMemoryGraph(g);
    }

    protected void paintTotalMemoryGraph(Graphics g) {
        int h = this.getHeight();
        int first = this.firstIndex;
        int next = this.nextIndex;
        int len = this.entries.length;
        long max = this.runtime.maxMemory();
        int lastY = h;
        int x = -1;
        if (first <= next) {
            for (int i = first; i < next; ++i) {
                long mem = this.entries[i].total;
                double d = (double)mem / (double)max;
                int y = h - (int)((double)h * d);
                if (i == first) {
                    lastY = y;
                }
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
        } else {
            int y;
            double d;
            long mem;
            int i;
            for (i = first; i < len; ++i) {
                mem = this.entries[i].total;
                d = (double)mem / (double)max;
                y = h - (int)((double)h * d);
                if (i == first) {
                    lastY = y;
                }
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
            for (i = 0; i < next; ++i) {
                mem = this.entries[i].total;
                d = (double)mem / (double)max;
                y = h - (int)((double)h * d);
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
        }
    }

    protected void paintUsedMemoryGraph(Graphics g) {
        int h = this.getHeight();
        int first = this.firstIndex;
        int next = this.nextIndex;
        int len = this.entries.length;
        long max = this.runtime.maxMemory();
        int lastY = h;
        int x = -1;
        if (first <= next) {
            for (int i = first; i < next; ++i) {
                long mem = Math.max(0L, this.entries[i].total - this.entries[i].free);
                double d = (double)mem / (double)max;
                int y = h - (int)((double)h * d);
                if (i == first) {
                    lastY = y;
                }
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
        } else {
            int y;
            double d;
            long mem;
            int i;
            for (i = first; i < len; ++i) {
                mem = Math.max(0L, this.entries[i].total - this.entries[i].free);
                d = (double)mem / (double)max;
                y = h - (int)((double)h * d);
                if (i == first) {
                    lastY = y;
                }
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
            for (i = 0; i < next; ++i) {
                mem = Math.max(0L, this.entries[i].total - this.entries[i].free);
                d = (double)mem / (double)max;
                y = h - (int)((double)h * d);
                g.drawLine(x++, lastY, x, y);
                lastY = y;
            }
        }
    }

    public void refresh() {
        Entry entry = this.entries[this.nextIndex++];
        entry.free = this.runtime.freeMemory();
        entry.total = this.runtime.totalMemory();
        if (this.nextIndex >= this.entries.length) {
            this.nextIndex = 0;
        }
        if (this.nextIndex == this.firstIndex) {
            ++this.firstIndex;
            if (this.firstIndex >= this.entries.length) {
                this.firstIndex = 0;
            }
        }
        this.validate();
        this.repaint();
    }

    protected void startMonitor() {
        this.timer.start();
    }

    protected void stopMonitor() {
        this.timer.stop();
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
        this.timer.setDelay(refreshDelay);
    }

    @Override
    public String getToolTipText() {
        long free = this.runtime.freeMemory();
        long total = this.runtime.totalMemory();
        long max = this.runtime.maxMemory();
        long used = Math.max(0L, total - free);
        String text = "Memory: " + this.getMemString(used) + " used, " + this.getMemString(total) + " allocated, " + this.getMemString(max) + " limit";
        return text;
    }

    protected String getMemString(long mem) {
        double mb = (double)mem / 1024.0 / 1024.0;
        double d = (double)Math.round(mb * 10.0) / 10.0;
        return "" + d + " MB";
    }

    protected void initParent() {
        Window win = SwingUtilities.windowForComponent(this);
        if (win == this.window) {
            return;
        }
        if (this.window != null) {
            this.window.removeWindowListener(this.windowHandler);
        }
        this.window = win;
        if (win != null) {
            win.addWindowListener(this.windowHandler);
        }
    }

    protected void showPopupMenu(Component comp, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemGC = new JMenuItem("Garbage Collection");
        itemGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryMonitor.this.runGarbageCollection();
            }
        });
        itemGC.setIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/status/icons/recycle.gif"));
        popup.add(itemGC);
        popup.show(comp, x, y);
    }

    protected void runGarbageCollection() {
        boolean info = logger.isLoggable(Level.INFO);
        if (info) {
            logger.info("Running garbage collection...");
        }
        this.runtime.gc();
        if (info) {
            logger.info("Garbage collection completed.");
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                MemoryMonitor.this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                MemoryMonitor.this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() != 2 || e.getButton() == 1) {
                // empty if block
            }
        }
    }

    protected static class Entry {
        public long free;
        public long total;

        protected Entry() {
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            MemoryMonitor.this.startMonitor();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            MemoryMonitor.this.stopMonitor();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            super.windowActivated(e);
            MemoryMonitor.this.startMonitor();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            super.windowDeactivated(e);
            MemoryMonitor.this.stopMonitor();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            super.windowOpened(e);
            MemoryMonitor.this.startMonitor();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
            MemoryMonitor.this.stopMonitor();
        }
    }

    protected class Refresher
    implements ActionListener {
        protected Refresher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MemoryMonitor.this.refresh();
        }
    }
}

