/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.status.StatusLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JPanel;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 8024106095831135056L;
    private Paint backgroundPaint = null;

    public StatusBar() {
        this.initStatusBar();
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    protected void initStatusBar() {
        this.setLayout(new StatusLayout());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.getLayout().preferredLayoutSize(this);
        Dimension min = this.getMinimumSize();
        if (dim.height < min.height) {
            dim.height = min.height;
        }
        Dimension max = this.getMaximumSize();
        if (dim.height > max.height) {
            dim.height = max.height;
        }
        return dim;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint paint = this.getBackgroundPaint();
        if (paint != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setBackgroundPaint(Paint newBackgroundPaint) {
        this.backgroundPaint = newBackgroundPaint;
    }
}

